/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.CommandListenerWriter;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.StatefulRedisConnectionImpl;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.event.connection.ReauthenticationEvent;
import io.lettuce.core.event.connection.ReauthenticationFailedEvent;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandExpiryWriter;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.Endpoint;
import io.lettuce.core.protocol.ProtocolVersion;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public class RedisAuthenticationHandler<K, V> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RedisAuthenticationHandler.class);
    private final StatefulRedisConnectionImpl<K, V> connection;
    private final RedisCredentialsProvider credentialsProvider;
    private final AtomicReference<Disposable> credentialsSubscription = new AtomicReference();
    private final Boolean isPubSubConnection;
    private final AtomicReference<RedisCredentials> credentialsRef = new AtomicReference();
    private final ReentrantLock reAuthSafety = new ReentrantLock();
    private final AtomicBoolean inTransaction = new AtomicBoolean(false);

    public RedisAuthenticationHandler(StatefulRedisConnectionImpl<K, V> connection, RedisCredentialsProvider credentialsProvider, Boolean isPubSubConnection) {
        this.connection = connection;
        this.credentialsProvider = credentialsProvider;
        this.isPubSubConnection = isPubSubConnection;
    }

    public static <K, V> RedisAuthenticationHandler<K, V> createHandler(StatefulRedisConnectionImpl<K, V> connection, RedisCredentialsProvider credentialsProvider, Boolean isPubSubConnection, ClientOptions options) {
        if (RedisAuthenticationHandler.isSupported(options)) {
            if (isPubSubConnection.booleanValue() && options.getConfiguredProtocolVersion() == ProtocolVersion.RESP2) {
                throw new RedisConnectionException("Renewable credentials are not supported with RESP2 protocol on a pub/sub connection.");
            }
            return new RedisAuthenticationHandler<K, V>(connection, credentialsProvider, isPubSubConnection);
        }
        return null;
    }

    public static <K, V> RedisAuthenticationHandler<K, V> createDefaultAuthenticationHandler() {
        return new DisabledAuthenticationHandler();
    }

    public void subscribe() {
        if (this.credentialsProvider == null || !this.credentialsProvider.supportsStreaming()) {
            return;
        }
        if (!this.isSupportedConnection()) {
            return;
        }
        Flux<RedisCredentials> credentialsFlux = this.credentialsProvider.credentials();
        Disposable subscription = credentialsFlux.subscribe(this::onNext, this::onError, this::complete);
        Disposable oldSubscription = this.credentialsSubscription.getAndSet(subscription);
        if (oldSubscription != null && !oldSubscription.isDisposed()) {
            oldSubscription.dispose();
        }
    }

    public void unsubscribe() {
        Disposable subscription = this.credentialsSubscription.getAndSet(null);
        if (subscription != null && !subscription.isDisposed()) {
            subscription.dispose();
        }
    }

    protected void complete() {
        log.debug("Credentials stream completed");
    }

    protected void onNext(RedisCredentials credentials) {
        this.reauthenticate(credentials);
    }

    protected void onError(Throwable e) {
        log.error("Credentials renew failed.", e);
        this.publishReauthFailedEvent(e);
    }

    protected void reauthenticate(RedisCredentials credentials) {
        this.setCredentials(credentials);
    }

    boolean isSupportedConnection() {
        if (this.isPubSubConnection.booleanValue() && ProtocolVersion.RESP2 == this.connection.getConnectionState().getNegotiatedProtocolVersion()) {
            log.warn("Renewable credentials are not supported with RESP2 protocol on a pub/sub connection.");
            return false;
        }
        return true;
    }

    private static boolean isSupported(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        switch (clientOptions.getReauthenticateBehaviour()) {
            case ON_NEW_CREDENTIALS: {
                return true;
            }
        }
        return false;
    }

    protected void postProcess(RedisCommand<K, V, ?> toSend) {
        if (toSend.getType() == CommandType.EXEC || toSend.getType() == CommandType.DISCARD) {
            this.inTransaction.set(false);
            this.setCredentials(this.credentialsRef.getAndSet(null));
        }
    }

    protected void postProcess(Collection<? extends RedisCommand<K, V, ?>> dispatched) {
        Boolean transactionComplete = null;
        for (RedisCommand<K, V, ?> command : dispatched) {
            if (command.getType() == CommandType.EXEC || command.getType() == CommandType.DISCARD) {
                transactionComplete = true;
            }
            if (command.getType() != CommandType.MULTI) continue;
            transactionComplete = false;
        }
        if (transactionComplete != null && transactionComplete.booleanValue()) {
            this.inTransaction.set(false);
            this.setCredentials(this.credentialsRef.getAndSet(null));
        }
    }

    public void startTransaction() {
        this.reAuthSafety.lock();
        try {
            this.inTransaction.set(true);
        }
        finally {
            this.reAuthSafety.unlock();
        }
    }

    public void endTransaction() {
        this.inTransaction.set(false);
        this.setCredentials(this.credentialsRef.getAndSet(null));
    }

    public void setCredentials(RedisCredentials credentials) {
        if (credentials == null) {
            return;
        }
        this.reAuthSafety.lock();
        try {
            this.credentialsRef.set(credentials);
            if (!this.inTransaction.get()) {
                this.dispatchAuth(this.credentialsRef.getAndSet(null));
            }
        }
        finally {
            this.reAuthSafety.unlock();
        }
    }

    protected void dispatchAuth(RedisCredentials credentials) {
        if (credentials == null) {
            return;
        }
        RedisCommand<K, V, String> auth = this.connection.getChannelWriter().write(this.authCommand(credentials));
        if (auth instanceof CompleteableCommand) {
            ((CompleteableCommand)((Object)auth)).onComplete((status, throwable) -> {
                if (throwable != null) {
                    log.error("Re-authentication failed {}.", (Object)this.getEpid(), throwable);
                    this.publishReauthFailedEvent((Throwable)throwable);
                } else {
                    log.info("Re-authentication succeeded {}.", (Object)this.getEpid());
                    this.publishReauthEvent();
                }
            });
        }
    }

    private AsyncCommand<K, V, String> authCommand(RedisCredentials credentials) {
        RedisCodec<K, V> codec = this.connection.getCodec();
        CommandArgs<K, V> args = new CommandArgs<K, V>(codec);
        if (credentials.getUsername() != null) {
            args.add(credentials.getUsername()).add(credentials.getPassword());
        } else {
            args.add(credentials.getPassword());
        }
        return new AsyncCommand(new Command(CommandType.AUTH, new StatusOutput<K, V>(codec), args));
    }

    private void publishReauthEvent() {
        this.connection.getResources().eventBus().publish(new ReauthenticationEvent(this.getEpid()));
    }

    private void publishReauthFailedEvent(Throwable throwable) {
        this.connection.getResources().eventBus().publish(new ReauthenticationFailedEvent(this.getEpid(), throwable));
    }

    private String getEpid() {
        RedisChannelWriter writer = this.connection.getChannelWriter();
        while (!(writer instanceof Endpoint)) {
            if (writer instanceof CommandListenerWriter) {
                writer = ((CommandListenerWriter)writer).getDelegate();
                continue;
            }
            if (writer instanceof CommandExpiryWriter) {
                writer = ((CommandExpiryWriter)writer).getDelegate();
                continue;
            }
            return null;
        }
        return ((Endpoint)((Object)writer)).getId();
    }

    private static final class DisabledAuthenticationHandler<K, V>
    extends RedisAuthenticationHandler<K, V> {
        public DisabledAuthenticationHandler(StatefulRedisConnectionImpl<K, V> connection, RedisCredentialsProvider credentialsProvider, Boolean isPubSubConnection) {
            super(null, null, null);
        }

        public DisabledAuthenticationHandler() {
            super(null, null, null);
        }

        @Override
        protected void postProcess(RedisCommand<K, V, ?> toSend) {
        }

        @Override
        protected void postProcess(Collection<? extends RedisCommand<K, V, ?>> dispatched) {
        }

        @Override
        public void startTransaction() {
        }

        @Override
        public void endTransaction() {
        }

        @Override
        public void setCredentials(RedisCredentials credentials) {
        }

        @Override
        public void unsubscribe() {
        }

        @Override
        public void subscribe() {
        }
    }
}

