/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.Range;
import io.lettuce.core.annotations.Experimental;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental
public class HotkeysReply {
    private final boolean trackingActive;
    private final int sampleRatio;
    private final List<Range<Integer>> selectedSlots;
    private final Long sampledCommandSelectedSlotsUs;
    private final Long allCommandsSelectedSlotsUs;
    private final Long allCommandsAllSlotsUs;
    private final Long netBytesSampledCommandsSelectedSlots;
    private final Long netBytesAllCommandsSelectedSlots;
    private final Long netBytesAllCommandsAllSlots;
    private final Long collectionStartTimeUnixMs;
    private final Long collectionDurationMs;
    private final Long totalCpuTimeUserMs;
    private final Long totalCpuTimeSysMs;
    private final Long totalNetBytes;
    private final Map<String, Long> byCpuTimeUs;
    private final Map<String, Long> byNetBytes;

    public HotkeysReply(boolean trackingActive, int sampleRatio, List<Range<Integer>> selectedSlots, Long sampledCommandSelectedSlotsUs, Long allCommandsSelectedSlotsUs, Long allCommandsAllSlotsUs, Long netBytesSampledCommandsSelectedSlots, Long netBytesAllCommandsSelectedSlots, Long netBytesAllCommandsAllSlots, Long collectionStartTimeUnixMs, Long collectionDurationMs, Long totalCpuTimeUserMs, Long totalCpuTimeSysMs, Long totalNetBytes, Map<String, Long> byCpuTimeUs, Map<String, Long> byNetBytes) {
        this.trackingActive = trackingActive;
        this.sampleRatio = sampleRatio;
        this.selectedSlots = selectedSlots != null ? Collections.unmodifiableList(selectedSlots) : Collections.emptyList();
        this.sampledCommandSelectedSlotsUs = sampledCommandSelectedSlotsUs;
        this.allCommandsSelectedSlotsUs = allCommandsSelectedSlotsUs;
        this.allCommandsAllSlotsUs = allCommandsAllSlotsUs;
        this.netBytesSampledCommandsSelectedSlots = netBytesSampledCommandsSelectedSlots;
        this.netBytesAllCommandsSelectedSlots = netBytesAllCommandsSelectedSlots;
        this.netBytesAllCommandsAllSlots = netBytesAllCommandsAllSlots;
        this.collectionStartTimeUnixMs = collectionStartTimeUnixMs;
        this.collectionDurationMs = collectionDurationMs;
        this.totalCpuTimeUserMs = totalCpuTimeUserMs;
        this.totalCpuTimeSysMs = totalCpuTimeSysMs;
        this.totalNetBytes = totalNetBytes;
        this.byCpuTimeUs = byCpuTimeUs != null ? Collections.unmodifiableMap(byCpuTimeUs) : Collections.emptyMap();
        this.byNetBytes = byNetBytes != null ? Collections.unmodifiableMap(byNetBytes) : Collections.emptyMap();
    }

    public boolean isTrackingActive() {
        return this.trackingActive;
    }

    public int getSampleRatio() {
        return this.sampleRatio;
    }

    public List<Range<Integer>> getSelectedSlots() {
        return this.selectedSlots;
    }

    public Long getSampledCommandSelectedSlotsUs() {
        return this.sampledCommandSelectedSlotsUs;
    }

    public Long getAllCommandsSelectedSlotsUs() {
        return this.allCommandsSelectedSlotsUs;
    }

    public Long getAllCommandsAllSlotsUs() {
        return this.allCommandsAllSlotsUs;
    }

    public Long getNetBytesSampledCommandsSelectedSlots() {
        return this.netBytesSampledCommandsSelectedSlots;
    }

    public Long getNetBytesAllCommandsSelectedSlots() {
        return this.netBytesAllCommandsSelectedSlots;
    }

    public Long getNetBytesAllCommandsAllSlots() {
        return this.netBytesAllCommandsAllSlots;
    }

    public Long getCollectionStartTimeUnixMs() {
        return this.collectionStartTimeUnixMs;
    }

    public Long getCollectionDurationMs() {
        return this.collectionDurationMs;
    }

    public Long getTotalCpuTimeUserMs() {
        return this.totalCpuTimeUserMs;
    }

    public Long getTotalCpuTimeSysMs() {
        return this.totalCpuTimeSysMs;
    }

    public Long getTotalNetBytes() {
        return this.totalNetBytes;
    }

    public Map<String, Long> getByCpuTimeUs() {
        return this.byCpuTimeUs;
    }

    public Map<String, Long> getByNetBytes() {
        return this.byNetBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HotkeysReply)) {
            return false;
        }
        HotkeysReply that = (HotkeysReply)o;
        return this.trackingActive == that.trackingActive && this.sampleRatio == that.sampleRatio && Objects.equals(this.selectedSlots, that.selectedSlots) && Objects.equals(this.sampledCommandSelectedSlotsUs, that.sampledCommandSelectedSlotsUs) && Objects.equals(this.allCommandsSelectedSlotsUs, that.allCommandsSelectedSlotsUs) && Objects.equals(this.allCommandsAllSlotsUs, that.allCommandsAllSlotsUs) && Objects.equals(this.netBytesSampledCommandsSelectedSlots, that.netBytesSampledCommandsSelectedSlots) && Objects.equals(this.netBytesAllCommandsSelectedSlots, that.netBytesAllCommandsSelectedSlots) && Objects.equals(this.netBytesAllCommandsAllSlots, that.netBytesAllCommandsAllSlots) && Objects.equals(this.collectionStartTimeUnixMs, that.collectionStartTimeUnixMs) && Objects.equals(this.collectionDurationMs, that.collectionDurationMs) && Objects.equals(this.totalCpuTimeUserMs, that.totalCpuTimeUserMs) && Objects.equals(this.totalCpuTimeSysMs, that.totalCpuTimeSysMs) && Objects.equals(this.totalNetBytes, that.totalNetBytes) && Objects.equals(this.byCpuTimeUs, that.byCpuTimeUs) && Objects.equals(this.byNetBytes, that.byNetBytes);
    }

    public int hashCode() {
        return Objects.hash(this.trackingActive, this.sampleRatio, this.selectedSlots, this.sampledCommandSelectedSlotsUs, this.allCommandsSelectedSlotsUs, this.allCommandsAllSlotsUs, this.netBytesSampledCommandsSelectedSlots, this.netBytesAllCommandsSelectedSlots, this.netBytesAllCommandsAllSlots, this.collectionStartTimeUnixMs, this.collectionDurationMs, this.totalCpuTimeUserMs, this.totalCpuTimeSysMs, this.totalNetBytes, this.byCpuTimeUs, this.byNetBytes);
    }

    public String toString() {
        return "HotkeysReply{trackingActive=" + this.trackingActive + ", sampleRatio=" + this.sampleRatio + ", selectedSlots=" + this.selectedSlots + ", sampledCommandSelectedSlotsUs=" + this.sampledCommandSelectedSlotsUs + ", allCommandsSelectedSlotsUs=" + this.allCommandsSelectedSlotsUs + ", allCommandsAllSlotsUs=" + this.allCommandsAllSlotsUs + ", netBytesSampledCommandsSelectedSlots=" + this.netBytesSampledCommandsSelectedSlots + ", netBytesAllCommandsSelectedSlots=" + this.netBytesAllCommandsSelectedSlots + ", netBytesAllCommandsAllSlots=" + this.netBytesAllCommandsAllSlots + ", collectionStartTimeUnixMs=" + this.collectionStartTimeUnixMs + ", collectionDurationMs=" + this.collectionDurationMs + ", totalCpuTimeUserMs=" + this.totalCpuTimeUserMs + ", totalCpuTimeSysMs=" + this.totalCpuTimeSysMs + ", totalNetBytes=" + this.totalNetBytes + ", byCpuTimeUs=" + this.byCpuTimeUs + ", byNetBytes=" + this.byNetBytes + '}';
    }
}

