/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

@Experimental
public class HotkeysArgs
implements CompositeArgument {
    public static final int COUNT_MIN = 10;
    public static final int COUNT_MAX = 64;
    public static final long DURATION_MIN = 0L;
    public static final int SAMPLE_MIN = 1;
    public static final int SLOT_MIN = 0;
    public static final int SLOT_MAX = 16383;
    public static final int SLOTS_MAX_COUNT = 16384;
    private Set<Metric> metrics;
    private Integer count;
    private Long duration;
    private Integer sample;
    private List<Integer> slots;

    public HotkeysArgs metrics(Metric ... metrics) {
        LettuceAssert.notNull((Object)metrics, "Metrics must not be null");
        LettuceAssert.isTrue(metrics.length >= 1 && metrics.length <= 2, "Metrics count must be between 1 and 2");
        this.metrics = EnumSet.noneOf(Metric.class);
        for (Metric metric : metrics) {
            this.metrics.add(metric);
        }
        return this;
    }

    public HotkeysArgs count(int count) {
        LettuceAssert.isTrue(count >= 10 && count <= 64, "Count must be between 10 and 64");
        this.count = count;
        return this;
    }

    public HotkeysArgs duration(long duration) {
        LettuceAssert.isTrue(duration >= 0L, "Duration must be at least 0");
        this.duration = duration;
        return this;
    }

    public HotkeysArgs duration(Duration duration) {
        LettuceAssert.notNull((Object)duration, "Duration must not be null");
        return this.duration(duration.getSeconds());
    }

    public HotkeysArgs sample(int ratio) {
        LettuceAssert.isTrue(ratio >= 1, "Sample ratio must be at least 1");
        this.sample = ratio;
        return this;
    }

    public HotkeysArgs slots(int ... slots) {
        LettuceAssert.notNull((Object)slots, "Slots must not be null");
        LettuceAssert.isTrue(slots.length >= 1 && slots.length <= 16384, "Slots count must be between 1 and 16384");
        this.slots = new ArrayList<Integer>(slots.length);
        for (int slot : slots) {
            LettuceAssert.isTrue(slot >= 0 && slot <= 16383, "Slot must be between 0 and 16383");
            this.slots.add(slot);
        }
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.metrics != null && !this.metrics.isEmpty()) {
            args.add(CommandKeyword.METRICS).add(this.metrics.size());
            for (Metric metric : this.metrics) {
                args.add(metric.getKeyword());
            }
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count.intValue());
        }
        if (this.duration != null) {
            args.add(CommandKeyword.DURATION).add(this.duration);
        }
        if (this.sample != null) {
            args.add(CommandKeyword.SAMPLE).add(this.sample.intValue());
        }
        if (this.slots != null && !this.slots.isEmpty()) {
            args.add(CommandKeyword.SLOTS).add(this.slots.size());
            for (Integer slot : this.slots) {
                args.add(slot.intValue());
            }
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static HotkeysArgs metrics(Metric ... metrics) {
            return new HotkeysArgs().metrics(metrics);
        }

        public static HotkeysArgs count(int count) {
            return new HotkeysArgs().count(count);
        }

        public static HotkeysArgs duration(long duration) {
            return new HotkeysArgs().duration(duration);
        }

        public static HotkeysArgs duration(Duration duration) {
            return new HotkeysArgs().duration(duration);
        }

        public static HotkeysArgs sample(int ratio) {
            return new HotkeysArgs().sample(ratio);
        }

        public static HotkeysArgs slots(int ... slots) {
            return new HotkeysArgs().slots(slots);
        }
    }

    public static enum Metric {
        CPU(CommandKeyword.CPU),
        NET(CommandKeyword.NET);

        private final CommandKeyword keyword;

        private Metric(CommandKeyword keyword) {
            this.keyword = keyword;
        }

        public CommandKeyword getKeyword() {
            return this.keyword;
        }
    }
}

