/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.DocumentLanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public class CreateArgs<K, V> {
    private Optional<TargetType> on = Optional.of(TargetType.HASH);
    private final List<K> prefixes = new ArrayList<K>();
    private Optional<V> filter = Optional.empty();
    private Optional<DocumentLanguage> defaultLanguage = Optional.empty();
    private Optional<K> languageField = Optional.empty();
    private OptionalDouble defaultScore = OptionalDouble.empty();
    private Optional<K> scoreField = Optional.empty();
    private Optional<K> payloadField = Optional.empty();
    private boolean maxTextFields = false;
    private OptionalLong temporary = OptionalLong.empty();
    private boolean noOffsets = false;
    private boolean noHighlight = false;
    private boolean noFields = false;
    private boolean noFrequency = false;
    private boolean skipInitialScan = false;
    private Optional<List<V>> stopWords = Optional.empty();

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public Optional<TargetType> getOn() {
        return this.on;
    }

    public List<K> getPrefixes() {
        return this.prefixes;
    }

    public Optional<V> getFilter() {
        return this.filter;
    }

    public Optional<DocumentLanguage> getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Optional<K> getLanguageField() {
        return this.languageField;
    }

    public OptionalDouble getDefaultScore() {
        return this.defaultScore;
    }

    public Optional<K> getScoreField() {
        return this.scoreField;
    }

    public Optional<K> getPayloadField() {
        return this.payloadField;
    }

    public boolean isMaxTextFields() {
        return this.maxTextFields;
    }

    public OptionalLong getTemporary() {
        return this.temporary;
    }

    public boolean isNoOffsets() {
        return this.noOffsets;
    }

    public boolean isNoHighlight() {
        return this.noHighlight;
    }

    public boolean isNoFields() {
        return this.noFields;
    }

    public boolean isNoFrequency() {
        return this.noFrequency;
    }

    public boolean isSkipInitialScan() {
        return this.skipInitialScan;
    }

    public Optional<List<V>> getStopWords() {
        return this.stopWords;
    }

    public void build(CommandArgs<K, V> args) {
        this.on.ifPresent(targetType -> args.add(CommandKeyword.ON).add(targetType.name()));
        if (!this.prefixes.isEmpty()) {
            args.add(CommandKeyword.PREFIX).add(this.prefixes.size());
            this.prefixes.forEach(p -> args.add(p.toString()));
        }
        this.filter.ifPresent(filter -> args.add(CommandKeyword.FILTER).addValue(filter));
        this.defaultLanguage.ifPresent(language -> args.add(CommandKeyword.LANGUAGE).add(language.toString()));
        this.languageField.ifPresent(field -> args.add(CommandKeyword.LANGUAGE_FIELD).addKey(field));
        this.defaultScore.ifPresent(score -> args.add(CommandKeyword.SCORE).add(score));
        this.scoreField.ifPresent(field -> args.add(CommandKeyword.SCORE_FIELD).addKey(field));
        this.payloadField.ifPresent(field -> args.add(CommandKeyword.PAYLOAD_FIELD).addKey(field));
        if (this.maxTextFields) {
            args.add(CommandKeyword.MAXTEXTFIELDS);
        }
        this.temporary.ifPresent(seconds -> args.add(CommandKeyword.TEMPORARY).add(seconds));
        if (this.noOffsets) {
            args.add(CommandKeyword.NOOFFSETS);
        }
        if (this.noHighlight) {
            args.add(CommandKeyword.NOHL);
        }
        if (this.noFields) {
            args.add(CommandKeyword.NOFIELDS);
        }
        if (this.noFrequency) {
            args.add(CommandKeyword.NOFREQS);
        }
        if (this.skipInitialScan) {
            args.add(CommandKeyword.SKIPINITIALSCAN);
        }
        this.stopWords.ifPresent(words -> {
            args.add(CommandKeyword.STOPWORDS).add(words.size());
            words.forEach(args::addValue);
        });
    }

    public static class Builder<K, V> {
        private final CreateArgs<K, V> instance = new CreateArgs();

        public Builder<K, V> on(TargetType targetType) {
            ((CreateArgs)this.instance).on = Optional.of(targetType);
            return this;
        }

        public Builder<K, V> withPrefix(K prefix) {
            ((CreateArgs)this.instance).prefixes.add(prefix);
            return this;
        }

        public Builder<K, V> withPrefixes(List<K> prefixes) {
            ((CreateArgs)this.instance).prefixes.addAll(prefixes);
            return this;
        }

        public Builder<K, V> filter(V filter) {
            ((CreateArgs)this.instance).filter = Optional.of(filter);
            return this;
        }

        public Builder<K, V> defaultLanguage(DocumentLanguage language) {
            ((CreateArgs)this.instance).defaultLanguage = Optional.of(language);
            return this;
        }

        public Builder<K, V> languageField(K field) {
            ((CreateArgs)this.instance).languageField = Optional.of(field);
            return this;
        }

        public Builder<K, V> defaultScore(double score) {
            ((CreateArgs)this.instance).defaultScore = OptionalDouble.of(score);
            return this;
        }

        public Builder<K, V> scoreField(K field) {
            ((CreateArgs)this.instance).scoreField = Optional.of(field);
            return this;
        }

        public Builder<K, V> payloadField(K field) {
            ((CreateArgs)this.instance).payloadField = Optional.of(field);
            return this;
        }

        public Builder<K, V> maxTextFields() {
            ((CreateArgs)this.instance).maxTextFields = true;
            return this;
        }

        public Builder<K, V> temporary(long seconds) {
            ((CreateArgs)this.instance).temporary = OptionalLong.of(seconds);
            return this;
        }

        public Builder<K, V> noOffsets() {
            ((CreateArgs)this.instance).noOffsets = true;
            return this;
        }

        public Builder<K, V> noHighlighting() {
            ((CreateArgs)this.instance).noHighlight = true;
            return this;
        }

        public Builder<K, V> noFields() {
            ((CreateArgs)this.instance).noFields = true;
            return this;
        }

        public Builder<K, V> noFrequency() {
            ((CreateArgs)this.instance).noFrequency = true;
            return this;
        }

        public Builder<K, V> skipInitialScan() {
            ((CreateArgs)this.instance).skipInitialScan = true;
            return this;
        }

        public Builder<K, V> stopWords(List<V> stopWords) {
            ((CreateArgs)this.instance).stopWords = Optional.of(stopWords);
            return this;
        }

        public CreateArgs<K, V> build() {
            return this.instance;
        }
    }

    public static enum TargetType {
        HASH,
        JSON;

    }
}

