/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

@Experimental
public class PostProcessingArgs<K, V> {
    private final List<K> loadFields = new ArrayList<K>();
    private final List<PostProcessingOperation<K, ?>> postProcessingOperations = new ArrayList();

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public void build(CommandArgs<K, V> args) {
        args.add(CommandKeyword.LOAD);
        args.add(this.loadFields.size());
        this.loadFields.forEach(args::addKey);
        Iterator<PostProcessingOperation<K, ?>> iterator = this.postProcessingOperations.iterator();
        while (iterator.hasNext()) {
            PostProcessingOperation<K, ?> operation;
            PostProcessingOperation<K, ?> typedOperation = operation = iterator.next();
            typedOperation.build(args);
        }
    }

    public static enum SortDirection {
        ASC,
        DESC;

    }

    public static class SortProperty<K> {
        final K property;
        final SortDirection direction;

        public SortProperty(K property, SortDirection direction) {
            this.property = property;
            this.direction = direction;
        }

        public K getProperty() {
            return this.property;
        }

        public SortDirection getDirection() {
            return this.direction;
        }
    }

    public static enum ReduceFunction implements ProtocolKeyword
    {
        COUNT,
        COUNT_DISTINCT,
        COUNT_DISTINCTISH,
        SUM,
        AVG,
        MIN,
        MAX,
        STDDEV,
        QUANTILE,
        TOLIST,
        FIRST_VALUE,
        RANDOM_SAMPLE;

        private final byte[] bytes = this.name().getBytes(StandardCharsets.US_ASCII);

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }
    }

    public static class Reducer<K, V> {
        private final ReduceFunction function;
        private final List<V> args;
        private Optional<K> alias = Optional.empty();

        private Reducer(ReduceFunction function, List<V> args) {
            this.function = function;
            this.args = new ArrayList<V>(args);
        }

        @SafeVarargs
        public static <K, V> Reducer<K, V> of(ReduceFunction function, V ... args) {
            LettuceAssert.notNull((Object)function, "ReduceFunction must not be null");
            return new Reducer(function, args.length == 0 ? Collections.emptyList() : Arrays.asList(args));
        }

        public Reducer<K, V> as(K alias) {
            LettuceAssert.notNull(alias, "Alias must not be null");
            this.alias = Optional.of(alias);
            return this;
        }

        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.REDUCE);
            args.add(this.function);
            args.add(this.args.size());
            for (V arg : this.args) {
                args.addValue(arg);
            }
            this.alias.ifPresent(a -> {
                args.add(CommandKeyword.AS);
                args.add(a.toString());
            });
        }
    }

    public static class Limit<K, V>
    implements PostProcessingOperation<K, V> {
        final long offset;
        final long num;

        private Limit(long offset, long num) {
            this.offset = offset;
            this.num = num;
        }

        @Override
        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.LIMIT);
            args.add(this.offset);
            args.add(this.num);
        }

        public static <K, V> Limit<K, V> of(long offset, long num) {
            return new Limit<K, V>(offset, num);
        }
    }

    public static class Filter<K, V>
    implements PostProcessingOperation<K, V> {
        private final V expression;

        public Filter(V expression) {
            this.expression = expression;
        }

        @Override
        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.FILTER);
            args.addValue(this.expression);
        }

        public static <K, V> Filter<K, V> of(V expression) {
            return new Filter<K, V>(expression);
        }
    }

    public static class SortBy<K>
    implements PostProcessingOperation<K, Object> {
        private final List<SortProperty<K>> properties;

        public SortBy(List<SortProperty<K>> properties) {
            this.properties = new ArrayList<SortProperty<K>>(properties);
        }

        @SafeVarargs
        public static <K> SortBy<K> of(SortProperty<K> ... properties) {
            return new SortBy<K>(Arrays.asList(properties));
        }

        @Override
        public void build(CommandArgs<K, Object> args) {
            args.add(CommandKeyword.SORTBY);
            args.add((long)this.properties.size() * 2L);
            for (SortProperty<K> property : this.properties) {
                String propertyStr = property.property.toString();
                if (!propertyStr.startsWith("@")) {
                    args.add("@" + propertyStr);
                } else {
                    args.add(propertyStr);
                }
                args.add(property.direction.name());
            }
        }
    }

    public static class Apply<K, V>
    implements PostProcessingOperation<K, V> {
        private final V expression;
        private final K name;

        public Apply(V expression, K name) {
            this.expression = expression;
            this.name = name;
        }

        @Override
        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.APPLY);
            args.addValue(this.expression);
            args.add(CommandKeyword.AS);
            args.add(this.name.toString());
        }

        public static <K, V> Apply<K, V> of(V expression, K name) {
            return new Apply<K, V>(expression, name);
        }
    }

    public static class GroupBy<K, V>
    implements PostProcessingOperation<K, V> {
        private final List<K> properties;
        private final List<Reducer<K, V>> reducers;

        private GroupBy(List<K> properties) {
            this.properties = new ArrayList<K>(properties);
            this.reducers = new ArrayList<Reducer<K, V>>();
        }

        public GroupBy<K, V> reduce(Reducer<K, V> reducer) {
            this.reducers.add(reducer);
            return this;
        }

        @SafeVarargs
        public static <K, V> GroupBy<K, V> of(K ... properties) {
            return new GroupBy<K, V>(Arrays.asList(properties));
        }

        @Override
        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.GROUPBY);
            args.add(this.properties.size());
            for (K k : this.properties) {
                String propertyStr = k.toString();
                if (!propertyStr.startsWith("@")) {
                    args.add("@" + propertyStr);
                    continue;
                }
                args.add(propertyStr);
            }
            for (Reducer reducer : this.reducers) {
                reducer.build(args);
            }
        }
    }

    public static interface PostProcessingOperation<K, V> {
        public void build(CommandArgs<K, V> var1);
    }

    public static class Builder<K, V> {
        private final PostProcessingArgs<K, V> instance = new PostProcessingArgs();

        @SafeVarargs
        public final Builder<K, V> load(K ... fields) {
            LettuceAssert.notNull(fields, "Fields must not be null");
            for (K field : fields) {
                LettuceAssert.notNull(field, "Field must not be null");
                ((PostProcessingArgs)this.instance).loadFields.add(field);
            }
            return this;
        }

        public Builder<K, V> addOperation(PostProcessingOperation<K, ?> operation) {
            LettuceAssert.notNull(operation, "Operation must not be null");
            ((PostProcessingArgs)this.instance).postProcessingOperations.add(operation);
            return this;
        }

        public PostProcessingArgs<K, V> build() {
            return this.instance;
        }
    }
}

