/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.CombineArgs;
import io.lettuce.core.search.arguments.HybridSearchArgs;
import io.lettuce.core.search.arguments.HybridVectorArgs;
import io.lettuce.core.search.arguments.PostProcessingArgs;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HybridArgs<K, V> {
    private final List<HybridSearchArgs<K, V>> searchArgs = new ArrayList<HybridSearchArgs<K, V>>();
    private final List<HybridVectorArgs<K, V>> vectorArgs = new ArrayList<HybridVectorArgs<K, V>>();
    private Optional<CombineArgs<K>> combineArgs = Optional.empty();
    private Optional<PostProcessingArgs<K, V>> postProcessingArgs = Optional.empty();
    private final Map<K, V> params = new HashMap();
    private Optional<Duration> timeout = Optional.empty();

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public void build(CommandArgs<K, V> args) {
        LettuceAssert.notNull(this.searchArgs, "SEARCH clause is required - use search() or search(HybridSearchArgs)");
        LettuceAssert.notNull(this.vectorArgs, "VSIM clause is required - use vectorSearch() or vectorSearch(HybridVectorArgs)");
        this.searchArgs.forEach(searchArg -> searchArg.build(args));
        this.vectorArgs.forEach(vectorArg -> vectorArg.build(args));
        if (this.combineArgs.isPresent()) {
            args.add(CommandKeyword.COMBINE);
            this.combineArgs.get().build(args);
        }
        this.postProcessingArgs.ifPresent(postProcessing -> postProcessing.build(args));
        if (!this.params.isEmpty()) {
            args.add(CommandKeyword.PARAMS);
            args.add((long)this.params.size() * 2L);
            this.params.forEach((name, value) -> {
                args.addKey(name);
                args.addValue(value);
            });
        }
        this.timeout.ifPresent(t -> {
            args.add(CommandKeyword.TIMEOUT);
            args.add(t.toMillis());
        });
    }

    public static class Builder<K, V> {
        private final HybridArgs<K, V> instance = new HybridArgs();

        public HybridArgs<K, V> build() {
            return this.instance;
        }

        public Builder<K, V> search(HybridSearchArgs<K, V> searchArgs) {
            LettuceAssert.notNull(searchArgs, "Search args must not be null");
            ((HybridArgs)this.instance).searchArgs.add(searchArgs);
            return this;
        }

        public Builder<K, V> vectorSearch(HybridVectorArgs<K, V> vectorArgs) {
            LettuceAssert.notNull(vectorArgs, "Vector args must not be null");
            ((HybridArgs)this.instance).vectorArgs.add(vectorArgs);
            return this;
        }

        public Builder<K, V> combine(CombineArgs<K> combineArgs) {
            LettuceAssert.notNull(combineArgs, "Combine args must not be null");
            ((HybridArgs)this.instance).combineArgs = Optional.of(combineArgs);
            return this;
        }

        public Builder<K, V> postProcessing(PostProcessingArgs<K, V> postProcessingArgs) {
            LettuceAssert.notNull(postProcessingArgs, "PostProcessingArgs must not be null");
            ((HybridArgs)this.instance).postProcessingArgs = Optional.of(postProcessingArgs);
            return this;
        }

        public Builder<K, V> param(K name, V value) {
            LettuceAssert.notNull(name, "Parameter name must not be null");
            LettuceAssert.notNull(value, "Parameter value must not be null");
            ((HybridArgs)this.instance).params.put(name, value);
            return this;
        }

        public Builder<K, V> timeout(Duration timeout) {
            LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
            ((HybridArgs)this.instance).timeout = Optional.of(timeout);
            return this;
        }
    }
}

