/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.internal;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class NetUtils {
    public static boolean isPrivateIp(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            return false;
        }
        InetAddress address = ((InetSocketAddress)socketAddress).getAddress();
        if (address == null || address.isAnyLocalAddress()) {
            return false;
        }
        return address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress() || NetUtils.isUniqueLocalAddress(address);
    }

    private static boolean isUniqueLocalAddress(InetAddress address) {
        if (!(address instanceof Inet6Address)) {
            return false;
        }
        byte[] bytes = address.getAddress();
        return (bytes[0] & 0xFFFFFFFE) == -4;
    }
}

