/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.models.partitions;

import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.internal.LettuceStrings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterPartitionParser {
    public static final String CONNECTED = "connected";
    private static final String TOKEN_SLOT_IN_TRANSITION = "[";
    private static final char TOKEN_NODE_SEPARATOR = '\n';
    private static final Map<String, RedisClusterNode.NodeFlag> FLAG_MAPPING;

    private ClusterPartitionParser() {
    }

    public static Partitions parse(List<Object> clusterShards) {
        Partitions partitions = new Partitions();
        try {
            LinkedHashMap<String, RedisClusterNode> nodeMap = new LinkedHashMap<String, RedisClusterNode>();
            for (Object s : clusterShards) {
                List shard = (List)s;
                if (shard.size() < 4) continue;
                KeyValueMap shardMap = ClusterPartitionParser.toMap(shard);
                List slotRanges = (List)shardMap.get("slots");
                List nodes = (List)shardMap.get("nodes");
                BitSet bitSet = ClusterPartitionParser.readSlotRanges(slotRanges);
                ArrayList<RedisClusterNode> parsedNodes = new ArrayList<RedisClusterNode>(nodes.size());
                for (List node : nodes) {
                    RedisClusterNode clusterNode = ClusterPartitionParser.parseNode(node, (BitSet)bitSet.clone());
                    nodeMap.putIfAbsent(clusterNode.getNodeId(), clusterNode);
                    parsedNodes.add(clusterNode);
                }
                RedisClusterNode master2 = ClusterPartitionParser.findMaster(parsedNodes);
                if (master2 == null) continue;
                ClusterPartitionParser.associateMasterWithReplicas(master2, parsedNodes);
            }
            partitions.addAll(nodeMap.values());
        }
        catch (Exception e) {
            throw new RedisException("Cannot parse " + clusterShards, e);
        }
        return partitions;
    }

    private static RedisClusterNode findMaster(List<RedisClusterNode> nodes) {
        for (RedisClusterNode parsedNode : nodes) {
            if (!parsedNode.is(RedisClusterNode.NodeFlag.UPSTREAM) && !parsedNode.is(RedisClusterNode.NodeFlag.MASTER)) continue;
            return parsedNode;
        }
        return null;
    }

    private static void associateMasterWithReplicas(RedisClusterNode master2, List<RedisClusterNode> nodes) {
        for (RedisClusterNode parsedNode : nodes) {
            if (!parsedNode.is(RedisClusterNode.NodeFlag.REPLICA) && !parsedNode.is(RedisClusterNode.NodeFlag.SLAVE)) continue;
            parsedNode.setSlaveOf(master2.getNodeId());
        }
    }

    private static RedisClusterNode parseNode(List<Object> kvlist, BitSet slots) {
        KeyValueMap nodeMap = ClusterPartitionParser.toMap(kvlist);
        RedisClusterNode node = new RedisClusterNode();
        node.setNodeId((String)nodeMap.get("id"));
        int port = ((Long)nodeMap.get("port")).intValue();
        RedisURI uri = LettuceStrings.isNotEmpty((String)nodeMap.get("hostname")) ? RedisURI.create((String)nodeMap.get("hostname"), port) : RedisURI.create((String)nodeMap.get("endpoint"), port);
        node.setUri(uri);
        HashSet<RedisClusterNode.NodeFlag> flags = new HashSet<RedisClusterNode.NodeFlag>();
        flags.add(FLAG_MAPPING.get(nodeMap.get("role")));
        flags.add(FLAG_MAPPING.get(nodeMap.get("health")));
        if (flags.contains((Object)RedisClusterNode.NodeFlag.SLAVE)) {
            flags.add(RedisClusterNode.NodeFlag.REPLICA);
        } else if (flags.contains((Object)RedisClusterNode.NodeFlag.REPLICA)) {
            flags.add(RedisClusterNode.NodeFlag.SLAVE);
        }
        if (flags.contains((Object)RedisClusterNode.NodeFlag.MASTER)) {
            flags.add(RedisClusterNode.NodeFlag.UPSTREAM);
        } else if (flags.contains((Object)RedisClusterNode.NodeFlag.UPSTREAM)) {
            flags.add(RedisClusterNode.NodeFlag.MASTER);
        }
        node.setFlags(flags);
        node.setReplOffset((Long)nodeMap.get("replication-offset"));
        node.setSlots(slots);
        return node;
    }

    public static Partitions parse(String nodes) {
        Partitions partitions = new Partitions();
        try {
            String[] lines = nodes.split(Character.toString('\n'));
            ArrayList<RedisClusterNode> mappedNodes = new ArrayList<RedisClusterNode>(lines.length);
            for (String line : lines) {
                if (line.isEmpty()) continue;
                mappedNodes.add(ClusterPartitionParser.parseNode(line));
            }
            partitions.addAll((Collection<? extends RedisClusterNode>)mappedNodes);
        }
        catch (Exception e) {
            throw new RedisException("Cannot parse " + nodes, e);
        }
        return partitions;
    }

    private static RedisClusterNode parseNode(String nodeInformation) {
        HostAndPort hostAndPort;
        Iterator<String> iterator = Arrays.asList(nodeInformation.split(" ")).iterator();
        String nodeId = iterator.next();
        boolean connected = false;
        RedisURI uri = null;
        String hostAndPortPart = iterator.next();
        if (hostAndPortPart.contains("@")) {
            hostAndPortPart = hostAndPortPart.substring(0, hostAndPortPart.indexOf(64));
        }
        if (LettuceStrings.isNotEmpty((hostAndPort = HostAndPort.parseCompat(hostAndPortPart)).getHostText())) {
            uri = RedisURI.Builder.redis(hostAndPort.getHostText(), hostAndPort.getPort()).build();
        }
        String flags = iterator.next();
        List<String> flagStrings = LettuceLists.newList(flags.split("\\,"));
        Set<RedisClusterNode.NodeFlag> nodeFlags = ClusterPartitionParser.readFlags(flagStrings);
        String replicaOfString = iterator.next();
        String replicaOf = "-".equals(replicaOfString) ? null : replicaOfString;
        long pingSentTs = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        long pongReceivedTs = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        long configEpoch = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        String connectedFlags = iterator.next();
        if (CONNECTED.equals(connectedFlags)) {
            connected = true;
        }
        List<String> slotStrings = LettuceLists.newList(iterator);
        BitSet slots = ClusterPartitionParser.readSlots(slotStrings);
        RedisClusterNode partition = new RedisClusterNode(uri, nodeId, connected, replicaOf, pingSentTs, pongReceivedTs, configEpoch, slots, nodeFlags);
        return partition;
    }

    private static Set<RedisClusterNode.NodeFlag> readFlags(List<String> flagStrings) {
        HashSet<RedisClusterNode.NodeFlag> flags = new HashSet<RedisClusterNode.NodeFlag>();
        for (String flagString : flagStrings) {
            if (!FLAG_MAPPING.containsKey(flagString)) continue;
            flags.add(FLAG_MAPPING.get(flagString));
        }
        if (flags.contains((Object)RedisClusterNode.NodeFlag.SLAVE)) {
            flags.add(RedisClusterNode.NodeFlag.REPLICA);
        }
        return Collections.unmodifiableSet(flags);
    }

    private static BitSet readSlots(List<String> slotStrings) {
        BitSet slots = new BitSet(16384);
        for (String slotString : slotStrings) {
            if (slotString.startsWith(TOKEN_SLOT_IN_TRANSITION)) continue;
            if (slotString.contains("-")) {
                Iterator<String> it = Arrays.asList(slotString.split("\\-")).iterator();
                int from = Integer.parseInt(it.next());
                int to = Integer.parseInt(it.next());
                ClusterPartitionParser.addSlots(slots, from, to);
                continue;
            }
            slots.set(Integer.parseInt(slotString));
        }
        return slots;
    }

    private static BitSet readSlotRanges(List<Integer> slotRanges) {
        BitSet slots = new BitSet(16384);
        for (int i = 0; i < slotRanges.size(); i += 2) {
            Number from = slotRanges.get(i);
            Number to = slotRanges.get(i + 1);
            ClusterPartitionParser.addSlots(slots, from.intValue(), to.intValue());
        }
        return slots;
    }

    private static void addSlots(BitSet slots, int from, int to) {
        for (int slot = from; slot <= to; ++slot) {
            slots.set(slot);
        }
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        Object object;
        if (iterator.hasNext() && (object = iterator.next()) instanceof String) {
            return Long.parseLong((String)object);
        }
        return defaultValue;
    }

    private static KeyValueMap toMap(List<Object> kvlist) {
        if (kvlist.size() % 2 != 0) {
            throw new IllegalArgumentException("Key-Value list must contain an even number of key-value tuples");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(kvlist.size() / 2);
        for (int i = 0; i < kvlist.size(); i += 2) {
            String key = (String)kvlist.get(i);
            Object value = kvlist.get(i + 1);
            map.put(key, value);
        }
        return new KeyValueMap(map);
    }

    static {
        HashMap<String, RedisClusterNode.NodeFlag> map = new HashMap<String, RedisClusterNode.NodeFlag>();
        map.put("noflags", RedisClusterNode.NodeFlag.NOFLAGS);
        map.put("myself", RedisClusterNode.NodeFlag.MYSELF);
        map.put("master", RedisClusterNode.NodeFlag.MASTER);
        map.put("slave", RedisClusterNode.NodeFlag.SLAVE);
        map.put("replica", RedisClusterNode.NodeFlag.REPLICA);
        map.put("fail?", RedisClusterNode.NodeFlag.EVENTUAL_FAIL);
        map.put("fail", RedisClusterNode.NodeFlag.FAIL);
        map.put("handshake", RedisClusterNode.NodeFlag.HANDSHAKE);
        map.put("noaddr", RedisClusterNode.NodeFlag.NOADDR);
        map.put("loading", RedisClusterNode.NodeFlag.LOADING);
        map.put("online", RedisClusterNode.NodeFlag.ONLINE);
        FLAG_MAPPING = Collections.unmodifiableMap(map);
    }

    static class KeyValueMap {
        private final Map<String, Object> map;

        public KeyValueMap(Map<String, Object> map) {
            this.map = map;
        }

        public <T> T get(String key) {
            return (T)this.map.get(key);
        }
    }
}

