/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.resource.ExponentialDelay;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class FullJitterDelay
extends ExponentialDelay {
    private final Duration upper;
    private final long base;
    private final TimeUnit targetTimeUnit;

    FullJitterDelay(Duration lower, Duration upper, long base, TimeUnit targetTimeUnit) {
        super(lower, upper, 2, targetTimeUnit);
        this.upper = upper;
        this.base = base;
        this.targetTimeUnit = targetTimeUnit;
    }

    @Override
    public Duration createDelay(long attempt) {
        long upperTarget = this.targetTimeUnit.convert(this.upper.toNanos(), TimeUnit.NANOSECONDS);
        long temp = Math.min(upperTarget, this.base * FullJitterDelay.calculatePowerOfTwo(attempt));
        long delay = temp / 2L + FullJitterDelay.randomBetween(0L, temp / 2L);
        return this.applyBounds(Duration.ofNanos(this.targetTimeUnit.toNanos(delay)));
    }
}

