/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.AsyncCloseable;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.masterslave.CompletableEventLatchSupport;
import io.lettuce.core.masterslave.MasterSlaveUtils;
import io.lettuce.core.masterslave.Requests;
import io.lettuce.core.masterslave.TimedAsyncCommand;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import reactor.util.function.Tuple2;

class Connections
extends CompletableEventLatchSupport<Tuple2<RedisURI, StatefulRedisConnection<String, String>>, Connections>
implements AsyncCloseable {
    private final Map<RedisURI, StatefulRedisConnection<String, String>> connections = new TreeMap<RedisURI, StatefulRedisConnection<String, String>>(MasterSlaveUtils.RedisURIComparator.INSTANCE);
    private final List<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
    private final List<RedisNodeDescription> nodes;
    private volatile boolean closed = false;

    public Connections(int expectedConnectionCount, List<RedisNodeDescription> nodes) {
        super(expectedConnectionCount);
        this.nodes = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onAccept(Tuple2<RedisURI, StatefulRedisConnection<String, String>> value) {
        if (this.closed) {
            ((StatefulRedisConnection)value.getT2()).closeAsync();
            return;
        }
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            this.connections.put((RedisURI)value.getT1(), (StatefulRedisConnection<String, String>)value.getT2());
        }
    }

    @Override
    protected void onError(Throwable value) {
        this.exceptions.add(value);
    }

    @Override
    protected void onDrop(Tuple2<RedisURI, StatefulRedisConnection<String, String>> value) {
        ((StatefulRedisConnection)value.getT2()).closeAsync();
    }

    @Override
    protected void onDrop(Throwable value) {
    }

    @Override
    protected void onEmit(CompletableEventLatchSupport.Emission<Connections> emission) {
        if (this.getExpectedCount() != 0 && this.connections.isEmpty() && !this.exceptions.isEmpty()) {
            RedisConnectionException collector = new RedisConnectionException("Unable to establish a connection to Redis Cluster");
            this.exceptions.forEach(collector::addSuppressed);
            emission.error(collector);
        } else {
            emission.success(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            return this.connections.isEmpty();
        }
    }

    public Requests requestPing() {
        LinkedHashSet<Map.Entry<RedisURI, StatefulRedisConnection<String, String>>> entries = new LinkedHashSet<Map.Entry<RedisURI, StatefulRedisConnection<String, String>>>(this.connections.entrySet());
        Requests requests = new Requests(entries.size(), this.nodes);
        for (Map.Entry entry : entries) {
            CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.ASCII).add(CommandKeyword.NODES);
            Command command = new Command(CommandType.PING, new StatusOutput<String, String>(StringCodec.ASCII), args);
            TimedAsyncCommand<String, String, String> timedCommand = new TimedAsyncCommand<String, String, String>(command);
            ((StatefulRedisConnection)entry.getValue()).dispatch(timedCommand);
            requests.addRequest((RedisURI)entry.getKey(), timedCommand);
        }
        return requests;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        ArrayList<CompletableFuture<Void>> close = new ArrayList<CompletableFuture<Void>>(this.connections.size());
        ArrayList<RedisURI> toRemove = new ArrayList<RedisURI>(this.connections.size());
        this.closed = true;
        for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : this.connections.entrySet()) {
            toRemove.add(entry.getKey());
            close.add(entry.getValue().closeAsync());
        }
        for (RedisURI redisURI : toRemove) {
            this.connections.remove(redisURI);
        }
        return Futures.allOf(close);
    }
}

