/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClusterTopologyRefreshOptions {
    public static final boolean DEFAULT_PERIODIC_REFRESH_ENABLED = false;
    public static final long DEFAULT_REFRESH_PERIOD = 60L;
    public static final TimeUnit DEFAULT_REFRESH_PERIOD_UNIT = TimeUnit.SECONDS;
    public static final Duration DEFAULT_REFRESH_PERIOD_DURATION = Duration.ofSeconds(60L);
    public static final boolean DEFAULT_DYNAMIC_REFRESH_SOURCES = true;
    public static final Set<RefreshTrigger> DEFAULT_ADAPTIVE_REFRESH_TRIGGERS = Collections.emptySet();
    public static final long DEFAULT_ADAPTIVE_REFRESH_TIMEOUT = 30L;
    public static final TimeUnit DEFAULT_ADAPTIVE_REFRESH_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final Duration DEFAULT_ADAPTIVE_REFRESH_TIMEOUT_DURATION = Duration.ofSeconds(30L);
    public static final int DEFAULT_REFRESH_TRIGGERS_RECONNECT_ATTEMPTS = 5;
    public static final boolean DEFAULT_CLOSE_STALE_CONNECTIONS = true;
    private final boolean periodicRefreshEnabled;
    private final Duration refreshPeriod;
    private final boolean closeStaleConnections;
    private final boolean dynamicRefreshSources;
    private final Set<RefreshTrigger> adaptiveRefreshTriggers;
    private final Duration adaptiveRefreshTimeout;
    private final int refreshTriggersReconnectAttempts;

    protected ClusterTopologyRefreshOptions(Builder builder) {
        this.periodicRefreshEnabled = builder.periodicRefreshEnabled;
        this.refreshPeriod = builder.refreshPeriod;
        this.closeStaleConnections = builder.closeStaleConnections;
        this.dynamicRefreshSources = builder.dynamicRefreshSources;
        this.adaptiveRefreshTriggers = Collections.unmodifiableSet(new HashSet(builder.adaptiveRefreshTriggers));
        this.adaptiveRefreshTimeout = builder.adaptiveRefreshTimeout;
        this.refreshTriggersReconnectAttempts = builder.refreshTriggersReconnectAttempts;
    }

    protected ClusterTopologyRefreshOptions(ClusterTopologyRefreshOptions original) {
        this.periodicRefreshEnabled = original.periodicRefreshEnabled;
        this.refreshPeriod = original.refreshPeriod;
        this.closeStaleConnections = original.closeStaleConnections;
        this.dynamicRefreshSources = original.dynamicRefreshSources;
        this.adaptiveRefreshTriggers = Collections.unmodifiableSet(new HashSet<RefreshTrigger>(original.adaptiveRefreshTriggers));
        this.adaptiveRefreshTimeout = original.adaptiveRefreshTimeout;
        this.refreshTriggersReconnectAttempts = original.refreshTriggersReconnectAttempts;
    }

    public static ClusterTopologyRefreshOptions copyOf(ClusterTopologyRefreshOptions options) {
        return new ClusterTopologyRefreshOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ClusterTopologyRefreshOptions create() {
        return ClusterTopologyRefreshOptions.builder().build();
    }

    public static ClusterTopologyRefreshOptions enabled() {
        return ClusterTopologyRefreshOptions.builder().enablePeriodicRefresh().enableAllAdaptiveRefreshTriggers().build();
    }

    public boolean isPeriodicRefreshEnabled() {
        return this.periodicRefreshEnabled;
    }

    public Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public boolean isCloseStaleConnections() {
        return this.closeStaleConnections;
    }

    public boolean useDynamicRefreshSources() {
        return this.dynamicRefreshSources;
    }

    public Set<RefreshTrigger> getAdaptiveRefreshTriggers() {
        return this.adaptiveRefreshTriggers;
    }

    public Duration getAdaptiveRefreshTimeout() {
        return this.adaptiveRefreshTimeout;
    }

    public int getRefreshTriggersReconnectAttempts() {
        return this.refreshTriggersReconnectAttempts;
    }

    public static enum RefreshTrigger {
        MOVED_REDIRECT,
        ASK_REDIRECT,
        PERSISTENT_RECONNECTS;

    }

    public static class Builder {
        private boolean periodicRefreshEnabled = false;
        private Duration refreshPeriod = DEFAULT_REFRESH_PERIOD_DURATION;
        private boolean closeStaleConnections = true;
        private boolean dynamicRefreshSources = true;
        private Set<RefreshTrigger> adaptiveRefreshTriggers = new HashSet<RefreshTrigger>(DEFAULT_ADAPTIVE_REFRESH_TRIGGERS);
        private Duration adaptiveRefreshTimeout = DEFAULT_ADAPTIVE_REFRESH_TIMEOUT_DURATION;
        private int refreshTriggersReconnectAttempts = 5;

        private Builder() {
        }

        public Builder enablePeriodicRefresh() {
            return this.enablePeriodicRefresh(true);
        }

        public Builder enablePeriodicRefresh(boolean enabled) {
            this.periodicRefreshEnabled = enabled;
            return this;
        }

        public Builder enablePeriodicRefresh(Duration refreshPeriod) {
            return this.refreshPeriod(refreshPeriod).enablePeriodicRefresh();
        }

        @Deprecated
        public Builder enablePeriodicRefresh(long refreshPeriod, TimeUnit refreshPeriodUnit) {
            return this.refreshPeriod(refreshPeriod, refreshPeriodUnit).enablePeriodicRefresh();
        }

        public Builder refreshPeriod(Duration refreshPeriod) {
            LettuceAssert.notNull(refreshPeriod, "RefreshPeriod duration must not be null");
            LettuceAssert.isTrue(refreshPeriod.toNanos() > 0L, "RefreshPeriod must be greater 0");
            this.refreshPeriod = refreshPeriod;
            return this;
        }

        @Deprecated
        public Builder refreshPeriod(long refreshPeriod, TimeUnit refreshPeriodUnit) {
            LettuceAssert.isTrue(refreshPeriod > 0L, "RefreshPeriod must be greater 0");
            LettuceAssert.notNull((Object)refreshPeriodUnit, "TimeUnit must not be null");
            return this.refreshPeriod(Duration.ofNanos(refreshPeriodUnit.toNanos(refreshPeriod)));
        }

        public Builder closeStaleConnections(boolean closeStaleConnections) {
            this.closeStaleConnections = closeStaleConnections;
            return this;
        }

        public Builder dynamicRefreshSources(boolean dynamicRefreshSources) {
            this.dynamicRefreshSources = dynamicRefreshSources;
            return this;
        }

        public Builder enableAdaptiveRefreshTrigger(RefreshTrigger ... refreshTrigger) {
            LettuceAssert.notNull(refreshTrigger, "RefreshTriggers must not be null");
            LettuceAssert.noNullElements((Object[])refreshTrigger, "RefreshTriggers must not contain null elements");
            this.adaptiveRefreshTriggers.addAll(Arrays.asList(refreshTrigger));
            return this;
        }

        public Builder enableAllAdaptiveRefreshTriggers() {
            this.adaptiveRefreshTriggers.addAll(EnumSet.allOf(RefreshTrigger.class));
            return this;
        }

        public Builder adaptiveRefreshTriggersTimeout(Duration timeout) {
            LettuceAssert.notNull(this.refreshPeriod, "Adaptive refresh triggers timeout must not be null");
            LettuceAssert.isTrue(this.refreshPeriod.toNanos() > 0L, "Adaptive refresh triggers timeout must be greater 0");
            this.adaptiveRefreshTimeout = timeout;
            return this;
        }

        @Deprecated
        public Builder adaptiveRefreshTriggersTimeout(long timeout, TimeUnit unit) {
            LettuceAssert.isTrue(timeout > 0L, "Triggers timeout must be greater 0");
            LettuceAssert.notNull((Object)unit, "TimeUnit must not be null");
            return this.adaptiveRefreshTriggersTimeout(Duration.ofNanos(unit.toNanos(timeout)));
        }

        public Builder refreshTriggersReconnectAttempts(int refreshTriggersReconnectAttempts) {
            this.refreshTriggersReconnectAttempts = refreshTriggersReconnectAttempts;
            return this;
        }

        public ClusterTopologyRefreshOptions build() {
            return new ClusterTopologyRefreshOptions(this);
        }
    }
}

