/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.AbstractInvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

class FutureSyncInvocationHandler
extends AbstractInvocationHandler {
    private final StatefulConnection<?, ?> connection;
    private final Object asyncApi;
    private final AbstractInvocationHandler.MethodTranslator translator;

    public FutureSyncInvocationHandler(StatefulConnection<?, ?> connection, Object asyncApi, Class<?>[] interfaces) {
        this.connection = connection;
        this.asyncApi = asyncApi;
        this.translator = AbstractInvocationHandler.MethodTranslator.of(asyncApi.getClass(), interfaces);
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Method targetMethod = this.translator.get(method);
            Object result = targetMethod.invoke(this.asyncApi, args);
            if (result instanceof RedisFuture) {
                RedisFuture command = (RedisFuture)result;
                if (FutureSyncInvocationHandler.isNonTxControlMethod(method.getName()) && FutureSyncInvocationHandler.isTransactionActive(this.connection)) {
                    return null;
                }
                LettuceFutures.awaitOrCancel(command, this.connection.getTimeout().toNanos(), TimeUnit.NANOSECONDS);
                return command.get();
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private static boolean isTransactionActive(StatefulConnection<?, ?> connection) {
        return connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)connection).isMulti();
    }

    private static boolean isNonTxControlMethod(String methodName) {
        return !methodName.equals("exec") && !methodName.equals("multi");
    }
}

