/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.boot.requestmapping;

import io.leopard.boot.requestmapping.RequestMappingInfoCombiner;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.BasicErrorController;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class LeopardRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    @Value(value="${mvc.restful:true}")
    private boolean restful;
    @Autowired(required=false)
    private List<RequestMappingInfoCombiner> combinerList;

    public RequestMappingInfo.BuilderConfiguration getConfig() {
        try {
            Field field = RequestMappingHandlerMapping.class.getDeclaredField("config");
            field.setAccessible(true);
            return (RequestMappingInfo.BuilderConfiguration)field.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo typeInfo;
        RequestMappingInfo info = this.createRequestMappingInfo(method);
        if (info != null && (typeInfo = this.createRequestMappingInfo(handlerType)) != null) {
            info = typeInfo.combine(info);
        }
        if (info != null && this.combinerList != null) {
            RequestMappingInfo.BuilderConfiguration options = this.getConfig();
            for (RequestMappingInfoCombiner combiner : this.combinerList) {
                RequestMappingInfo info2 = combiner.combine(options, info, method, handlerType);
                if (info2 == null) continue;
                info = info2;
            }
        }
        return info;
    }

    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement element) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        if (requestMapping == null) {
            return null;
        }
        if (element instanceof Class) {
            return this.createClassRequestMappingInfo(requestMapping, (Class)element);
        }
        return this.createMethodRequestMappingInfo(requestMapping, (Method)element);
    }

    protected RequestMappingInfo createClassRequestMappingInfo(RequestMapping requestMapping, Class<?> clazz) {
        RequestCondition condition = this.getCustomTypeCondition(clazz);
        return this.createRequestMappingInfo(requestMapping, condition);
    }

    protected String[] parsePatterns(RequestMapping requestMapping, Method method) {
        Class<?> clazz;
        String[] patterns = method != null && requestMapping.path().length == 0 ? ((clazz = method.getDeclaringClass()).equals(BasicErrorController.class) ? new String[]{} : new String[]{this.createPattern(method.getName())}) : this.resolveEmbeddedValuesInPatterns(requestMapping.path());
        return patterns;
    }

    protected RequestMappingInfo createMethodRequestMappingInfo(RequestMapping requestMapping, Method method) {
        ResponseBody responseBody;
        String[] patterns = this.parsePatterns(requestMapping, method);
        String[] produces = requestMapping.produces();
        if ((produces == null || produces.length == 0) && (responseBody = method.getAnnotation(ResponseBody.class)) != null) {
            produces = new String[]{"application/json;charset=UTF-8"};
        }
        RequestCondition customCondition = this.getCustomMethodCondition(method);
        return RequestMappingInfo.paths((String[])this.resolveEmbeddedValuesInPatterns(patterns)).methods(requestMapping.method()).params(requestMapping.params()).headers(requestMapping.headers()).consumes(requestMapping.consumes()).produces(produces).mappingName(requestMapping.name()).customCondition(customCondition).options(this.getConfig()).build();
    }

    protected String createPattern(String methodName) {
        if (this.restful) {
            return methodName;
        }
        return methodName + ".do";
    }
}

