/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.WebSocketStreamHandler;
import io.kubernetes.client.util.WebSockets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Attach {
    private ApiClient apiClient;

    public Attach() {
        this(Configuration.getDefaultApiClient());
    }

    public Attach(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private String makePath(String namespace, String name, String container, boolean stdin, boolean tty) {
        return "/api/v1/namespaces/" + namespace + "/pods/" + name + "/attach?stdin=" + stdin + "&tty=" + tty + (container != null ? "&container=" + container : "");
    }

    public AttachResult attach(String namespace, String name, boolean stdin) throws ApiException, IOException {
        return this.attach(namespace, name, null, stdin, false);
    }

    public AttachResult attach(V1Pod pod, boolean stdin) throws ApiException, IOException {
        return this.attach(pod, stdin, false);
    }

    public AttachResult attach(V1Pod pod, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.attach(pod, null, stdin, tty);
    }

    public AttachResult attach(V1Pod pod, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.attach(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), container, stdin, tty);
    }

    public AttachResult attach(String namespace, String name, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        String path = this.makePath(namespace, name, container, stdin, tty);
        WebSocketStreamHandler handler = new WebSocketStreamHandler();
        AttachResult result = new AttachResult(handler);
        WebSockets.stream(path, "GET", this.apiClient, handler);
        return result;
    }

    public static class AttachResult
    implements Closeable {
        private WebSocketStreamHandler handler;

        public AttachResult(WebSocketStreamHandler handler) throws IOException {
            this.handler = handler;
        }

        public OutputStream getStandardInputStream() {
            return this.handler.getOutputStream(0);
        }

        public InputStream getStandardOutputStream() throws IOException {
            return this.handler.getInputStream(1);
        }

        public InputStream getErrorStream() throws IOException {
            return this.handler.getInputStream(2);
        }

        @Override
        public void close() {
            this.handler.close();
        }
    }
}

