/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import com.google.common.base.Strings;
import io.kubernetes.client.informer.cache.DeltaFIFO;
import io.kubernetes.client.informer.cache.Indexer;
import io.kubernetes.client.informer.exception.BadObjectException;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.util.Reflect;
import io.kubernetes.client.util.exception.ObjectMetaReflectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class Cache<ApiType>
implements Indexer<ApiType> {
    private Function<ApiType, String> keyFunc;
    public static final String NAMESPACE_INDEX = "namespace";
    private Map<String, Function<ApiType, List<String>>> indexers = new HashMap<String, Function<ApiType, List<String>>>();
    private Map<String, ApiType> items = new HashMap<String, ApiType>();
    private Map<String, Map<String, Set<String>>> indices = new HashMap<String, Map<String, Set<String>>>();
    private ReentrantLock lock = new ReentrantLock();

    public Cache() {
        this(NAMESPACE_INDEX, Cache::metaNamespaceIndexFunc, Cache::deletionHandlingMetaNamespaceKeyFunc);
    }

    public Cache(String indexName, Function<ApiType, List<String>> indexFunc, Function<ApiType, String> keyFunc) {
        this.indexers.put(indexName, indexFunc);
        this.keyFunc = keyFunc;
        this.indices.put(indexName, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        this.lock.lock();
        try {
            ApiType oldObj = this.items.get(key);
            this.items.put(key, obj);
            this.updateIndices(oldObj, obj, key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        this.lock.lock();
        try {
            ApiType oldObj = this.items.get(key);
            this.items.put(key, obj);
            this.updateIndices(oldObj, obj, key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        this.lock.lock();
        try {
            boolean exists = this.items.containsKey(key);
            if (exists) {
                this.deleteFromIndices(this.items.get(key), key);
                this.items.remove(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(List<ApiType> list, String resourceVersion) {
        this.lock.lock();
        try {
            HashMap<String, ApiType> newItems = new HashMap<String, ApiType>();
            for (ApiType ApiType : list) {
                String key = this.keyFunc.apply(ApiType);
                newItems.put(key, ApiType);
            }
            this.items = newItems;
            this.indices = new HashMap<String, Map<String, Set<String>>>();
            for (Map.Entry entry : this.items.entrySet()) {
                this.updateIndices(null, entry.getValue(), (String)entry.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resync() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listKeys() {
        this.lock.lock();
        try {
            ArrayList<String> keys = new ArrayList<String>(this.items.size());
            for (Map.Entry<String, ApiType> entry : this.items.entrySet()) {
                keys.add(entry.getKey());
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiType get(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        this.lock.lock();
        try {
            ApiType ApiType = this.getByKey(key);
            return ApiType;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApiType> list() {
        this.lock.lock();
        try {
            ArrayList<ApiType> itemList = new ArrayList<ApiType>(this.items.size());
            for (Map.Entry<String, ApiType> entry : this.items.entrySet()) {
                itemList.add(entry.getValue());
            }
            ArrayList<ApiType> arrayList = itemList;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ApiType getByKey(String key) {
        this.lock.lock();
        try {
            ApiType ApiType = this.items.get(key);
            return ApiType;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApiType> index(String indexName, Object obj) {
        this.lock.lock();
        try {
            if (!this.indexers.containsKey(indexName)) {
                throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
            }
            Function<ApiType, List<String>> indexFunc = this.indexers.get(indexName);
            List<String> indexKeys = indexFunc.apply(obj);
            Map<String, Set<String>> index = this.indices.get(indexName);
            if (io.kubernetes.client.util.common.Collections.isEmptyMap(index)) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            HashSet<String> returnKeySet = new HashSet<String>();
            for (String indexKey : indexKeys) {
                Set<String> set = index.get(indexKey);
                if (io.kubernetes.client.util.common.Collections.isEmptyCollection(set)) continue;
                returnKeySet.addAll(set);
            }
            ArrayList<ApiType> items = new ArrayList<ApiType>(returnKeySet.size());
            for (String absoluteKey : returnKeySet) {
                items.add(this.items.get(absoluteKey));
            }
            ArrayList<ApiType> arrayList = items;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> indexKeys(String indexName, String indexKey) {
        this.lock.lock();
        try {
            if (!this.indexers.containsKey(indexName)) {
                throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
            }
            Map<String, Set<String>> index = this.indices.get(indexName);
            Set<String> set = index.get(indexKey);
            ArrayList<String> keys = new ArrayList<String>(set.size());
            for (String key : set) {
                keys.add(key);
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApiType> byIndex(String indexName, String indexKey) {
        this.lock.lock();
        try {
            if (!this.indexers.containsKey(indexName)) {
                throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
            }
            Map<String, Set<String>> index = this.indices.get(indexName);
            Set<String> set = index.get(indexKey);
            if (set == null) {
                List<Object> list = Arrays.asList(new Object[0]);
                return list;
            }
            ArrayList<ApiType> items = new ArrayList<ApiType>(set.size());
            for (String key : set) {
                items.add(this.items.get(key));
            }
            ArrayList<ApiType> arrayList = items;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateIndices(ApiType oldObj, ApiType newObj, String key) {
        if (oldObj != null) {
            this.deleteFromIndices(oldObj, key);
        }
        for (Map.Entry<String, Function<ApiType, List<String>>> indexEntry : this.indexers.entrySet()) {
            String indexName = indexEntry.getKey();
            Function<ApiType, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(newObj);
            if (io.kubernetes.client.util.common.Collections.isEmptyCollection(indexValues)) continue;
            Map index = this.indices.computeIfAbsent(indexName, k -> new HashMap());
            for (String indexValue : indexValues) {
                Set indexSet = index.computeIfAbsent(indexValue, k -> new HashSet());
                indexSet.add(key);
            }
        }
    }

    private void deleteFromIndices(ApiType oldObj, String key) {
        for (Map.Entry<String, Function<ApiType, List<String>>> indexEntry : this.indexers.entrySet()) {
            Map<String, Set<String>> index;
            Function<ApiType, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(oldObj);
            if (io.kubernetes.client.util.common.Collections.isEmptyCollection(indexValues) || (index = this.indices.get(indexEntry.getKey())) == null) continue;
            for (String indexValue : indexValues) {
                Set<String> indexSet = index.get(indexValue);
                if (indexSet == null) continue;
                indexSet.remove(key);
            }
        }
    }

    public static <ApiType> String deletionHandlingMetaNamespaceKeyFunc(ApiType object) {
        if (object instanceof DeltaFIFO.DeletedFinalStateUnknown) {
            DeltaFIFO.DeletedFinalStateUnknown deleteObj = (DeltaFIFO.DeletedFinalStateUnknown)object;
            return deleteObj.getKey();
        }
        return Cache.metaNamespaceKeyFunc(object);
    }

    public static String metaNamespaceKeyFunc(Object obj) {
        try {
            V1ObjectMeta metadata;
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof V1ObjectMeta) {
                metadata = (V1ObjectMeta)obj;
            } else {
                metadata = Reflect.objectMetadata(obj);
                if (metadata == null) {
                    throw new BadObjectException(obj);
                }
            }
            if (!Strings.isNullOrEmpty((String)metadata.getNamespace())) {
                return metadata.getNamespace() + "/" + metadata.getName();
            }
            return metadata.getName();
        }
        catch (ObjectMetaReflectException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> metaNamespaceIndexFunc(Object obj) {
        try {
            V1ObjectMeta metadata = Reflect.objectMetadata(obj);
            if (metadata == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(metadata.getNamespace());
        }
        catch (ObjectMetaReflectException e) {
            throw new RuntimeException(e);
        }
    }
}

