/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.custom.Quantity;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okio.ByteString;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class Yaml {
    private static Map<String, Class<?>> classes = new HashMap();
    private static Map<String, String> apiGroups = new HashMap<String, String>();
    private static List<String> apiVersions = new ArrayList<String>();
    static final Logger logger = LoggerFactory.getLogger(Yaml.class);

    private static void initApiGroupMap() {
        apiGroups.put("Admissionregistration", "admissionregistration.k8s.io");
        apiGroups.put("Apiextensions", "apiextensions.k8s.io");
        apiGroups.put("Apiregistration", "apiregistration.k8s.io");
        apiGroups.put("Apps", "apps");
        apiGroups.put("Authentication", "authentication.k8s.io");
        apiGroups.put("Authorization", "authorization.k8s.io");
        apiGroups.put("Autoscaling", "autoscaling");
        apiGroups.put("Extensions", "extensions");
        apiGroups.put("Batch", "batch");
        apiGroups.put("Certificates", "certificates.k8s.io");
        apiGroups.put("Networking", "networking.k8s.io");
        apiGroups.put("Policy", "policy");
        apiGroups.put("RbacAuthorization", "rbac.authorization.k8s.io");
        apiGroups.put("Scheduling", "scheduling.k8s.io");
        apiGroups.put("Settings", "settings.k8s.io");
        apiGroups.put("Storage", "storage.k8s.io");
    }

    private static void initApiVersionList() {
        apiVersions.add("V2beta1");
        apiVersions.add("V2alpha1");
        apiVersions.add("V1beta2");
        apiVersions.add("V1beta1");
        apiVersions.add("V1alpha1");
        apiVersions.add("V1");
    }

    private static Pair<String, String> getApiGroup(String name) {
        MutablePair parts = new MutablePair();
        for (String prefix : apiGroups.keySet()) {
            if (!name.startsWith(prefix)) continue;
            parts.left = apiGroups.get(prefix);
            parts.right = name.substring(prefix.length());
            break;
        }
        if (parts.left == null) {
            parts.right = name;
        }
        return parts;
    }

    private static Pair<String, String> getApiVersion(String name) {
        MutablePair parts = new MutablePair();
        for (String version : apiVersions) {
            if (!name.startsWith(version)) continue;
            parts.left = version.toLowerCase();
            parts.right = name.substring(version.length());
            break;
        }
        if (parts.left == null) {
            parts.right = name;
        }
        return parts;
    }

    private static void initModelMap() throws IOException {
        Yaml.initApiGroupMap();
        Yaml.initApiVersionList();
        ClassPath cp = ClassPath.from((ClassLoader)Yaml.class.getClassLoader());
        ImmutableSet allClasses = cp.getTopLevelClasses("io.kubernetes.client.models");
        for (ClassPath.ClassInfo clazz : allClasses) {
            String modelName = "";
            Pair<String, String> nameParts = Yaml.getApiGroup(clazz.getSimpleName());
            modelName = modelName + (nameParts.getLeft() == null ? "" : (String)nameParts.getLeft() + "/");
            nameParts = Yaml.getApiVersion((String)nameParts.getRight());
            modelName = modelName + (nameParts.getLeft() == null ? "" : (String)nameParts.getLeft() + "/");
            modelName = modelName + (String)nameParts.getRight();
            classes.put(modelName, clazz.load());
        }
    }

    public static void addModelMap(String apiGroupVersion, String kind, Class<?> clazz) {
        classes.put(apiGroupVersion + "/" + kind, clazz);
    }

    public static Object load(String content) throws IOException {
        return Yaml.load(new StringReader(content));
    }

    public static Object load(File f) throws IOException {
        return Yaml.load(new FileReader(f));
    }

    public static Object load(Reader reader) throws IOException {
        Map data = (Map)Yaml.getSnakeYaml().load(reader);
        return Yaml.modelMapper(data);
    }

    public static <T> T loadAs(String content, Class<T> clazz) {
        return (T)Yaml.getSnakeYaml().loadAs((Reader)new StringReader(content), clazz);
    }

    public static <T> T loadAs(File f, Class<T> clazz) throws IOException {
        return (T)Yaml.getSnakeYaml().loadAs((Reader)new FileReader(f), clazz);
    }

    public static <T> T loadAs(Reader reader, Class<T> clazz) {
        return (T)Yaml.getSnakeYaml().loadAs(reader, clazz);
    }

    public static List<Object> loadAll(String content) throws IOException {
        return Yaml.loadAll(new StringReader(content));
    }

    public static List<Object> loadAll(File f) throws IOException {
        return Yaml.loadAll(new FileReader(f));
    }

    public static List<Object> loadAll(Reader reader) throws IOException {
        Iterable iterable = Yaml.getSnakeYaml().loadAll(reader);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : iterable) {
            if (object == null) continue;
            try {
                list.add(Yaml.modelMapper((Map)object));
            }
            catch (ClassCastException ex) {
                logger.error("Unexpected exception while casting: " + ex);
            }
        }
        return list;
    }

    public static String dump(Object object) {
        return Yaml.getSnakeYaml().dump(object);
    }

    public static void dump(Object object, Writer writer) {
        Yaml.getSnakeYaml().dump(object, writer);
    }

    public static String dumpAll(Iterator<? extends Object> data) {
        return Yaml.getSnakeYaml().dumpAll(data);
    }

    public static void dumpAll(Iterator<? extends Object> data, Writer output) {
        Yaml.getSnakeYaml().dumpAll(data, output);
    }

    public static org.yaml.snakeyaml.Yaml getSnakeYaml() {
        return new org.yaml.snakeyaml.Yaml((BaseConstructor)new CustomConstructor(), (Representer)new CustomRepresenter());
    }

    private static Object modelMapper(Map<String, Object> data) throws IOException {
        String kind = (String)data.get("kind");
        if (kind == null) {
            throw new IOException("Missing kind in YAML file!");
        }
        String apiVersion = (String)data.get("apiVersion");
        if (apiVersion == null) {
            throw new IOException("Missing apiVersion in YAML file!");
        }
        Class<?> clazz = classes.get(apiVersion + "/" + kind);
        if (clazz == null && apiVersion.contains("/")) {
            clazz = classes.get(apiVersion.split("/")[1] + "/" + kind);
        }
        if (clazz == null) {
            throw new IOException("Unknown apiVersionKind: " + apiVersion + "/" + kind + " known kinds are: " + classes.toString());
        }
        return Yaml.loadAs(new StringReader(Yaml.getSnakeYaml().dump(data)), clazz);
    }

    static {
        try {
            Yaml.initModelMap();
        }
        catch (Exception ex) {
            logger.error("Unexpected exception while loading classes: " + ex);
        }
    }

    public static class CustomRepresenter
    extends Representer {
        public CustomRepresenter() {
            this.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.representers.put(IntOrString.class, new RepresentIntOrString());
            this.representers.put(byte[].class, new RepresentByteArray());
            this.representers.put(Quantity.class, new RepresentQuantity());
        }

        private int getPropertyPosition(String property) {
            switch (property) {
                case "apiVersion": {
                    return 0;
                }
                case "kind": {
                    return 1;
                }
                case "metadata": {
                    return 2;
                }
                case "spec": {
                    return 3;
                }
                case "type": {
                    return 4;
                }
            }
            return Integer.MAX_VALUE;
        }

        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            MappingNode node = super.representJavaBean(properties, javaBean);
            node.setTag(Tag.MAP);
            Collections.sort(node.getValue(), new Comparator<NodeTuple>(){

                @Override
                public int compare(NodeTuple a, NodeTuple b) {
                    String nameA = ((ScalarNode)a.getKeyNode()).getValue();
                    String nameB = ((ScalarNode)b.getKeyNode()).getValue();
                    int intCompare = Integer.compare(CustomRepresenter.this.getPropertyPosition(nameA), CustomRepresenter.this.getPropertyPosition(nameB));
                    if (intCompare != 0) {
                        return intCompare;
                    }
                    return nameA.compareTo(nameB);
                }
            });
            return node;
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null) {
                return null;
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        private class RepresentQuantity
        implements Represent {
            private RepresentQuantity() {
            }

            public Node representData(Object data) {
                Quantity quantity = (Quantity)data;
                return CustomRepresenter.this.representScalar(Tag.STR, quantity.toSuffixedString());
            }
        }

        private class RepresentByteArray
        implements Represent {
            private RepresentByteArray() {
            }

            public Node representData(Object data) {
                String value = ByteString.of((byte[])((byte[])data)).base64();
                return CustomRepresenter.this.representScalar(Tag.STR, value);
            }
        }

        private class RepresentIntOrString
        implements Represent {
            private RepresentIntOrString() {
            }

            public Node representData(Object data) {
                IntOrString intOrString = (IntOrString)data;
                if (intOrString.isInteger()) {
                    return CustomRepresenter.this.representData(intOrString.getIntValue());
                }
                return CustomRepresenter.this.representData(intOrString.getStrValue());
            }
        }
    }

    public static class CustomConstructor
    extends Constructor {
        protected Object constructObject(Node node) {
            if (node.getType() == IntOrString.class) {
                return this.constructIntOrString((ScalarNode)node);
            }
            if (node.getType() == byte[].class) {
                return this.constructByteArray((ScalarNode)node);
            }
            if (node.getType() == DateTime.class) {
                return this.constructDateTime((ScalarNode)node);
            }
            return super.constructObject(node);
        }

        private IntOrString constructIntOrString(ScalarNode node) {
            try {
                return new IntOrString(Integer.parseInt(node.getValue()));
            }
            catch (NumberFormatException err) {
                return new IntOrString(node.getValue());
            }
        }

        private byte[] constructByteArray(ScalarNode node) {
            return ByteString.decodeBase64((String)node.getValue()).toByteArray();
        }

        private Object constructDateTime(ScalarNode node) {
            return new DateTime((Object)node.getValue(), DateTimeZone.UTC);
        }
    }
}

