/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.taints;

import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeSpec;
import io.kubernetes.client.openapi.models.V1Taint;
import java.util.Iterator;

public class Taints {
    public static V1Taint findTaint(V1Node node, String key, V1Taint.EffectEnum effect) {
        for (V1Taint taint : node.getSpec().getTaints()) {
            if (!taint.getKey().equals(key) || !taint.getEffect().equals((Object)effect)) continue;
            return taint;
        }
        return null;
    }

    public static TaintsBuilder taints(V1Node node) {
        return new TaintsBuilder(node);
    }

    public static class TaintsBuilder {
        private V1Node node;

        TaintsBuilder(V1Node node) {
            this.node = node;
        }

        public TaintsBuilder addTaint(String key, V1Taint.EffectEnum effect) {
            return this.addTaint(key, null, effect);
        }

        public TaintsBuilder addTaint(String key, String value, V1Taint.EffectEnum effect) {
            V1Taint taint = new V1Taint();
            taint.setKey(key);
            taint.setValue(value);
            taint.setEffect(effect);
            if (this.node.getSpec() == null) {
                this.node.setSpec(new V1NodeSpec());
            }
            this.node.getSpec().addTaintsItem(taint);
            return this;
        }

        public TaintsBuilder updateTaint(String key, String value, V1Taint.EffectEnum effect) {
            V1Taint taint = Taints.findTaint(this.node, key, effect);
            taint.setValue(value);
            return this;
        }

        public TaintsBuilder removeTaint(String key) {
            if (this.node.getSpec() == null) {
                return this;
            }
            Iterator taints = this.node.getSpec().getTaints().iterator();
            while (taints.hasNext()) {
                V1Taint taint = (V1Taint)taints.next();
                if (!taint.getKey().equals(key)) continue;
                taints.remove();
            }
            return this;
        }

        public TaintsBuilder removeTaint(String key, V1Taint.EffectEnum effect) {
            if (this.node.getSpec() == null) {
                return this;
            }
            Iterator taints = this.node.getSpec().getTaints().iterator();
            while (taints.hasNext()) {
                V1Taint taint = (V1Taint)taints.next();
                if (!taint.getKey().equals(key) || !taint.getEffect().equals((Object)effect)) continue;
                taints.remove();
            }
            return this;
        }
    }
}

