/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.credentials.AccessTokenAuthentication;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.credentials.ClientCertificateAuthentication;
import io.kubernetes.client.util.credentials.DummyAuthentication;
import io.kubernetes.client.util.credentials.UsernamePasswordAuthentication;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class KubeconfigAuthentication
implements Authentication {
    private final Authentication delegateAuthentication;

    public KubeconfigAuthentication(KubeConfig config) throws IOException {
        byte[] clientCert = config.getDataOrFileRelative(config.getClientCertificateData(), config.getClientCertificateFile());
        byte[] clientKey = config.getDataOrFileRelative(config.getClientKeyData(), config.getClientKeyFile());
        if (clientCert != null && clientKey != null) {
            this.delegateAuthentication = new ClientCertificateAuthentication(clientCert, clientKey);
            return;
        }
        String userName = config.getUsername();
        String userPassword = config.getPassword();
        if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)userPassword)) {
            this.delegateAuthentication = new UsernamePasswordAuthentication(userName, userPassword);
            return;
        }
        String token = config.getAccessToken();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            this.delegateAuthentication = new AccessTokenAuthentication(token);
            return;
        }
        this.delegateAuthentication = new DummyAuthentication();
    }

    @Override
    public void provide(ApiClient client) {
        this.delegateAuthentication.provide(client);
    }

    public Authentication getDelegateAuthentication() {
        return this.delegateAuthentication;
    }
}

