/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.generic;

import io.kubernetes.client.common.KubernetesType;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Status;

public class KubernetesApiResponse<DataType extends KubernetesType> {
    private final DataType object;
    private final V1Status status;
    private final int httpStatusCode;

    public KubernetesApiResponse(DataType object) {
        this.object = object;
        this.status = null;
        this.httpStatusCode = -1;
    }

    public KubernetesApiResponse(V1Status status, int httpStatusCode) {
        this.object = null;
        this.status = status;
        this.httpStatusCode = httpStatusCode;
    }

    public DataType getObject() {
        return this.object;
    }

    public V1Status getStatus() {
        return this.status;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public boolean isSuccess() {
        return this.httpStatusCode < 400;
    }

    public KubernetesApiResponse<DataType> throwsApiException() throws ApiException {
        return this.onFailure((code, errorStatus) -> {
            throw new ApiException(code, errorStatus.toString());
        });
    }

    public KubernetesApiResponse<DataType> onFailure(ErrorStatusHandler errorStatusHandler) throws ApiException {
        if (!this.isSuccess()) {
            errorStatusHandler.handle(this.getHttpStatusCode(), this.status);
        }
        return this;
    }

    public static interface ErrorStatusHandler {
        public void handle(int var1, V1Status var2) throws ApiException;
    }
}

