/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSockets {
    private static final Logger log = LoggerFactory.getLogger(WebSockets.class);
    public static final String V4_STREAM_PROTOCOL = "v4.channel.k8s.io";
    public static final String STREAM_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SPDY_3_1 = "SPDY/3.1";

    public static void stream(String path, String method, ApiClient client, SocketListener listener) throws ApiException, IOException {
        WebSockets.stream(path, method, new ArrayList<Pair>(), client, listener);
    }

    public static void stream(String path, String method, List<Pair> queryParams, ApiClient client, SocketListener listener) throws ApiException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(STREAM_PROTOCOL_HEADER, V4_STREAM_PROTOCOL);
        headers.put("Connection", "Upgrade");
        headers.put("Upgrade", SPDY_3_1);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        Request request = client.buildRequest(path, method, queryParams, new ArrayList(), null, headers, new HashMap(), new HashMap(), localVarAuthNames, null);
        WebSockets.streamRequest(request, client, listener);
    }

    public static void stream(Call call, ApiClient client, SocketListener listener) {
        WebSockets.streamRequest(call.request(), client, listener);
    }

    private static void streamRequest(Request request, ApiClient client, SocketListener listener) {
        client.getHttpClient().newWebSocket(request, (WebSocketListener)new Listener(listener));
    }

    public static class Listener
    extends WebSocketListener {
        private SocketListener listener;

        public Listener(SocketListener listener) {
            this.listener = listener;
        }

        public void onOpen(WebSocket webSocket, Response response) {
            String protocol = response.header(WebSockets.STREAM_PROTOCOL_HEADER, "missing");
            this.listener.open(protocol, webSocket);
        }

        public void onMessage(WebSocket webSocket, String text) {
            this.listener.textMessage(new StringReader(text));
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            this.listener.bytesMessage(new ByteArrayInputStream(bytes.toByteArray()));
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            super.onClosing(webSocket, code, reason);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            this.listener.close();
        }

        public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
            this.listener.failure(t);
            this.listener.close();
        }
    }

    public static interface SocketListener {
        public void open(String var1, WebSocket var2);

        public void bytesMessage(InputStream var1);

        public void textMessage(Reader var1);

        public void failure(Throwable var1);

        public void close();
    }
}

