/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.coreos.monitoring.models.V1PodMonitorSpecPodMetricsEndpoints;
import com.coreos.monitoring.models.V1PodMonitorSpecSelector;
import com.coreos.monitoring.models.V1ServiceMonitorSpecNamespaceSelector;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specification of desired Pod selection for target discovery by Prometheus.")
public class V1PodMonitorSpec {
    public static final String SERIALIZED_NAME_JOB_LABEL = "jobLabel";
    @SerializedName(value="jobLabel")
    private String jobLabel;
    public static final String SERIALIZED_NAME_NAMESPACE_SELECTOR = "namespaceSelector";
    @SerializedName(value="namespaceSelector")
    private V1ServiceMonitorSpecNamespaceSelector namespaceSelector;
    public static final String SERIALIZED_NAME_POD_METRICS_ENDPOINTS = "podMetricsEndpoints";
    @SerializedName(value="podMetricsEndpoints")
    private List<V1PodMonitorSpecPodMetricsEndpoints> podMetricsEndpoints = new ArrayList<V1PodMonitorSpecPodMetricsEndpoints>();
    public static final String SERIALIZED_NAME_POD_TARGET_LABELS = "podTargetLabels";
    @SerializedName(value="podTargetLabels")
    private List<String> podTargetLabels = null;
    public static final String SERIALIZED_NAME_SAMPLE_LIMIT = "sampleLimit";
    @SerializedName(value="sampleLimit")
    private Long sampleLimit;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1PodMonitorSpecSelector selector;

    public V1PodMonitorSpec jobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The label to use to retrieve the job name from.")
    public String getJobLabel() {
        return this.jobLabel;
    }

    public void setJobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
    }

    public V1PodMonitorSpec namespaceSelector(V1ServiceMonitorSpecNamespaceSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ServiceMonitorSpecNamespaceSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public void setNamespaceSelector(V1ServiceMonitorSpecNamespaceSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public V1PodMonitorSpec podMetricsEndpoints(List<V1PodMonitorSpecPodMetricsEndpoints> podMetricsEndpoints) {
        this.podMetricsEndpoints = podMetricsEndpoints;
        return this;
    }

    public V1PodMonitorSpec addPodMetricsEndpointsItem(V1PodMonitorSpecPodMetricsEndpoints podMetricsEndpointsItem) {
        this.podMetricsEndpoints.add(podMetricsEndpointsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of endpoints allowed as part of this PodMonitor.")
    public List<V1PodMonitorSpecPodMetricsEndpoints> getPodMetricsEndpoints() {
        return this.podMetricsEndpoints;
    }

    public void setPodMetricsEndpoints(List<V1PodMonitorSpecPodMetricsEndpoints> podMetricsEndpoints) {
        this.podMetricsEndpoints = podMetricsEndpoints;
    }

    public V1PodMonitorSpec podTargetLabels(List<String> podTargetLabels) {
        this.podTargetLabels = podTargetLabels;
        return this;
    }

    public V1PodMonitorSpec addPodTargetLabelsItem(String podTargetLabelsItem) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.add(podTargetLabelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PodTargetLabels transfers labels on the Kubernetes Pod onto the target.")
    public List<String> getPodTargetLabels() {
        return this.podTargetLabels;
    }

    public void setPodTargetLabels(List<String> podTargetLabels) {
        this.podTargetLabels = podTargetLabels;
    }

    public V1PodMonitorSpec sampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SampleLimit defines per-scrape limit on number of scraped samples that will be accepted.")
    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
    }

    public V1PodMonitorSpec selector(V1PodMonitorSpecSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1PodMonitorSpecSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1PodMonitorSpecSelector selector) {
        this.selector = selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodMonitorSpec v1PodMonitorSpec = (V1PodMonitorSpec)o;
        return Objects.equals(this.jobLabel, v1PodMonitorSpec.jobLabel) && Objects.equals(this.namespaceSelector, v1PodMonitorSpec.namespaceSelector) && Objects.equals(this.podMetricsEndpoints, v1PodMonitorSpec.podMetricsEndpoints) && Objects.equals(this.podTargetLabels, v1PodMonitorSpec.podTargetLabels) && Objects.equals(this.sampleLimit, v1PodMonitorSpec.sampleLimit) && Objects.equals(this.selector, v1PodMonitorSpec.selector);
    }

    public int hashCode() {
        return Objects.hash(this.jobLabel, this.namespaceSelector, this.podMetricsEndpoints, this.podTargetLabels, this.sampleLimit, this.selector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodMonitorSpec {\n");
        sb.append("    jobLabel: ").append(this.toIndentedString(this.jobLabel)).append("\n");
        sb.append("    namespaceSelector: ").append(this.toIndentedString(this.namespaceSelector)).append("\n");
        sb.append("    podMetricsEndpoints: ").append(this.toIndentedString(this.podMetricsEndpoints)).append("\n");
        sb.append("    podTargetLabels: ").append(this.toIndentedString(this.podTargetLabels)).append("\n");
        sb.append("    sampleLimit: ").append(this.toIndentedString(this.sampleLimit)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

