/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.coreos.monitoring.models.V1AlertmanagerSpecPodMetadata;
import com.coreos.monitoring.models.V1AlertmanagerSpecResources;
import com.coreos.monitoring.models.V1AlertmanagerSpecStorage;
import com.coreos.monitoring.models.V1ThanosRulerSpecAffinity;
import com.coreos.monitoring.models.V1ThanosRulerSpecContainers;
import com.coreos.monitoring.models.V1ThanosRulerSpecImagePullSecrets;
import com.coreos.monitoring.models.V1ThanosRulerSpecSecurityContext1;
import com.coreos.monitoring.models.V1ThanosRulerSpecTolerations;
import com.coreos.monitoring.models.V1ThanosRulerSpecVolumeMounts;
import com.coreos.monitoring.models.V1ThanosRulerSpecVolumes;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specification of the desired behavior of the Alertmanager cluster. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status")
public class V1AlertmanagerSpec {
    public static final String SERIALIZED_NAME_ADDITIONAL_PEERS = "additionalPeers";
    @SerializedName(value="additionalPeers")
    private List<String> additionalPeers = null;
    public static final String SERIALIZED_NAME_AFFINITY = "affinity";
    @SerializedName(value="affinity")
    private V1ThanosRulerSpecAffinity affinity;
    public static final String SERIALIZED_NAME_BASE_IMAGE = "baseImage";
    @SerializedName(value="baseImage")
    private String baseImage;
    public static final String SERIALIZED_NAME_CONFIG_MAPS = "configMaps";
    @SerializedName(value="configMaps")
    private List<String> configMaps = null;
    public static final String SERIALIZED_NAME_CONFIG_SECRET = "configSecret";
    @SerializedName(value="configSecret")
    private String configSecret;
    public static final String SERIALIZED_NAME_CONTAINERS = "containers";
    @SerializedName(value="containers")
    private List<V1ThanosRulerSpecContainers> containers = null;
    public static final String SERIALIZED_NAME_EXTERNAL_URL = "externalUrl";
    @SerializedName(value="externalUrl")
    private String externalUrl;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_PULL_SECRETS = "imagePullSecrets";
    @SerializedName(value="imagePullSecrets")
    private List<V1ThanosRulerSpecImagePullSecrets> imagePullSecrets = null;
    public static final String SERIALIZED_NAME_INIT_CONTAINERS = "initContainers";
    @SerializedName(value="initContainers")
    private List<V1ThanosRulerSpecContainers> initContainers = null;
    public static final String SERIALIZED_NAME_LISTEN_LOCAL = "listenLocal";
    @SerializedName(value="listenLocal")
    private Boolean listenLocal;
    public static final String SERIALIZED_NAME_LOG_FORMAT = "logFormat";
    @SerializedName(value="logFormat")
    private String logFormat;
    public static final String SERIALIZED_NAME_LOG_LEVEL = "logLevel";
    @SerializedName(value="logLevel")
    private String logLevel;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    private Map<String, String> nodeSelector = null;
    public static final String SERIALIZED_NAME_PAUSED = "paused";
    @SerializedName(value="paused")
    private Boolean paused;
    public static final String SERIALIZED_NAME_POD_METADATA = "podMetadata";
    @SerializedName(value="podMetadata")
    private V1AlertmanagerSpecPodMetadata podMetadata;
    public static final String SERIALIZED_NAME_PORT_NAME = "portName";
    @SerializedName(value="portName")
    private String portName;
    public static final String SERIALIZED_NAME_PRIORITY_CLASS_NAME = "priorityClassName";
    @SerializedName(value="priorityClassName")
    private String priorityClassName;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private V1AlertmanagerSpecResources resources;
    public static final String SERIALIZED_NAME_RETENTION = "retention";
    @SerializedName(value="retention")
    private String retention;
    public static final String SERIALIZED_NAME_ROUTE_PREFIX = "routePrefix";
    @SerializedName(value="routePrefix")
    private String routePrefix;
    public static final String SERIALIZED_NAME_SECRETS = "secrets";
    @SerializedName(value="secrets")
    private List<String> secrets = null;
    public static final String SERIALIZED_NAME_SECURITY_CONTEXT = "securityContext";
    @SerializedName(value="securityContext")
    private V1ThanosRulerSpecSecurityContext1 securityContext;
    public static final String SERIALIZED_NAME_SERVICE_ACCOUNT_NAME = "serviceAccountName";
    @SerializedName(value="serviceAccountName")
    private String serviceAccountName;
    public static final String SERIALIZED_NAME_SHA = "sha";
    @SerializedName(value="sha")
    private String sha;
    public static final String SERIALIZED_NAME_STORAGE = "storage";
    @SerializedName(value="storage")
    private V1AlertmanagerSpecStorage storage;
    public static final String SERIALIZED_NAME_TAG = "tag";
    @SerializedName(value="tag")
    private String tag;
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    private List<V1ThanosRulerSpecTolerations> tolerations = null;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_VOLUME_MOUNTS = "volumeMounts";
    @SerializedName(value="volumeMounts")
    private List<V1ThanosRulerSpecVolumeMounts> volumeMounts = null;
    public static final String SERIALIZED_NAME_VOLUMES = "volumes";
    @SerializedName(value="volumes")
    private List<V1ThanosRulerSpecVolumes> volumes = null;

    public V1AlertmanagerSpec additionalPeers(List<String> additionalPeers) {
        this.additionalPeers = additionalPeers;
        return this;
    }

    public V1AlertmanagerSpec addAdditionalPeersItem(String additionalPeersItem) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        this.additionalPeers.add(additionalPeersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AdditionalPeers allows injecting a set of additional Alertmanagers to peer with to form a highly available cluster.")
    public List<String> getAdditionalPeers() {
        return this.additionalPeers;
    }

    public void setAdditionalPeers(List<String> additionalPeers) {
        this.additionalPeers = additionalPeers;
    }

    public V1AlertmanagerSpec affinity(V1ThanosRulerSpecAffinity affinity) {
        this.affinity = affinity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ThanosRulerSpecAffinity getAffinity() {
        return this.affinity;
    }

    public void setAffinity(V1ThanosRulerSpecAffinity affinity) {
        this.affinity = affinity;
    }

    public V1AlertmanagerSpec baseImage(String baseImage) {
        this.baseImage = baseImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base image that is used to deploy pods, without tag.")
    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public V1AlertmanagerSpec configMaps(List<String> configMaps) {
        this.configMaps = configMaps;
        return this;
    }

    public V1AlertmanagerSpec addConfigMapsItem(String configMapsItem) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        this.configMaps.add(configMapsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConfigMaps is a list of ConfigMaps in the same namespace as the Alertmanager object, which shall be mounted into the Alertmanager Pods. The ConfigMaps are mounted into /etc/alertmanager/configmaps/<configmap-name>.")
    public List<String> getConfigMaps() {
        return this.configMaps;
    }

    public void setConfigMaps(List<String> configMaps) {
        this.configMaps = configMaps;
    }

    public V1AlertmanagerSpec configSecret(String configSecret) {
        this.configSecret = configSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConfigSecret is the name of a Kubernetes Secret in the same namespace as the Alertmanager object, which contains configuration for this Alertmanager instance. Defaults to 'alertmanager-<alertmanager-name>' The secret is mounted into /etc/alertmanager/config.")
    public String getConfigSecret() {
        return this.configSecret;
    }

    public void setConfigSecret(String configSecret) {
        this.configSecret = configSecret;
    }

    public V1AlertmanagerSpec containers(List<V1ThanosRulerSpecContainers> containers) {
        this.containers = containers;
        return this;
    }

    public V1AlertmanagerSpec addContainersItem(V1ThanosRulerSpecContainers containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<V1ThanosRulerSpecContainers>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Containers allows injecting additional containers. This is meant to allow adding an authentication proxy to an Alertmanager pod.")
    public List<V1ThanosRulerSpecContainers> getContainers() {
        return this.containers;
    }

    public void setContainers(List<V1ThanosRulerSpecContainers> containers) {
        this.containers = containers;
    }

    public V1AlertmanagerSpec externalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external URL the Alertmanager instances will be available under. This is necessary to generate correct URLs. This is necessary if Alertmanager is not served from root of a DNS name.")
    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public V1AlertmanagerSpec image(String image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image if specified has precedence over baseImage, tag and sha combinations. Specifying the version is still necessary to ensure the Prometheus Operator knows what version of Alertmanager is being configured.")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1AlertmanagerSpec imagePullSecrets(List<V1ThanosRulerSpecImagePullSecrets> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
        return this;
    }

    public V1AlertmanagerSpec addImagePullSecretsItem(V1ThanosRulerSpecImagePullSecrets imagePullSecretsItem) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1ThanosRulerSpecImagePullSecrets>();
        }
        this.imagePullSecrets.add(imagePullSecretsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional list of references to secrets in the same namespace to use for pulling prometheus and alertmanager images from registries see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod")
    public List<V1ThanosRulerSpecImagePullSecrets> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<V1ThanosRulerSpecImagePullSecrets> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public V1AlertmanagerSpec initContainers(List<V1ThanosRulerSpecContainers> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public V1AlertmanagerSpec addInitContainersItem(V1ThanosRulerSpecContainers initContainersItem) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<V1ThanosRulerSpecContainers>();
        }
        this.initContainers.add(initContainersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the Alertmanager configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice.")
    public List<V1ThanosRulerSpecContainers> getInitContainers() {
        return this.initContainers;
    }

    public void setInitContainers(List<V1ThanosRulerSpecContainers> initContainers) {
        this.initContainers = initContainers;
    }

    public V1AlertmanagerSpec listenLocal(Boolean listenLocal) {
        this.listenLocal = listenLocal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ListenLocal makes the Alertmanager server listen on loopback, so that it does not bind against the Pod IP. Note this is only for the Alertmanager UI, not the gossip communication.")
    public Boolean getListenLocal() {
        return this.listenLocal;
    }

    public void setListenLocal(Boolean listenLocal) {
        this.listenLocal = listenLocal;
    }

    public V1AlertmanagerSpec logFormat(String logFormat) {
        this.logFormat = logFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Log format for Alertmanager to be configured with.")
    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public V1AlertmanagerSpec logLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Log level for Alertmanager to be configured with.")
    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public V1AlertmanagerSpec nodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public V1AlertmanagerSpec putNodeSelectorItem(String key, String nodeSelectorItem) {
        if (this.nodeSelector == null) {
            this.nodeSelector = new HashMap<String, String>();
        }
        this.nodeSelector.put(key, nodeSelectorItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Define which Nodes the Pods are scheduled on.")
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1AlertmanagerSpec paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to true all actions on the underlaying managed objects are not goint to be performed, except for delete actions.")
    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public V1AlertmanagerSpec podMetadata(V1AlertmanagerSpecPodMetadata podMetadata) {
        this.podMetadata = podMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1AlertmanagerSpecPodMetadata getPodMetadata() {
        return this.podMetadata;
    }

    public void setPodMetadata(V1AlertmanagerSpecPodMetadata podMetadata) {
        this.podMetadata = podMetadata;
    }

    public V1AlertmanagerSpec portName(String portName) {
        this.portName = portName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Port name used for the pods and governing service. This defaults to web")
    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public V1AlertmanagerSpec priorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Priority class assigned to the Pods")
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public void setPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
    }

    public V1AlertmanagerSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size is the expected size of the alertmanager cluster. The controller will eventually make the size of the running cluster equal to the expected size.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1AlertmanagerSpec resources(V1AlertmanagerSpecResources resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1AlertmanagerSpecResources getResources() {
        return this.resources;
    }

    public void setResources(V1AlertmanagerSpecResources resources) {
        this.resources = resources;
    }

    public V1AlertmanagerSpec retention(String retention) {
        this.retention = retention;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time duration Alertmanager shall retain data for. Default is '120h', and must match the regular expression `[0-9]+(ms|s|m|h)` (milliseconds seconds minutes hours).")
    public String getRetention() {
        return this.retention;
    }

    public void setRetention(String retention) {
        this.retention = retention;
    }

    public V1AlertmanagerSpec routePrefix(String routePrefix) {
        this.routePrefix = routePrefix;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The route prefix Alertmanager registers HTTP handlers for. This is useful, if using ExternalURL and a proxy is rewriting HTTP routes of a request, and the actual ExternalURL is still true, but the server serves requests under a different route prefix. For example for use with `kubectl proxy`.")
    public String getRoutePrefix() {
        return this.routePrefix;
    }

    public void setRoutePrefix(String routePrefix) {
        this.routePrefix = routePrefix;
    }

    public V1AlertmanagerSpec secrets(List<String> secrets) {
        this.secrets = secrets;
        return this;
    }

    public V1AlertmanagerSpec addSecretsItem(String secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Secrets is a list of Secrets in the same namespace as the Alertmanager object, which shall be mounted into the Alertmanager Pods. The Secrets are mounted into /etc/alertmanager/secrets/<secret-name>.")
    public List<String> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<String> secrets) {
        this.secrets = secrets;
    }

    public V1AlertmanagerSpec securityContext(V1ThanosRulerSpecSecurityContext1 securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ThanosRulerSpecSecurityContext1 getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(V1ThanosRulerSpecSecurityContext1 securityContext) {
        this.securityContext = securityContext;
    }

    public V1AlertmanagerSpec serviceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ServiceAccountName is the name of the ServiceAccount to use to run the Prometheus Pods.")
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    public V1AlertmanagerSpec sha(String sha) {
        this.sha = sha;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SHA of Alertmanager container image to be deployed. Defaults to the value of `version`. Similar to a tag, but the SHA explicitly deploys an immutable container image. Version and Tag are ignored if SHA is set.")
    public String getSha() {
        return this.sha;
    }

    public void setSha(String sha) {
        this.sha = sha;
    }

    public V1AlertmanagerSpec storage(V1AlertmanagerSpecStorage storage) {
        this.storage = storage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1AlertmanagerSpecStorage getStorage() {
        return this.storage;
    }

    public void setStorage(V1AlertmanagerSpecStorage storage) {
        this.storage = storage;
    }

    public V1AlertmanagerSpec tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tag of Alertmanager container image to be deployed. Defaults to the value of `version`. Version is ignored if Tag is set.")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public V1AlertmanagerSpec tolerations(List<V1ThanosRulerSpecTolerations> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1AlertmanagerSpec addTolerationsItem(V1ThanosRulerSpecTolerations tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1ThanosRulerSpecTolerations>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the pod's tolerations.")
    public List<V1ThanosRulerSpecTolerations> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<V1ThanosRulerSpecTolerations> tolerations) {
        this.tolerations = tolerations;
    }

    public V1AlertmanagerSpec version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version the cluster should be on.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public V1AlertmanagerSpec volumeMounts(List<V1ThanosRulerSpecVolumeMounts> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public V1AlertmanagerSpec addVolumeMountsItem(V1ThanosRulerSpecVolumeMounts volumeMountsItem) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<V1ThanosRulerSpecVolumeMounts>();
        }
        this.volumeMounts.add(volumeMountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeMounts allows configuration of additional VolumeMounts on the output StatefulSet definition. VolumeMounts specified will be appended to other VolumeMounts in the alertmanager container, that are generated as a result of StorageSpec objects.")
    public List<V1ThanosRulerSpecVolumeMounts> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<V1ThanosRulerSpecVolumeMounts> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public V1AlertmanagerSpec volumes(List<V1ThanosRulerSpecVolumes> volumes) {
        this.volumes = volumes;
        return this;
    }

    public V1AlertmanagerSpec addVolumesItem(V1ThanosRulerSpecVolumes volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<V1ThanosRulerSpecVolumes>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Volumes allows configuration of additional volumes on the output StatefulSet definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects.")
    public List<V1ThanosRulerSpecVolumes> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<V1ThanosRulerSpecVolumes> volumes) {
        this.volumes = volumes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AlertmanagerSpec v1AlertmanagerSpec = (V1AlertmanagerSpec)o;
        return Objects.equals(this.additionalPeers, v1AlertmanagerSpec.additionalPeers) && Objects.equals(this.affinity, v1AlertmanagerSpec.affinity) && Objects.equals(this.baseImage, v1AlertmanagerSpec.baseImage) && Objects.equals(this.configMaps, v1AlertmanagerSpec.configMaps) && Objects.equals(this.configSecret, v1AlertmanagerSpec.configSecret) && Objects.equals(this.containers, v1AlertmanagerSpec.containers) && Objects.equals(this.externalUrl, v1AlertmanagerSpec.externalUrl) && Objects.equals(this.image, v1AlertmanagerSpec.image) && Objects.equals(this.imagePullSecrets, v1AlertmanagerSpec.imagePullSecrets) && Objects.equals(this.initContainers, v1AlertmanagerSpec.initContainers) && Objects.equals(this.listenLocal, v1AlertmanagerSpec.listenLocal) && Objects.equals(this.logFormat, v1AlertmanagerSpec.logFormat) && Objects.equals(this.logLevel, v1AlertmanagerSpec.logLevel) && Objects.equals(this.nodeSelector, v1AlertmanagerSpec.nodeSelector) && Objects.equals(this.paused, v1AlertmanagerSpec.paused) && Objects.equals(this.podMetadata, v1AlertmanagerSpec.podMetadata) && Objects.equals(this.portName, v1AlertmanagerSpec.portName) && Objects.equals(this.priorityClassName, v1AlertmanagerSpec.priorityClassName) && Objects.equals(this.replicas, v1AlertmanagerSpec.replicas) && Objects.equals(this.resources, v1AlertmanagerSpec.resources) && Objects.equals(this.retention, v1AlertmanagerSpec.retention) && Objects.equals(this.routePrefix, v1AlertmanagerSpec.routePrefix) && Objects.equals(this.secrets, v1AlertmanagerSpec.secrets) && Objects.equals(this.securityContext, v1AlertmanagerSpec.securityContext) && Objects.equals(this.serviceAccountName, v1AlertmanagerSpec.serviceAccountName) && Objects.equals(this.sha, v1AlertmanagerSpec.sha) && Objects.equals(this.storage, v1AlertmanagerSpec.storage) && Objects.equals(this.tag, v1AlertmanagerSpec.tag) && Objects.equals(this.tolerations, v1AlertmanagerSpec.tolerations) && Objects.equals(this.version, v1AlertmanagerSpec.version) && Objects.equals(this.volumeMounts, v1AlertmanagerSpec.volumeMounts) && Objects.equals(this.volumes, v1AlertmanagerSpec.volumes);
    }

    public int hashCode() {
        return Objects.hash(this.additionalPeers, this.affinity, this.baseImage, this.configMaps, this.configSecret, this.containers, this.externalUrl, this.image, this.imagePullSecrets, this.initContainers, this.listenLocal, this.logFormat, this.logLevel, this.nodeSelector, this.paused, this.podMetadata, this.portName, this.priorityClassName, this.replicas, this.resources, this.retention, this.routePrefix, this.secrets, this.securityContext, this.serviceAccountName, this.sha, this.storage, this.tag, this.tolerations, this.version, this.volumeMounts, this.volumes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AlertmanagerSpec {\n");
        sb.append("    additionalPeers: ").append(this.toIndentedString(this.additionalPeers)).append("\n");
        sb.append("    affinity: ").append(this.toIndentedString(this.affinity)).append("\n");
        sb.append("    baseImage: ").append(this.toIndentedString(this.baseImage)).append("\n");
        sb.append("    configMaps: ").append(this.toIndentedString(this.configMaps)).append("\n");
        sb.append("    configSecret: ").append(this.toIndentedString(this.configSecret)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    externalUrl: ").append(this.toIndentedString(this.externalUrl)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imagePullSecrets: ").append(this.toIndentedString(this.imagePullSecrets)).append("\n");
        sb.append("    initContainers: ").append(this.toIndentedString(this.initContainers)).append("\n");
        sb.append("    listenLocal: ").append(this.toIndentedString(this.listenLocal)).append("\n");
        sb.append("    logFormat: ").append(this.toIndentedString(this.logFormat)).append("\n");
        sb.append("    logLevel: ").append(this.toIndentedString(this.logLevel)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    podMetadata: ").append(this.toIndentedString(this.podMetadata)).append("\n");
        sb.append("    portName: ").append(this.toIndentedString(this.portName)).append("\n");
        sb.append("    priorityClassName: ").append(this.toIndentedString(this.priorityClassName)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    retention: ").append(this.toIndentedString(this.retention)).append("\n");
        sb.append("    routePrefix: ").append(this.toIndentedString(this.routePrefix)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("    securityContext: ").append(this.toIndentedString(this.securityContext)).append("\n");
        sb.append("    serviceAccountName: ").append(this.toIndentedString(this.serviceAccountName)).append("\n");
        sb.append("    sha: ").append(this.toIndentedString(this.sha)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString(this.storage)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    volumeMounts: ").append(this.toIndentedString(this.volumeMounts)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

