/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.coreos.monitoring.models.V1ThanosRulerSpecConfigMapItems;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret")
public class V1ThanosRulerSpecSecret {
    public static final String SERIALIZED_NAME_DEFAULT_MODE = "defaultMode";
    @SerializedName(value="defaultMode")
    private Integer defaultMode;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<V1ThanosRulerSpecConfigMapItems> items = null;
    public static final String SERIALIZED_NAME_OPTIONAL = "optional";
    @SerializedName(value="optional")
    private Boolean optional;
    public static final String SERIALIZED_NAME_SECRET_NAME = "secretName";
    @SerializedName(value="secretName")
    private String secretName;

    public V1ThanosRulerSpecSecret defaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public V1ThanosRulerSpecSecret items(List<V1ThanosRulerSpecConfigMapItems> items) {
        this.items = items;
        return this;
    }

    public V1ThanosRulerSpecSecret addItemsItem(V1ThanosRulerSpecConfigMapItems itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<V1ThanosRulerSpecConfigMapItems>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.")
    public List<V1ThanosRulerSpecConfigMapItems> getItems() {
        return this.items;
    }

    public void setItems(List<V1ThanosRulerSpecConfigMapItems> items) {
        this.items = items;
    }

    public V1ThanosRulerSpecSecret optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify whether the Secret or its keys must be defined")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public V1ThanosRulerSpecSecret secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ThanosRulerSpecSecret v1ThanosRulerSpecSecret = (V1ThanosRulerSpecSecret)o;
        return Objects.equals(this.defaultMode, v1ThanosRulerSpecSecret.defaultMode) && Objects.equals(this.items, v1ThanosRulerSpecSecret.items) && Objects.equals(this.optional, v1ThanosRulerSpecSecret.optional) && Objects.equals(this.secretName, v1ThanosRulerSpecSecret.secretName);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.optional, this.secretName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ThanosRulerSpecSecret {\n");
        sb.append("    defaultMode: ").append(this.toIndentedString(this.defaultMode)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

