/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.History;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.KubectlRollout;
import io.kubernetes.client.extended.kubectl.PatchHelper;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.extended.kubectl.util.deployment.DeploymentHelper;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.models.V1ControllerRevision;
import io.kubernetes.client.openapi.models.V1ControllerRevisionList;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.util.labels.LabelSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class KubectlRollout<ApiType extends KubernetesObject> {
    private Class<ApiType> apiTypeClass;

    KubectlRollout(Class<ApiType> apiTypeClass) {
        this.apiTypeClass = apiTypeClass;
    }

    public KubectlRolloutHistory history() {
        return new KubectlRolloutHistory();
    }

    public class KubectlRolloutHistory
    extends Kubectl.ResourceBuilder<ApiType, KubectlRolloutHistory>
    implements Kubectl.Executable<List<History>> {
        public static final String CHANGE_CAUSE_ANNOTATION = "kubernetes.io/change-cause";
        private long revision;
        private final List<History> histories;
        private V1PodTemplateSpec template;

        KubectlRolloutHistory() {
            super(KubectlRollout.this.apiTypeClass);
            this.histories = new ArrayList<History>();
            this.revision = 0L;
        }

        @Override
        public List<History> execute() throws KubectlException {
            this.validate();
            AppsV1Api api = new AppsV1Api(this.apiClient);
            this.refreshDiscovery();
            try {
                if (this.apiTypeClass.equals(V1Deployment.class)) {
                    V1Deployment deployment = api.readNamespacedDeployment(this.name, this.namespace).execute();
                    this.deploymentViewHistory(deployment, api);
                } else if (this.apiTypeClass.equals(V1DaemonSet.class)) {
                    V1DaemonSet daemonSet = api.readNamespacedDaemonSet(this.name, this.namespace).execute();
                    this.daemonSetViewHistory(daemonSet, api);
                } else if (this.apiTypeClass.equals(V1StatefulSet.class)) {
                    V1StatefulSet statefulSet = api.readNamespacedStatefulSet(this.name, this.namespace).execute();
                    this.statefulSetViewHistory(statefulSet, api);
                } else {
                    throw new KubectlException("Unsupported class for rollout history: " + String.valueOf(this.apiTypeClass));
                }
                return this.histories;
            }
            catch (ApiException ex) {
                throw new KubectlException(ex);
            }
        }

        public io.kubernetes.client.extended.kubectl.KubectlRollout$KubectlRolloutHistory.KubectlRolloutHistoryRevision revision(int revision) {
            this.revision = revision;
            return new KubectlRolloutHistoryRevision();
        }

        private void validate() throws KubectlException {
            StringBuilder msg = new StringBuilder();
            if (this.name == null) {
                msg.append("Missing name, ");
            }
            if (this.namespace == null) {
                msg.append("Missing namespace, ");
            }
            if (this.revision < 0L) {
                msg.append("revision must be a positive integer: ").append(this.revision);
            }
            if (msg.length() > 0) {
                throw new KubectlException(msg.toString());
            }
        }

        private void deploymentViewHistory(V1Deployment deployment, AppsV1Api api) throws ApiException {
            String changeCause;
            ArrayList<V1ReplicaSet> oldRSs = new ArrayList<V1ReplicaSet>();
            ArrayList<V1ReplicaSet> allOldRSs = new ArrayList<V1ReplicaSet>();
            V1ReplicaSet newRs = DeploymentHelper.getAllReplicaSets(deployment, api, oldRSs, allOldRSs);
            if (newRs != null) {
                allOldRSs.add(newRs);
            }
            HashMap<Long, V1PodTemplateSpec> historyInfo = new HashMap<Long, V1PodTemplateSpec>();
            for (V1ReplicaSet rs : allOldRSs) {
                Long v = DeploymentHelper.revision(rs.getMetadata());
                historyInfo.put(v, rs.getSpec().getTemplate());
                changeCause = this.getChangeCause(rs.getMetadata());
                if (((V1PodTemplateSpec)historyInfo.get(v)).getMetadata().getAnnotations() == null) {
                    ((V1PodTemplateSpec)historyInfo.get(v)).getMetadata().setAnnotations(new HashMap());
                }
                if (changeCause == null || changeCause.length() <= 0) continue;
                ((V1PodTemplateSpec)historyInfo.get(v)).getMetadata().getAnnotations().put(CHANGE_CAUSE_ANNOTATION, changeCause);
            }
            if (this.revision > 0L) {
                V1PodTemplateSpec template = (V1PodTemplateSpec)historyInfo.get(this.revision);
                if (template == null) {
                    throw new ApiException("unable to find the specified revision " + this.revision + ", supported revisions: [" + historyInfo.keySet().stream().map(Object::toString).collect(Collectors.joining(",")) + "]");
                }
                this.template = template;
                return;
            }
            ArrayList revisions = new ArrayList(historyInfo.keySet());
            revisions.sort(Long::compareTo);
            for (Long revision : revisions) {
                changeCause = this.getChangeCause(((V1PodTemplateSpec)historyInfo.get(revision)).getMetadata());
                if (changeCause == null || changeCause.isEmpty()) {
                    changeCause = "<none>";
                }
                this.histories.add(new History(revision, changeCause));
            }
        }

        private void daemonSetViewHistory(V1DaemonSet daemonSet, AppsV1Api api) throws ApiException, KubectlException {
            LabelSelector selector = LabelSelector.parse((V1LabelSelector)daemonSet.getSpec().getSelector());
            List<V1ControllerRevision> historyList = this.controlledHistory(api, (KubernetesObject)daemonSet, selector);
            this.parseHistory(historyList, history -> {
                V1DaemonSet dsOfHistory = this.applyDaemonSetHistory(history);
                return dsOfHistory.getSpec().getTemplate();
            });
        }

        private V1DaemonSet applyDaemonSetHistory(V1ControllerRevision history) throws KubectlException, ApiException {
            this.apiClient.getJSON();
            String patch = JSON.serialize((Object)history.getData());
            return (V1DaemonSet)PatchHelper.dryRunStrategyMergePatch(this.getGenericApi(), patch, this.namespace, this.name);
        }

        private void statefulSetViewHistory(V1StatefulSet statefulSet, AppsV1Api api) throws ApiException, KubectlException {
            LabelSelector selector = LabelSelector.parse((V1LabelSelector)statefulSet.getSpec().getSelector());
            List<V1ControllerRevision> historyList = this.controlledHistory(api, (KubernetesObject)statefulSet, selector);
            this.parseHistory(historyList, history -> {
                V1StatefulSet stsOfHistory = this.applyStatefulSetHistory(history);
                return stsOfHistory.getSpec().getTemplate();
            });
        }

        private V1StatefulSet applyStatefulSetHistory(V1ControllerRevision history) throws KubectlException, ApiException {
            this.apiClient.getJSON();
            String patch = JSON.serialize((Object)history.getData());
            return (V1StatefulSet)PatchHelper.dryRunStrategyMergePatch(this.getGenericApi(), patch, this.namespace, this.name);
        }

        private void parseHistory(List<V1ControllerRevision> historyList, PodTemplateParser parser) throws ApiException, KubectlException {
            HashMap<Long, V1ControllerRevision> historyInfo = new HashMap<Long, V1ControllerRevision>();
            for (V1ControllerRevision history : historyList) {
                historyInfo.put(history.getRevision(), history);
            }
            if (this.revision > 0L) {
                V1ControllerRevision history = (V1ControllerRevision)historyInfo.get(this.revision);
                if (history == null) {
                    throw new ApiException("unable to find the specified revision " + this.revision + ", supported revisions: [" + historyInfo.keySet().stream().map(Object::toString).collect(Collectors.joining(",")) + "]");
                }
                this.template = parser.parse(history);
                return;
            }
            ArrayList revisions = new ArrayList(historyInfo.keySet());
            revisions.sort(Long::compareTo);
            for (Long revision : revisions) {
                String changeCause = this.getChangeCause(((V1ControllerRevision)historyInfo.get(revision)).getMetadata());
                if (changeCause == null || changeCause.isEmpty()) {
                    changeCause = "<none>";
                }
                this.histories.add(new History(revision, changeCause));
            }
        }

        private List<V1ControllerRevision> controlledHistory(AppsV1Api api, KubernetesObject accessor, LabelSelector selector) throws ApiException {
            ArrayList<V1ControllerRevision> result = new ArrayList<V1ControllerRevision>();
            V1ControllerRevisionList historyList = api.listNamespacedControllerRevision(this.namespace).labelSelector(selector.toString()).execute();
            for (V1ControllerRevision history : historyList.getItems()) {
                if (!this.isControlledBy((KubernetesObject)history, accessor)) continue;
                result.add(history);
            }
            return result;
        }

        private boolean isControlledBy(KubernetesObject obj, KubernetesObject owner) {
            return obj.getMetadata().getOwnerReferences().stream().filter(r -> r.getController() != null && r.getController() != false).findAny().map(v1OwnerReference -> v1OwnerReference.getUid().equals(owner.getMetadata().getUid())).orElse(false);
        }

        private String getChangeCause(V1ObjectMeta meta) {
            if (meta.getAnnotations() == null) {
                return null;
            }
            return (String)meta.getAnnotations().get(CHANGE_CAUSE_ANNOTATION);
        }

        public class KubectlRolloutHistoryRevision
        extends Kubectl.ResourceBuilder<ApiType, io.kubernetes.client.extended.kubectl.KubectlRollout$KubectlRolloutHistory.KubectlRolloutHistoryRevision>
        implements Kubectl.Executable<V1PodTemplateSpec> {
            KubectlRolloutHistoryRevision() {
                super(KubectlRolloutHistory.this.apiTypeClass);
            }

            @Override
            public io.kubernetes.client.extended.kubectl.KubectlRollout$KubectlRolloutHistory.KubectlRolloutHistoryRevision name(String name) {
                KubectlRolloutHistory.this.name(name);
                return (KubectlRolloutHistoryRevision)super.name(name);
            }

            @Override
            public io.kubernetes.client.extended.kubectl.KubectlRollout$KubectlRolloutHistory.KubectlRolloutHistoryRevision namespace(String namespace) {
                KubectlRolloutHistory.this.namespace(namespace);
                return (KubectlRolloutHistoryRevision)super.namespace(namespace);
            }

            @Override
            public io.kubernetes.client.extended.kubectl.KubectlRollout$KubectlRolloutHistory.KubectlRolloutHistoryRevision apiClient(ApiClient apiClient) {
                KubectlRolloutHistory.this.apiClient(apiClient);
                return (KubectlRolloutHistoryRevision)super.apiClient(apiClient);
            }

            @Override
            public io.kubernetes.client.extended.kubectl.KubectlRollout$KubectlRolloutHistory.KubectlRolloutHistoryRevision skipDiscovery() {
                KubectlRolloutHistory.this.skipDiscovery();
                return (KubectlRolloutHistoryRevision)super.skipDiscovery();
            }

            @Override
            public V1PodTemplateSpec execute() throws KubectlException {
                KubectlRolloutHistory.this.execute();
                return KubectlRolloutHistory.this.template;
            }
        }
    }

    @FunctionalInterface
    public static interface PodTemplateParser {
        public V1PodTemplateSpec parse(V1ControllerRevision var1) throws ApiException, KubectlException;
    }
}

