/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.controller;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.informer.SharedInformerFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerManager
implements Controller {
    private static final Logger log = LoggerFactory.getLogger(ControllerManager.class);
    private Controller[] controllers;
    private ExecutorService controllerThreadPool;
    private SharedInformerFactory informerFactory;

    public ControllerManager(SharedInformerFactory factory, Controller ... controllers) {
        this.controllers = controllers;
        this.informerFactory = factory;
    }

    @Override
    public void shutdown() {
        for (Controller controller : this.controllers) {
            controller.shutdown();
        }
        if (this.controllerThreadPool != null) {
            this.controllerThreadPool.shutdown();
        }
        this.informerFactory.stopAllRegisteredInformers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.controllers.length == 0) {
            throw new RuntimeException("no controller registered in the manager..");
        }
        this.informerFactory.startAllRegisteredInformers();
        CountDownLatch latch = new CountDownLatch(this.controllers.length);
        this.controllerThreadPool = Executors.newFixedThreadPool(this.controllers.length);
        for (Controller controller : this.controllers) {
            this.controllerThreadPool.submit(() -> {
                try {
                    log.debug("Starting controller manager");
                    controller.run();
                }
                catch (Throwable t) {
                    log.error("Unexpected controller termination", t);
                }
                finally {
                    latch.countDown();
                    log.debug("Exiting controller manager");
                }
            });
        }
        try {
            log.debug("Controller-Manager bootstrapping.");
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("Aborting controller-manager.", (Throwable)e);
        }
        finally {
            log.info("Controller-Manager exited");
        }
    }
}

