/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ConfigMap holds configuration data for pods to consume.")
public class V1ConfigMap
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_BINARY_DATA = "binaryData";
    @SerializedName(value="binaryData")
    private Map<String, byte[]> binaryData = null;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private Map<String, String> data = null;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;

    public V1ConfigMap apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ConfigMap binaryData(Map<String, byte[]> binaryData) {
        this.binaryData = binaryData;
        return this;
    }

    public V1ConfigMap putBinaryDataItem(String key, byte[] binaryDataItem) {
        if (this.binaryData == null) {
            this.binaryData = new HashMap<String, byte[]>();
        }
        this.binaryData.put(key, binaryDataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.")
    public Map<String, byte[]> getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(Map<String, byte[]> binaryData) {
        this.binaryData = binaryData;
    }

    public V1ConfigMap data(Map<String, String> data) {
        this.data = data;
        return this;
    }

    public V1ConfigMap putDataItem(String key, String dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.")
    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public V1ConfigMap kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ConfigMap metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ConfigMap v1ConfigMap = (V1ConfigMap)o;
        return Objects.equals(this.apiVersion, v1ConfigMap.apiVersion) && Objects.equals(this.binaryData, v1ConfigMap.binaryData) && Objects.equals(this.data, v1ConfigMap.data) && Objects.equals(this.kind, v1ConfigMap.kind) && Objects.equals(this.metadata, v1ConfigMap.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.binaryData, this.data, this.kind, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ConfigMap {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    binaryData: ").append(this.toIndentedString(this.binaryData)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

