/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names.")
public class V1beta1Subject {
    public static final String SERIALIZED_NAME_API_GROUP = "apiGroup";
    @SerializedName(value="apiGroup")
    private String apiGroup;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;

    public V1beta1Subject apiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIGroup holds the API group of the referenced subject. Defaults to \"\" for ServiceAccount subjects. Defaults to \"rbac.authorization.k8s.io\" for User and Group subjects.")
    public String getApiGroup() {
        return this.apiGroup;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public V1beta1Subject kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="Kind of object being referenced. Values defined by this API group are \"User\", \"Group\", and \"ServiceAccount\". If the Authorizer does not recognized the kind value, the Authorizer should report an error.")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1Subject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the object being referenced.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1Subject namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Namespace of the referenced object.  If the object kind is non-namespace, such as \"User\" or \"Group\", and this value is not empty the Authorizer should report an error.")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1Subject v1beta1Subject = (V1beta1Subject)o;
        return Objects.equals(this.apiGroup, v1beta1Subject.apiGroup) && Objects.equals(this.kind, v1beta1Subject.kind) && Objects.equals(this.name, v1beta1Subject.name) && Objects.equals(this.namespace, v1beta1Subject.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroup, this.kind, this.name, this.namespace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1Subject {\n");
        sb.append("    apiGroup: ").append(this.toIndentedString(this.apiGroup)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

