/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluentImpl;
import io.kubernetes.client.openapi.models.V1beta2DaemonSetSpec;
import io.kubernetes.client.openapi.models.V1beta2DaemonSetSpecFluent;
import io.kubernetes.client.openapi.models.V1beta2DaemonSetUpdateStrategy;
import io.kubernetes.client.openapi.models.V1beta2DaemonSetUpdateStrategyBuilder;
import io.kubernetes.client.openapi.models.V1beta2DaemonSetUpdateStrategyFluentImpl;

public class V1beta2DaemonSetSpecFluentImpl<A extends V1beta2DaemonSetSpecFluent<A>>
extends BaseFluent<A>
implements V1beta2DaemonSetSpecFluent<A> {
    private Integer minReadySeconds;
    private Integer revisionHistoryLimit;
    private V1LabelSelectorBuilder selector;
    private V1PodTemplateSpecBuilder template;
    private V1beta2DaemonSetUpdateStrategyBuilder updateStrategy;

    public V1beta2DaemonSetSpecFluentImpl() {
    }

    public V1beta2DaemonSetSpecFluentImpl(V1beta2DaemonSetSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V1beta2DaemonSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V1beta2DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V1beta2DaemonSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V1beta2DaemonSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1beta2DaemonSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public V1PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public V1PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(V1PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new V1PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public V1beta2DaemonSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public V1beta2DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public V1beta2DaemonSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public V1beta2DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new V1PodTemplateSpecBuilder().build());
    }

    @Override
    public V1beta2DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public V1beta2DaemonSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public V1beta2DaemonSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public A withUpdateStrategy(V1beta2DaemonSetUpdateStrategy updateStrategy) {
        this._visitables.get("updateStrategy").remove(this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new V1beta2DaemonSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get("updateStrategy").add(this.updateStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    @Override
    public V1beta2DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    @Override
    public V1beta2DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(V1beta2DaemonSetUpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    @Override
    public V1beta2DaemonSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy());
    }

    @Override
    public V1beta2DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : new V1beta2DaemonSetUpdateStrategyBuilder().build());
    }

    @Override
    public V1beta2DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(V1beta2DaemonSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DaemonSetSpecFluentImpl that = (V1beta2DaemonSetSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.updateStrategy != null ? !this.updateStrategy.equals(that.updateStrategy) : that.updateStrategy != null);
    }

    public class UpdateStrategyNestedImpl<N>
    extends V1beta2DaemonSetUpdateStrategyFluentImpl<V1beta2DaemonSetSpecFluent.UpdateStrategyNested<N>>
    implements V1beta2DaemonSetSpecFluent.UpdateStrategyNested<N>,
    Nested<N> {
        private final V1beta2DaemonSetUpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(V1beta2DaemonSetUpdateStrategy item) {
            this.builder = new V1beta2DaemonSetUpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new V1beta2DaemonSetUpdateStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta2DaemonSetSpecFluentImpl.this.withUpdateStrategy(this.builder.build());
        }

        @Override
        public N endUpdateStrategy() {
            return this.and();
        }
    }

    public class TemplateNestedImpl<N>
    extends V1PodTemplateSpecFluentImpl<V1beta2DaemonSetSpecFluent.TemplateNested<N>>
    implements V1beta2DaemonSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final V1PodTemplateSpecBuilder builder;

        TemplateNestedImpl(V1PodTemplateSpec item) {
            this.builder = new V1PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new V1PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta2DaemonSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1beta2DaemonSetSpecFluent.SelectorNested<N>>
    implements V1beta2DaemonSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta2DaemonSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

