/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.AppsV1beta1DeploymentStrategy;
import io.kubernetes.client.openapi.models.AppsV1beta1RollbackConfig;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeploymentSpec is the specification of the desired behavior of the Deployment.")
public class AppsV1beta1DeploymentSpec {
    public static final String SERIALIZED_NAME_MIN_READY_SECONDS = "minReadySeconds";
    @SerializedName(value="minReadySeconds")
    private Integer minReadySeconds;
    public static final String SERIALIZED_NAME_PAUSED = "paused";
    @SerializedName(value="paused")
    private Boolean paused;
    public static final String SERIALIZED_NAME_PROGRESS_DEADLINE_SECONDS = "progressDeadlineSeconds";
    @SerializedName(value="progressDeadlineSeconds")
    private Integer progressDeadlineSeconds;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_REVISION_HISTORY_LIMIT = "revisionHistoryLimit";
    @SerializedName(value="revisionHistoryLimit")
    private Integer revisionHistoryLimit;
    public static final String SERIALIZED_NAME_ROLLBACK_TO = "rollbackTo";
    @SerializedName(value="rollbackTo")
    private AppsV1beta1RollbackConfig rollbackTo;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_STRATEGY = "strategy";
    @SerializedName(value="strategy")
    private AppsV1beta1DeploymentStrategy strategy;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private V1PodTemplateSpec template;

    public AppsV1beta1DeploymentSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public AppsV1beta1DeploymentSpec paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that the deployment is paused.")
    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public AppsV1beta1DeploymentSpec progressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.")
    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    public void setProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
    }

    public AppsV1beta1DeploymentSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public AppsV1beta1DeploymentSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 2.")
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public AppsV1beta1DeploymentSpec rollbackTo(AppsV1beta1RollbackConfig rollbackTo) {
        this.rollbackTo = rollbackTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AppsV1beta1RollbackConfig getRollbackTo() {
        return this.rollbackTo;
    }

    public void setRollbackTo(AppsV1beta1RollbackConfig rollbackTo) {
        this.rollbackTo = rollbackTo;
    }

    public AppsV1beta1DeploymentSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public AppsV1beta1DeploymentSpec strategy(AppsV1beta1DeploymentStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AppsV1beta1DeploymentStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(AppsV1beta1DeploymentStrategy strategy) {
        this.strategy = strategy;
    }

    public AppsV1beta1DeploymentSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppsV1beta1DeploymentSpec appsV1beta1DeploymentSpec = (AppsV1beta1DeploymentSpec)o;
        return Objects.equals(this.minReadySeconds, appsV1beta1DeploymentSpec.minReadySeconds) && Objects.equals(this.paused, appsV1beta1DeploymentSpec.paused) && Objects.equals(this.progressDeadlineSeconds, appsV1beta1DeploymentSpec.progressDeadlineSeconds) && Objects.equals(this.replicas, appsV1beta1DeploymentSpec.replicas) && Objects.equals(this.revisionHistoryLimit, appsV1beta1DeploymentSpec.revisionHistoryLimit) && Objects.equals(this.rollbackTo, appsV1beta1DeploymentSpec.rollbackTo) && Objects.equals(this.selector, appsV1beta1DeploymentSpec.selector) && Objects.equals(this.strategy, appsV1beta1DeploymentSpec.strategy) && Objects.equals(this.template, appsV1beta1DeploymentSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.paused, this.progressDeadlineSeconds, this.replicas, this.revisionHistoryLimit, this.rollbackTo, this.selector, this.strategy, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppsV1beta1DeploymentSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    progressDeadlineSeconds: ").append(this.toIndentedString(this.progressDeadlineSeconds)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    revisionHistoryLimit: ").append(this.toIndentedString(this.revisionHistoryLimit)).append("\n");
        sb.append("    rollbackTo: ").append(this.toIndentedString(this.rollbackTo)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    strategy: ").append(this.toIndentedString(this.strategy)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

