/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V2beta2CrossVersionObjectReference;
import io.kubernetes.client.models.V2beta2MetricSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.")
public class V2beta2HorizontalPodAutoscalerSpec {
    @SerializedName(value="maxReplicas")
    private Integer maxReplicas = null;
    @SerializedName(value="metrics")
    private List<V2beta2MetricSpec> metrics = null;
    @SerializedName(value="minReplicas")
    private Integer minReplicas = null;
    @SerializedName(value="scaleTargetRef")
    private V2beta2CrossVersionObjectReference scaleTargetRef = null;

    public V2beta2HorizontalPodAutoscalerSpec maxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.")
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public V2beta2HorizontalPodAutoscalerSpec metrics(List<V2beta2MetricSpec> metrics) {
        this.metrics = metrics;
        return this;
    }

    public V2beta2HorizontalPodAutoscalerSpec addMetricsItem(V2beta2MetricSpec metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<V2beta2MetricSpec>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @ApiModelProperty(value="metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.")
    public List<V2beta2MetricSpec> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<V2beta2MetricSpec> metrics) {
        this.metrics = metrics;
    }

    public V2beta2HorizontalPodAutoscalerSpec minReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    @ApiModelProperty(value="minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod.")
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public V2beta2HorizontalPodAutoscalerSpec scaleTargetRef(V2beta2CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
        return this;
    }

    @ApiModelProperty(required=true, value="scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.")
    public V2beta2CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef;
    }

    public void setScaleTargetRef(V2beta2CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta2HorizontalPodAutoscalerSpec v2beta2HorizontalPodAutoscalerSpec = (V2beta2HorizontalPodAutoscalerSpec)o;
        return Objects.equals(this.maxReplicas, v2beta2HorizontalPodAutoscalerSpec.maxReplicas) && Objects.equals(this.metrics, v2beta2HorizontalPodAutoscalerSpec.metrics) && Objects.equals(this.minReplicas, v2beta2HorizontalPodAutoscalerSpec.minReplicas) && Objects.equals(this.scaleTargetRef, v2beta2HorizontalPodAutoscalerSpec.scaleTargetRef);
    }

    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.metrics, this.minReplicas, this.scaleTargetRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta2HorizontalPodAutoscalerSpec {\n");
        sb.append("    maxReplicas: ").append(this.toIndentedString(this.maxReplicas)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    minReplicas: ").append(this.toIndentedString(this.minReplicas)).append("\n");
        sb.append("    scaleTargetRef: ").append(this.toIndentedString(this.scaleTargetRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

