/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1NodeSelector;
import io.kubernetes.client.models.V1PreferredSchedulingTerm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Node affinity is a group of node affinity scheduling rules.")
public class V1NodeAffinity {
    @SerializedName(value="preferredDuringSchedulingIgnoredDuringExecution")
    private List<V1PreferredSchedulingTerm> preferredDuringSchedulingIgnoredDuringExecution = null;
    @SerializedName(value="requiredDuringSchedulingIgnoredDuringExecution")
    private V1NodeSelector requiredDuringSchedulingIgnoredDuringExecution = null;

    public V1NodeAffinity preferredDuringSchedulingIgnoredDuringExecution(List<V1PreferredSchedulingTerm> preferredDuringSchedulingIgnoredDuringExecution) {
        this.preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution;
        return this;
    }

    public V1NodeAffinity addPreferredDuringSchedulingIgnoredDuringExecutionItem(V1PreferredSchedulingTerm preferredDuringSchedulingIgnoredDuringExecutionItem) {
        if (this.preferredDuringSchedulingIgnoredDuringExecution == null) {
            this.preferredDuringSchedulingIgnoredDuringExecution = new ArrayList<V1PreferredSchedulingTerm>();
        }
        this.preferredDuringSchedulingIgnoredDuringExecution.add(preferredDuringSchedulingIgnoredDuringExecutionItem);
        return this;
    }

    @ApiModelProperty(value="The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.")
    public List<V1PreferredSchedulingTerm> getPreferredDuringSchedulingIgnoredDuringExecution() {
        return this.preferredDuringSchedulingIgnoredDuringExecution;
    }

    public void setPreferredDuringSchedulingIgnoredDuringExecution(List<V1PreferredSchedulingTerm> preferredDuringSchedulingIgnoredDuringExecution) {
        this.preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution;
    }

    public V1NodeAffinity requiredDuringSchedulingIgnoredDuringExecution(V1NodeSelector requiredDuringSchedulingIgnoredDuringExecution) {
        this.requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution;
        return this;
    }

    @ApiModelProperty(value="If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.")
    public V1NodeSelector getRequiredDuringSchedulingIgnoredDuringExecution() {
        return this.requiredDuringSchedulingIgnoredDuringExecution;
    }

    public void setRequiredDuringSchedulingIgnoredDuringExecution(V1NodeSelector requiredDuringSchedulingIgnoredDuringExecution) {
        this.requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeAffinity v1NodeAffinity = (V1NodeAffinity)o;
        return Objects.equals(this.preferredDuringSchedulingIgnoredDuringExecution, v1NodeAffinity.preferredDuringSchedulingIgnoredDuringExecution) && Objects.equals(this.requiredDuringSchedulingIgnoredDuringExecution, v1NodeAffinity.requiredDuringSchedulingIgnoredDuringExecution);
    }

    public int hashCode() {
        return Objects.hash(this.preferredDuringSchedulingIgnoredDuringExecution, this.requiredDuringSchedulingIgnoredDuringExecution);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeAffinity {\n");
        sb.append("    preferredDuringSchedulingIgnoredDuringExecution: ").append(this.toIndentedString(this.preferredDuringSchedulingIgnoredDuringExecution)).append("\n");
        sb.append("    requiredDuringSchedulingIgnoredDuringExecution: ").append(this.toIndentedString(this.requiredDuringSchedulingIgnoredDuringExecution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

