/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).")
public class V2beta1PodsMetricStatus {
    @SerializedName(value="currentAverageValue")
    private String currentAverageValue = null;
    @SerializedName(value="metricName")
    private String metricName = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;

    public V2beta1PodsMetricStatus currentAverageValue(String currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return this;
    }

    @ApiModelProperty(required=true, value="currentAverageValue is the current value of the average of the metric across all relevant pods (as a quantity)")
    public String getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public void setCurrentAverageValue(String currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
    }

    public V2beta1PodsMetricStatus metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(required=true, value="metricName is the name of the metric in question")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public V2beta1PodsMetricStatus selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the PodsMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1PodsMetricStatus v2beta1PodsMetricStatus = (V2beta1PodsMetricStatus)o;
        return Objects.equals(this.currentAverageValue, v2beta1PodsMetricStatus.currentAverageValue) && Objects.equals(this.metricName, v2beta1PodsMetricStatus.metricName) && Objects.equals(this.selector, v2beta1PodsMetricStatus.selector);
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.metricName, this.selector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1PodsMetricStatus {\n");
        sb.append("    currentAverageValue: ").append(this.toIndentedString(this.currentAverageValue)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

