/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.")
public class V2beta1PodsMetricSource {
    @SerializedName(value="metricName")
    private String metricName = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;
    @SerializedName(value="targetAverageValue")
    private String targetAverageValue = null;

    public V2beta1PodsMetricSource metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(required=true, value="metricName is the name of the metric in question")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public V2beta1PodsMetricSource selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V2beta1PodsMetricSource targetAverageValue(String targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return this;
    }

    @ApiModelProperty(required=true, value="targetAverageValue is the target value of the average of the metric across all relevant pods (as a quantity)")
    public String getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public void setTargetAverageValue(String targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1PodsMetricSource v2beta1PodsMetricSource = (V2beta1PodsMetricSource)o;
        return Objects.equals(this.metricName, v2beta1PodsMetricSource.metricName) && Objects.equals(this.selector, v2beta1PodsMetricSource.selector) && Objects.equals(this.targetAverageValue, v2beta1PodsMetricSource.targetAverageValue);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.selector, this.targetAverageValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1PodsMetricSource {\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    targetAverageValue: ").append(this.toIndentedString(this.targetAverageValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

