/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="CustomResourceColumnDefinition specifies a column for server side printing.")
public class V1beta1CustomResourceColumnDefinition {
    @SerializedName(value="JSONPath")
    private String jsONPath = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="format")
    private String format = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="priority")
    private Integer priority = null;
    @SerializedName(value="type")
    private String type = null;

    public V1beta1CustomResourceColumnDefinition jsONPath(String jsONPath) {
        this.jsONPath = jsONPath;
        return this;
    }

    @ApiModelProperty(required=true, value="JSONPath is a simple JSON path, i.e. with array notation.")
    public String getJsONPath() {
        return this.jsONPath;
    }

    public void setJsONPath(String jsONPath) {
        this.jsONPath = jsONPath;
    }

    public V1beta1CustomResourceColumnDefinition description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="description is a human readable description of this column.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public V1beta1CustomResourceColumnDefinition format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(value="format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public V1beta1CustomResourceColumnDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is a human readable name for the column.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1CustomResourceColumnDefinition priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a higher priority.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public V1beta1CustomResourceColumnDefinition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CustomResourceColumnDefinition v1beta1CustomResourceColumnDefinition = (V1beta1CustomResourceColumnDefinition)o;
        return Objects.equals(this.jsONPath, v1beta1CustomResourceColumnDefinition.jsONPath) && Objects.equals(this.description, v1beta1CustomResourceColumnDefinition.description) && Objects.equals(this.format, v1beta1CustomResourceColumnDefinition.format) && Objects.equals(this.name, v1beta1CustomResourceColumnDefinition.name) && Objects.equals(this.priority, v1beta1CustomResourceColumnDefinition.priority) && Objects.equals(this.type, v1beta1CustomResourceColumnDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.jsONPath, this.description, this.format, this.name, this.priority, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CustomResourceColumnDefinition {\n");
        sb.append("    jsONPath: ").append(this.toIndentedString(this.jsONPath)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

