/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1ObjectReference;
import io.kubernetes.client.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.models.V1ObjectReferenceFluentImpl;
import io.kubernetes.client.models.V1StorageOSPersistentVolumeSource;
import io.kubernetes.client.models.V1StorageOSPersistentVolumeSourceFluent;

public class V1StorageOSPersistentVolumeSourceFluentImpl<A extends V1StorageOSPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1StorageOSPersistentVolumeSourceFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private V1ObjectReferenceBuilder secretRef;
    private String volumeName;
    private String volumeNamespace;

    public V1StorageOSPersistentVolumeSourceFluentImpl() {
    }

    public V1StorageOSPersistentVolumeSourceFluentImpl(V1StorageOSPersistentVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.isReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withVolumeName(instance.getVolumeName());
        this.withVolumeNamespace(instance.getVolumeNamespace());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public V1ObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(V1ObjectReference secretRef) {
        this._visitables.remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new V1ObjectReferenceBuilder(secretRef);
            this._visitables.add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1ObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new V1ObjectReferenceBuilder().build());
    }

    @Override
    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1ObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    public String getVolumeNamespace() {
        return this.volumeNamespace;
    }

    @Override
    public A withVolumeNamespace(String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeNamespace() {
        return this.volumeNamespace != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1StorageOSPersistentVolumeSourceFluentImpl that = (V1StorageOSPersistentVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        return !(this.volumeNamespace != null ? !this.volumeNamespace.equals(that.volumeNamespace) : that.volumeNamespace != null);
    }

    public class SecretRefNestedImpl<N>
    extends V1ObjectReferenceFluentImpl<V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final V1ObjectReferenceBuilder builder;

        SecretRefNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StorageOSPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

