/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1RoleBinding;
import io.kubernetes.client.models.V1RoleBindingFluent;
import io.kubernetes.client.models.V1RoleRef;
import io.kubernetes.client.models.V1RoleRefBuilder;
import io.kubernetes.client.models.V1RoleRefFluentImpl;
import io.kubernetes.client.models.V1Subject;
import io.kubernetes.client.models.V1SubjectBuilder;
import io.kubernetes.client.models.V1SubjectFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1RoleBindingFluentImpl<A extends V1RoleBindingFluent<A>>
extends BaseFluent<A>
implements V1RoleBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1RoleRefBuilder roleRef;
    private List<V1SubjectBuilder> subjects;

    public V1RoleBindingFluentImpl() {
    }

    public V1RoleBindingFluentImpl(V1RoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1RoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1RoleBindingFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1RoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1RoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1RoleRef getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public V1RoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(V1RoleRef roleRef) {
        this._visitables.remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new V1RoleRefBuilder(roleRef);
            this._visitables.add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public V1RoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public V1RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(V1RoleRef item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public V1RoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public V1RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new V1RoleRefBuilder().build());
    }

    @Override
    public V1RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(V1RoleRef item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(int index, V1Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1SubjectBuilder>();
        }
        V1SubjectBuilder builder = new V1SubjectBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.subjects.add(index >= 0 ? index : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(int index, V1Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1SubjectBuilder>();
        }
        V1SubjectBuilder builder = new V1SubjectBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(V1Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1SubjectBuilder>();
        }
        for (V1Subject item : items) {
            V1SubjectBuilder builder = new V1SubjectBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<V1Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1SubjectBuilder>();
        }
        for (V1Subject item : items) {
            V1SubjectBuilder builder = new V1SubjectBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(V1Subject ... items) {
        for (V1Subject item : items) {
            V1SubjectBuilder builder = new V1SubjectBuilder(item);
            this._visitables.remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<V1Subject> items) {
        for (V1Subject item : items) {
            V1SubjectBuilder builder = new V1SubjectBuilder(item);
            this._visitables.remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Subject> getSubjects() {
        return V1RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<V1Subject> buildSubjects() {
        return V1RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public V1Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    @Override
    public V1Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public V1Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public V1Subject buildMatchingSubject(Predicate<V1SubjectBuilder> predicate) {
        for (V1SubjectBuilder item : this.subjects) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSubjects(List<V1Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList<V1SubjectBuilder>();
            for (V1Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(V1Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (V1Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public V1RoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public V1RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(V1Subject item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public V1RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index, V1Subject item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public V1RoleBindingFluent.SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public V1RoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public V1RoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public V1RoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<V1SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.apply(this.subjects.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1RoleBindingFluentImpl that = (V1RoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        return !(this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null);
    }

    public class SubjectsNestedImpl<N>
    extends V1SubjectFluentImpl<V1RoleBindingFluent.SubjectsNested<N>>
    implements V1RoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        private final V1SubjectBuilder builder;
        private final int index;

        SubjectsNestedImpl(int index, V1Subject item) {
            this.index = index;
            this.builder = new V1SubjectBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new V1SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1RoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends V1RoleRefFluentImpl<V1RoleBindingFluent.RoleRefNested<N>>
    implements V1RoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        private final V1RoleRefBuilder builder;

        RoleRefNestedImpl(V1RoleRef item) {
            this.builder = new V1RoleRefBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new V1RoleRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1RoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1RoleBindingFluent.MetadataNested<N>>
    implements V1RoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1RoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

