/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1PodDNSConfigOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.")
public class V1PodDNSConfig {
    @SerializedName(value="nameservers")
    private List<String> nameservers = null;
    @SerializedName(value="options")
    private List<V1PodDNSConfigOption> options = null;
    @SerializedName(value="searches")
    private List<String> searches = null;

    public V1PodDNSConfig nameservers(List<String> nameservers) {
        this.nameservers = nameservers;
        return this;
    }

    public V1PodDNSConfig addNameserversItem(String nameserversItem) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(nameserversItem);
        return this;
    }

    @ApiModelProperty(value="A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.")
    public List<String> getNameservers() {
        return this.nameservers;
    }

    public void setNameservers(List<String> nameservers) {
        this.nameservers = nameservers;
    }

    public V1PodDNSConfig options(List<V1PodDNSConfigOption> options) {
        this.options = options;
        return this;
    }

    public V1PodDNSConfig addOptionsItem(V1PodDNSConfigOption optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<V1PodDNSConfigOption>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.")
    public List<V1PodDNSConfigOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<V1PodDNSConfigOption> options) {
        this.options = options;
    }

    public V1PodDNSConfig searches(List<String> searches) {
        this.searches = searches;
        return this;
    }

    public V1PodDNSConfig addSearchesItem(String searchesItem) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(searchesItem);
        return this;
    }

    @ApiModelProperty(value="A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.")
    public List<String> getSearches() {
        return this.searches;
    }

    public void setSearches(List<String> searches) {
        this.searches = searches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodDNSConfig v1PodDNSConfig = (V1PodDNSConfig)o;
        return Objects.equals(this.nameservers, v1PodDNSConfig.nameservers) && Objects.equals(this.options, v1PodDNSConfig.options) && Objects.equals(this.searches, v1PodDNSConfig.searches);
    }

    public int hashCode() {
        return Objects.hash(this.nameservers, this.options, this.searches);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodDNSConfig {\n");
        sb.append("    nameservers: ").append(this.toIndentedString(this.nameservers)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    searches: ").append(this.toIndentedString(this.searches)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

