/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1LabelSelectorBuilder;
import io.kubernetes.client.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.models.V1PodAffinityTerm;
import io.kubernetes.client.models.V1PodAffinityTermFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1PodAffinityTermFluentImpl<A extends V1PodAffinityTermFluent<A>>
extends BaseFluent<A>
implements V1PodAffinityTermFluent<A> {
    private V1LabelSelectorBuilder labelSelector;
    private List<String> namespaces;
    private String topologyKey;

    public V1PodAffinityTermFluentImpl() {
    }

    public V1PodAffinityTermFluentImpl(V1PodAffinityTerm instance) {
        this.withLabelSelector(instance.getLabelSelector());
        this.withNamespaces(instance.getNamespaces());
        this.withTopologyKey(instance.getTopologyKey());
    }

    @Override
    @Deprecated
    public V1LabelSelector getLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public A withLabelSelector(V1LabelSelector labelSelector) {
        this._visitables.remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new V1LabelSelectorBuilder(labelSelector);
            this._visitables.add(this.labelSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public V1PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    @Override
    public V1PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelectorLike(V1LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    @Override
    public V1PodAffinityTermFluent.LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector());
    }

    @Override
    public V1PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(V1LabelSelector item) {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : item);
    }

    @Override
    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) {
            this._visitables.removeAll(this.namespaces);
        }
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public String getTopologyKey() {
        return this.topologyKey;
    }

    @Override
    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodAffinityTermFluentImpl that = (V1PodAffinityTermFluentImpl)o;
        if (this.labelSelector != null ? !this.labelSelector.equals(that.labelSelector) : that.labelSelector != null) {
            return false;
        }
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.topologyKey != null ? !this.topologyKey.equals(that.topologyKey) : that.topologyKey != null);
    }

    public class LabelSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1PodAffinityTermFluent.LabelSelectorNested<N>>
    implements V1PodAffinityTermFluent.LabelSelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        LabelSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        LabelSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodAffinityTermFluentImpl.this.withLabelSelector(this.builder.build());
        }

        @Override
        public N endLabelSelector() {
            return this.and();
        }
    }
}

