/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1HorizontalPodAutoscaler;
import io.kubernetes.client.models.V1HorizontalPodAutoscalerBuilder;
import io.kubernetes.client.models.V1HorizontalPodAutoscalerFluentImpl;
import io.kubernetes.client.models.V1HorizontalPodAutoscalerList;
import io.kubernetes.client.models.V1HorizontalPodAutoscalerListFluent;
import io.kubernetes.client.models.V1ListMeta;
import io.kubernetes.client.models.V1ListMetaBuilder;
import io.kubernetes.client.models.V1ListMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1HorizontalPodAutoscalerListFluentImpl<A extends V1HorizontalPodAutoscalerListFluent<A>>
extends BaseFluent<A>
implements V1HorizontalPodAutoscalerListFluent<A> {
    private String apiVersion;
    private List<V1HorizontalPodAutoscalerBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public V1HorizontalPodAutoscalerListFluentImpl() {
    }

    public V1HorizontalPodAutoscalerListFluentImpl(V1HorizontalPodAutoscalerList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, V1HorizontalPodAutoscaler item) {
        if (this.items == null) {
            this.items = new ArrayList<V1HorizontalPodAutoscalerBuilder>();
        }
        V1HorizontalPodAutoscalerBuilder builder = new V1HorizontalPodAutoscalerBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, V1HorizontalPodAutoscaler item) {
        if (this.items == null) {
            this.items = new ArrayList<V1HorizontalPodAutoscalerBuilder>();
        }
        V1HorizontalPodAutoscalerBuilder builder = new V1HorizontalPodAutoscalerBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(V1HorizontalPodAutoscaler ... items) {
        if (this.items == null) {
            this.items = new ArrayList<V1HorizontalPodAutoscalerBuilder>();
        }
        for (V1HorizontalPodAutoscaler item : items) {
            V1HorizontalPodAutoscalerBuilder builder = new V1HorizontalPodAutoscalerBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<V1HorizontalPodAutoscaler> items) {
        if (this.items == null) {
            this.items = new ArrayList<V1HorizontalPodAutoscalerBuilder>();
        }
        for (V1HorizontalPodAutoscaler item : items) {
            V1HorizontalPodAutoscalerBuilder builder = new V1HorizontalPodAutoscalerBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(V1HorizontalPodAutoscaler ... items) {
        for (V1HorizontalPodAutoscaler item : items) {
            V1HorizontalPodAutoscalerBuilder builder = new V1HorizontalPodAutoscalerBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<V1HorizontalPodAutoscaler> items) {
        for (V1HorizontalPodAutoscaler item : items) {
            V1HorizontalPodAutoscalerBuilder builder = new V1HorizontalPodAutoscalerBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1HorizontalPodAutoscaler> getItems() {
        return V1HorizontalPodAutoscalerListFluentImpl.build(this.items);
    }

    @Override
    public List<V1HorizontalPodAutoscaler> buildItems() {
        return V1HorizontalPodAutoscalerListFluentImpl.build(this.items);
    }

    @Override
    public V1HorizontalPodAutoscaler buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public V1HorizontalPodAutoscaler buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public V1HorizontalPodAutoscaler buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public V1HorizontalPodAutoscaler buildMatchingItem(Predicate<V1HorizontalPodAutoscalerBuilder> predicate) {
        for (V1HorizontalPodAutoscalerBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<V1HorizontalPodAutoscaler> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<V1HorizontalPodAutoscalerBuilder>();
            for (V1HorizontalPodAutoscaler item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(V1HorizontalPodAutoscaler ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (V1HorizontalPodAutoscaler item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItemLike(V1HorizontalPodAutoscaler item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.ItemsNested<A> setNewItemLike(int index, V1HorizontalPodAutoscaler item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.ItemsNested<A> editMatchingItem(Predicate<V1HorizontalPodAutoscalerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ListMetaBuilder().build());
    }

    @Override
    public V1HorizontalPodAutoscalerListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HorizontalPodAutoscalerListFluentImpl that = (V1HorizontalPodAutoscalerListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends V1ListMetaFluentImpl<V1HorizontalPodAutoscalerListFluent.MetadataNested<N>>
    implements V1HorizontalPodAutoscalerListFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ListMetaBuilder builder;

        MetadataNestedImpl(V1ListMeta item) {
            this.builder = new V1ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1HorizontalPodAutoscalerListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends V1HorizontalPodAutoscalerFluentImpl<V1HorizontalPodAutoscalerListFluent.ItemsNested<N>>
    implements V1HorizontalPodAutoscalerListFluent.ItemsNested<N>,
    Nested<N> {
        private final V1HorizontalPodAutoscalerBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, V1HorizontalPodAutoscaler item) {
            this.index = index;
            this.builder = new V1HorizontalPodAutoscalerBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new V1HorizontalPodAutoscalerBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1HorizontalPodAutoscalerListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

