/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.")
public class V1EventSeries {
    @SerializedName(value="count")
    private Integer count = null;
    @SerializedName(value="lastObservedTime")
    private DateTime lastObservedTime = null;
    @SerializedName(value="state")
    private String state = null;

    public V1EventSeries count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(value="Number of occurrences in this series up to the last heartbeat time")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public V1EventSeries lastObservedTime(DateTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
        return this;
    }

    @ApiModelProperty(value="Time of the last occurrence observed")
    public DateTime getLastObservedTime() {
        return this.lastObservedTime;
    }

    public void setLastObservedTime(DateTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
    }

    public V1EventSeries state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="State of this Series: Ongoing or Finished")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EventSeries v1EventSeries = (V1EventSeries)o;
        return Objects.equals(this.count, v1EventSeries.count) && Objects.equals(this.lastObservedTime, v1EventSeries.lastObservedTime) && Objects.equals(this.state, v1EventSeries.state);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.lastObservedTime, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EventSeries {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    lastObservedTime: ").append(this.toIndentedString(this.lastObservedTime)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

