/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.models.V1DeploymentSpec;
import io.kubernetes.client.models.V1DeploymentSpecFluent;
import io.kubernetes.client.models.V1DeploymentSpecFluentImpl;

public class V1DeploymentSpecBuilder
extends V1DeploymentSpecFluentImpl<V1DeploymentSpecBuilder>
implements VisitableBuilder<V1DeploymentSpec, V1DeploymentSpecBuilder> {
    V1DeploymentSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1DeploymentSpecBuilder() {
        this(true);
    }

    public V1DeploymentSpecBuilder(Boolean validationEnabled) {
        this(new V1DeploymentSpec(), validationEnabled);
    }

    public V1DeploymentSpecBuilder(V1DeploymentSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1DeploymentSpecBuilder(V1DeploymentSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1DeploymentSpec(), validationEnabled);
    }

    public V1DeploymentSpecBuilder(V1DeploymentSpecFluent<?> fluent, V1DeploymentSpec instance) {
        this(fluent, instance, true);
    }

    public V1DeploymentSpecBuilder(V1DeploymentSpecFluent<?> fluent, V1DeploymentSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withPaused(instance.isPaused());
        fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public V1DeploymentSpecBuilder(V1DeploymentSpec instance) {
        this(instance, (Boolean)true);
    }

    public V1DeploymentSpecBuilder(V1DeploymentSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.isPaused());
        this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1DeploymentSpec build() {
        V1DeploymentSpec buildable = new V1DeploymentSpec();
        buildable.setMinReadySeconds(this.fluent.getMinReadySeconds());
        buildable.setPaused(this.fluent.isPaused());
        buildable.setProgressDeadlineSeconds(this.fluent.getProgressDeadlineSeconds());
        buildable.setReplicas(this.fluent.getReplicas());
        buildable.setRevisionHistoryLimit(this.fluent.getRevisionHistoryLimit());
        buildable.setSelector(this.fluent.getSelector());
        buildable.setStrategy(this.fluent.getStrategy());
        buildable.setTemplate(this.fluent.getTemplate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DeploymentSpecBuilder that = (V1DeploymentSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

