/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.PolicyV1beta1AllowedFlexVolume;
import io.kubernetes.client.models.PolicyV1beta1AllowedFlexVolumeBuilder;
import io.kubernetes.client.models.PolicyV1beta1AllowedFlexVolumeFluentImpl;
import io.kubernetes.client.models.PolicyV1beta1AllowedHostPath;
import io.kubernetes.client.models.PolicyV1beta1AllowedHostPathBuilder;
import io.kubernetes.client.models.PolicyV1beta1AllowedHostPathFluentImpl;
import io.kubernetes.client.models.PolicyV1beta1FSGroupStrategyOptions;
import io.kubernetes.client.models.PolicyV1beta1FSGroupStrategyOptionsBuilder;
import io.kubernetes.client.models.PolicyV1beta1FSGroupStrategyOptionsFluentImpl;
import io.kubernetes.client.models.PolicyV1beta1HostPortRange;
import io.kubernetes.client.models.PolicyV1beta1HostPortRangeBuilder;
import io.kubernetes.client.models.PolicyV1beta1HostPortRangeFluentImpl;
import io.kubernetes.client.models.PolicyV1beta1PodSecurityPolicySpec;
import io.kubernetes.client.models.PolicyV1beta1PodSecurityPolicySpecFluent;
import io.kubernetes.client.models.PolicyV1beta1RunAsUserStrategyOptions;
import io.kubernetes.client.models.PolicyV1beta1RunAsUserStrategyOptionsBuilder;
import io.kubernetes.client.models.PolicyV1beta1RunAsUserStrategyOptionsFluentImpl;
import io.kubernetes.client.models.PolicyV1beta1SELinuxStrategyOptions;
import io.kubernetes.client.models.PolicyV1beta1SELinuxStrategyOptionsBuilder;
import io.kubernetes.client.models.PolicyV1beta1SELinuxStrategyOptionsFluentImpl;
import io.kubernetes.client.models.PolicyV1beta1SupplementalGroupsStrategyOptions;
import io.kubernetes.client.models.PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder;
import io.kubernetes.client.models.PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolicyV1beta1PodSecurityPolicySpecFluentImpl<A extends PolicyV1beta1PodSecurityPolicySpecFluent<A>>
extends BaseFluent<A>
implements PolicyV1beta1PodSecurityPolicySpecFluent<A> {
    private Boolean allowPrivilegeEscalation;
    private List<String> allowedCapabilities;
    private List<PolicyV1beta1AllowedFlexVolumeBuilder> allowedFlexVolumes;
    private List<PolicyV1beta1AllowedHostPathBuilder> allowedHostPaths;
    private List<String> allowedUnsafeSysctls;
    private List<String> defaultAddCapabilities;
    private Boolean defaultAllowPrivilegeEscalation;
    private List<String> forbiddenSysctls;
    private PolicyV1beta1FSGroupStrategyOptionsBuilder fsGroup;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private List<PolicyV1beta1HostPortRangeBuilder> hostPorts;
    private Boolean privileged;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities;
    private PolicyV1beta1RunAsUserStrategyOptionsBuilder runAsUser;
    private PolicyV1beta1SELinuxStrategyOptionsBuilder seLinux;
    private PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> volumes;

    public PolicyV1beta1PodSecurityPolicySpecFluentImpl() {
    }

    public PolicyV1beta1PodSecurityPolicySpecFluentImpl(PolicyV1beta1PodSecurityPolicySpec instance) {
        this.withAllowPrivilegeEscalation(instance.isAllowPrivilegeEscalation());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        this.withAllowedHostPaths(instance.getAllowedHostPaths());
        this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withDefaultAllowPrivilegeEscalation(instance.isDefaultAllowPrivilegeEscalation());
        this.withForbiddenSysctls(instance.getForbiddenSysctls());
        this.withFsGroup(instance.getFsGroup());
        this.withHostIPC(instance.isHostIPC());
        this.withHostNetwork(instance.isHostNetwork());
        this.withHostPID(instance.isHostPID());
        this.withHostPorts(instance.getHostPorts());
        this.withPrivileged(instance.isPrivileged());
        this.withReadOnlyRootFilesystem(instance.isReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinux(instance.getSeLinux());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Boolean isAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    @Override
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    @Override
    public A withNewAllowPrivilegeEscalation(boolean arg1) {
        return this.withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A withNewAllowPrivilegeEscalation(String arg1) {
        return this.withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A addToAllowedCapabilities(int index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedCapabilities(int index, String item) {
        this.allowedCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedCapabilities(Collection<String> items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            if (this.allowedCapabilities == null) continue;
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.allowedCapabilities == null) continue;
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @Override
    public String getAllowedCapability(int index) {
        return this.allowedCapabilities.get(index);
    }

    @Override
    public String getFirstAllowedCapability() {
        return this.allowedCapabilities.get(0);
    }

    @Override
    public String getLastAllowedCapability() {
        return this.allowedCapabilities.get(this.allowedCapabilities.size() - 1);
    }

    @Override
    public String getMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAllowedCapabilities(List<String> allowedCapabilities) {
        if (this.allowedCapabilities != null) {
            this._visitables.removeAll(this.allowedCapabilities);
        }
        if (allowedCapabilities != null) {
            this.allowedCapabilities = new ArrayList<String>();
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        } else {
            this.allowedCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedCapabilities(String ... allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedCapabilities() {
        return this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty();
    }

    @Override
    public A addToAllowedFlexVolumes(int index, PolicyV1beta1AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<PolicyV1beta1AllowedFlexVolumeBuilder>();
        }
        PolicyV1beta1AllowedFlexVolumeBuilder builder = new PolicyV1beta1AllowedFlexVolumeBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.allowedFlexVolumes.add(index >= 0 ? index : this.allowedFlexVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAllowedFlexVolumes(int index, PolicyV1beta1AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<PolicyV1beta1AllowedFlexVolumeBuilder>();
        }
        PolicyV1beta1AllowedFlexVolumeBuilder builder = new PolicyV1beta1AllowedFlexVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.allowedFlexVolumes.size()) {
            this.allowedFlexVolumes.add(builder);
        } else {
            this.allowedFlexVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAllowedFlexVolumes(PolicyV1beta1AllowedFlexVolume ... items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<PolicyV1beta1AllowedFlexVolumeBuilder>();
        }
        for (PolicyV1beta1AllowedFlexVolume item : items) {
            PolicyV1beta1AllowedFlexVolumeBuilder builder = new PolicyV1beta1AllowedFlexVolumeBuilder(item);
            this._visitables.add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedFlexVolumes(Collection<PolicyV1beta1AllowedFlexVolume> items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<PolicyV1beta1AllowedFlexVolumeBuilder>();
        }
        for (PolicyV1beta1AllowedFlexVolume item : items) {
            PolicyV1beta1AllowedFlexVolumeBuilder builder = new PolicyV1beta1AllowedFlexVolumeBuilder(item);
            this._visitables.add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedFlexVolumes(PolicyV1beta1AllowedFlexVolume ... items) {
        for (PolicyV1beta1AllowedFlexVolume item : items) {
            PolicyV1beta1AllowedFlexVolumeBuilder builder = new PolicyV1beta1AllowedFlexVolumeBuilder(item);
            this._visitables.remove(builder);
            if (this.allowedFlexVolumes == null) continue;
            this.allowedFlexVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedFlexVolumes(Collection<PolicyV1beta1AllowedFlexVolume> items) {
        for (PolicyV1beta1AllowedFlexVolume item : items) {
            PolicyV1beta1AllowedFlexVolumeBuilder builder = new PolicyV1beta1AllowedFlexVolumeBuilder(item);
            this._visitables.remove(builder);
            if (this.allowedFlexVolumes == null) continue;
            this.allowedFlexVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PolicyV1beta1AllowedFlexVolume> getAllowedFlexVolumes() {
        return PolicyV1beta1PodSecurityPolicySpecFluentImpl.build(this.allowedFlexVolumes);
    }

    @Override
    public List<PolicyV1beta1AllowedFlexVolume> buildAllowedFlexVolumes() {
        return PolicyV1beta1PodSecurityPolicySpecFluentImpl.build(this.allowedFlexVolumes);
    }

    @Override
    public PolicyV1beta1AllowedFlexVolume buildAllowedFlexVolume(int index) {
        return this.allowedFlexVolumes.get(index).build();
    }

    @Override
    public PolicyV1beta1AllowedFlexVolume buildFirstAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(0).build();
    }

    @Override
    public PolicyV1beta1AllowedFlexVolume buildLastAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(this.allowedFlexVolumes.size() - 1).build();
    }

    @Override
    public PolicyV1beta1AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<PolicyV1beta1AllowedFlexVolumeBuilder> predicate) {
        for (PolicyV1beta1AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withAllowedFlexVolumes(List<PolicyV1beta1AllowedFlexVolume> allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this._visitables.removeAll(this.allowedFlexVolumes);
        }
        if (allowedFlexVolumes != null) {
            this.allowedFlexVolumes = new ArrayList<PolicyV1beta1AllowedFlexVolumeBuilder>();
            for (PolicyV1beta1AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        } else {
            this.allowedFlexVolumes = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedFlexVolumes(PolicyV1beta1AllowedFlexVolume ... allowedFlexVolumes) {
        this.allowedFlexVolumes.clear();
        if (allowedFlexVolumes != null) {
            for (PolicyV1beta1AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedFlexVolumes() {
        return this.allowedFlexVolumes != null && !this.allowedFlexVolumes.isEmpty();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
        return new AllowedFlexVolumesNestedImpl();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(PolicyV1beta1AllowedFlexVolume item) {
        return new AllowedFlexVolumesNestedImpl(-1, item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index, PolicyV1beta1AllowedFlexVolume item) {
        return new AllowedFlexVolumesNestedImpl(index, item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index) {
        if (this.allowedFlexVolumes.size() <= index) {
            throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
        if (this.allowedFlexVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(0, this.buildAllowedFlexVolume(0));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
        int index = this.allowedFlexVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<PolicyV1beta1AllowedFlexVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedFlexVolumes.size(); ++i) {
            if (!predicate.apply(this.allowedFlexVolumes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public A addToAllowedHostPaths(int index, PolicyV1beta1AllowedHostPath item) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<PolicyV1beta1AllowedHostPathBuilder>();
        }
        PolicyV1beta1AllowedHostPathBuilder builder = new PolicyV1beta1AllowedHostPathBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.allowedHostPaths.add(index >= 0 ? index : this.allowedHostPaths.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAllowedHostPaths(int index, PolicyV1beta1AllowedHostPath item) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<PolicyV1beta1AllowedHostPathBuilder>();
        }
        PolicyV1beta1AllowedHostPathBuilder builder = new PolicyV1beta1AllowedHostPathBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.allowedHostPaths.size()) {
            this.allowedHostPaths.add(builder);
        } else {
            this.allowedHostPaths.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAllowedHostPaths(PolicyV1beta1AllowedHostPath ... items) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<PolicyV1beta1AllowedHostPathBuilder>();
        }
        for (PolicyV1beta1AllowedHostPath item : items) {
            PolicyV1beta1AllowedHostPathBuilder builder = new PolicyV1beta1AllowedHostPathBuilder(item);
            this._visitables.add(builder);
            this.allowedHostPaths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedHostPaths(Collection<PolicyV1beta1AllowedHostPath> items) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<PolicyV1beta1AllowedHostPathBuilder>();
        }
        for (PolicyV1beta1AllowedHostPath item : items) {
            PolicyV1beta1AllowedHostPathBuilder builder = new PolicyV1beta1AllowedHostPathBuilder(item);
            this._visitables.add(builder);
            this.allowedHostPaths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedHostPaths(PolicyV1beta1AllowedHostPath ... items) {
        for (PolicyV1beta1AllowedHostPath item : items) {
            PolicyV1beta1AllowedHostPathBuilder builder = new PolicyV1beta1AllowedHostPathBuilder(item);
            this._visitables.remove(builder);
            if (this.allowedHostPaths == null) continue;
            this.allowedHostPaths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedHostPaths(Collection<PolicyV1beta1AllowedHostPath> items) {
        for (PolicyV1beta1AllowedHostPath item : items) {
            PolicyV1beta1AllowedHostPathBuilder builder = new PolicyV1beta1AllowedHostPathBuilder(item);
            this._visitables.remove(builder);
            if (this.allowedHostPaths == null) continue;
            this.allowedHostPaths.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PolicyV1beta1AllowedHostPath> getAllowedHostPaths() {
        return PolicyV1beta1PodSecurityPolicySpecFluentImpl.build(this.allowedHostPaths);
    }

    @Override
    public List<PolicyV1beta1AllowedHostPath> buildAllowedHostPaths() {
        return PolicyV1beta1PodSecurityPolicySpecFluentImpl.build(this.allowedHostPaths);
    }

    @Override
    public PolicyV1beta1AllowedHostPath buildAllowedHostPath(int index) {
        return this.allowedHostPaths.get(index).build();
    }

    @Override
    public PolicyV1beta1AllowedHostPath buildFirstAllowedHostPath() {
        return this.allowedHostPaths.get(0).build();
    }

    @Override
    public PolicyV1beta1AllowedHostPath buildLastAllowedHostPath() {
        return this.allowedHostPaths.get(this.allowedHostPaths.size() - 1).build();
    }

    @Override
    public PolicyV1beta1AllowedHostPath buildMatchingAllowedHostPath(Predicate<PolicyV1beta1AllowedHostPathBuilder> predicate) {
        for (PolicyV1beta1AllowedHostPathBuilder item : this.allowedHostPaths) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withAllowedHostPaths(List<PolicyV1beta1AllowedHostPath> allowedHostPaths) {
        if (this.allowedHostPaths != null) {
            this._visitables.removeAll(this.allowedHostPaths);
        }
        if (allowedHostPaths != null) {
            this.allowedHostPaths = new ArrayList<PolicyV1beta1AllowedHostPathBuilder>();
            for (PolicyV1beta1AllowedHostPath item : allowedHostPaths) {
                this.addToAllowedHostPaths(item);
            }
        } else {
            this.allowedHostPaths = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedHostPaths(PolicyV1beta1AllowedHostPath ... allowedHostPaths) {
        this.allowedHostPaths.clear();
        if (allowedHostPaths != null) {
            for (PolicyV1beta1AllowedHostPath item : allowedHostPaths) {
                this.addToAllowedHostPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedHostPaths() {
        return this.allowedHostPaths != null && !this.allowedHostPaths.isEmpty();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPath() {
        return new AllowedHostPathsNestedImpl();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPathLike(PolicyV1beta1AllowedHostPath item) {
        return new AllowedHostPathsNestedImpl(-1, item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> setNewAllowedHostPathLike(int index, PolicyV1beta1AllowedHostPath item) {
        return new AllowedHostPathsNestedImpl(index, item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editAllowedHostPath(int index) {
        if (this.allowedHostPaths.size() <= index) {
            throw new RuntimeException("Can't edit allowedHostPaths. Index exceeds size.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editFirstAllowedHostPath() {
        if (this.allowedHostPaths.size() == 0) {
            throw new RuntimeException("Can't edit first allowedHostPaths. The list is empty.");
        }
        return this.setNewAllowedHostPathLike(0, this.buildAllowedHostPath(0));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editLastAllowedHostPath() {
        int index = this.allowedHostPaths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedHostPaths. The list is empty.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editMatchingAllowedHostPath(Predicate<PolicyV1beta1AllowedHostPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedHostPaths.size(); ++i) {
            if (!predicate.apply(this.allowedHostPaths.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedHostPaths. No match found.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    @Override
    public A addToAllowedUnsafeSysctls(int index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedUnsafeSysctls(int index, String item) {
        this.allowedUnsafeSysctls.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedUnsafeSysctls(String ... items) {
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedUnsafeSysctls(Collection<String> items) {
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedUnsafeSysctls(String ... items) {
        for (String item : items) {
            if (this.allowedUnsafeSysctls == null) continue;
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items) {
        for (String item : items) {
            if (this.allowedUnsafeSysctls == null) continue;
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls;
    }

    @Override
    public String getAllowedUnsafeSysctl(int index) {
        return this.allowedUnsafeSysctls.get(index);
    }

    @Override
    public String getFirstAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(0);
    }

    @Override
    public String getLastAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(this.allowedUnsafeSysctls.size() - 1);
    }

    @Override
    public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
        if (this.allowedUnsafeSysctls != null) {
            this._visitables.removeAll(this.allowedUnsafeSysctls);
        }
        if (allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        } else {
            this.allowedUnsafeSysctls = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedUnsafeSysctls(String ... allowedUnsafeSysctls) {
        this.allowedUnsafeSysctls.clear();
        if (allowedUnsafeSysctls != null) {
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls != null && !this.allowedUnsafeSysctls.isEmpty();
    }

    @Override
    public A addToDefaultAddCapabilities(int index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDefaultAddCapabilities(int index, String item) {
        this.defaultAddCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDefaultAddCapabilities(Collection<String> items) {
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            if (this.defaultAddCapabilities == null) continue;
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.defaultAddCapabilities == null) continue;
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    @Override
    public String getDefaultAddCapability(int index) {
        return this.defaultAddCapabilities.get(index);
    }

    @Override
    public String getFirstDefaultAddCapability() {
        return this.defaultAddCapabilities.get(0);
    }

    @Override
    public String getLastDefaultAddCapability() {
        return this.defaultAddCapabilities.get(this.defaultAddCapabilities.size() - 1);
    }

    @Override
    public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        if (this.defaultAddCapabilities != null) {
            this._visitables.removeAll(this.defaultAddCapabilities);
        }
        if (defaultAddCapabilities != null) {
            this.defaultAddCapabilities = new ArrayList<String>();
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        } else {
            this.defaultAddCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultAddCapabilities() {
        return this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty();
    }

    @Override
    public Boolean isDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation;
    }

    @Override
    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
        this.defaultAllowPrivilegeEscalation = defaultAllowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation != null;
    }

    @Override
    public A withNewDefaultAllowPrivilegeEscalation(boolean arg1) {
        return this.withDefaultAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A withNewDefaultAllowPrivilegeEscalation(String arg1) {
        return this.withDefaultAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A addToForbiddenSysctls(int index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.add(index, item);
        return (A)this;
    }

    @Override
    public A setToForbiddenSysctls(int index, String item) {
        this.forbiddenSysctls.set(index, item);
        return (A)this;
    }

    @Override
    public A addToForbiddenSysctls(String ... items) {
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToForbiddenSysctls(Collection<String> items) {
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromForbiddenSysctls(String ... items) {
        for (String item : items) {
            if (this.forbiddenSysctls == null) continue;
            this.forbiddenSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromForbiddenSysctls(Collection<String> items) {
        for (String item : items) {
            if (this.forbiddenSysctls == null) continue;
            this.forbiddenSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getForbiddenSysctls() {
        return this.forbiddenSysctls;
    }

    @Override
    public String getForbiddenSysctl(int index) {
        return this.forbiddenSysctls.get(index);
    }

    @Override
    public String getFirstForbiddenSysctl() {
        return this.forbiddenSysctls.get(0);
    }

    @Override
    public String getLastForbiddenSysctl() {
        return this.forbiddenSysctls.get(this.forbiddenSysctls.size() - 1);
    }

    @Override
    public String getMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withForbiddenSysctls(List<String> forbiddenSysctls) {
        if (this.forbiddenSysctls != null) {
            this._visitables.removeAll(this.forbiddenSysctls);
        }
        if (forbiddenSysctls != null) {
            this.forbiddenSysctls = new ArrayList<String>();
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        } else {
            this.forbiddenSysctls = null;
        }
        return (A)this;
    }

    @Override
    public A withForbiddenSysctls(String ... forbiddenSysctls) {
        this.forbiddenSysctls.clear();
        if (forbiddenSysctls != null) {
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasForbiddenSysctls() {
        return this.forbiddenSysctls != null && !this.forbiddenSysctls.isEmpty();
    }

    @Override
    @Deprecated
    public PolicyV1beta1FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public PolicyV1beta1FSGroupStrategyOptions buildFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public A withFsGroup(PolicyV1beta1FSGroupStrategyOptions fsGroup) {
        this._visitables.remove(this.fsGroup);
        if (fsGroup != null) {
            this.fsGroup = new PolicyV1beta1FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.add(this.fsGroup);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup() {
        return new FsGroupNestedImpl();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(PolicyV1beta1FSGroupStrategyOptions item) {
        return new FsGroupNestedImpl(item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup());
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : new PolicyV1beta1FSGroupStrategyOptionsBuilder().build());
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(PolicyV1beta1FSGroupStrategyOptions item) {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : item);
    }

    @Override
    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    @Override
    public A withNewHostIPC(boolean arg1) {
        return this.withHostIPC(new Boolean(arg1));
    }

    @Override
    public A withNewHostIPC(String arg1) {
        return this.withHostIPC(new Boolean(arg1));
    }

    @Override
    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public A withNewHostNetwork(boolean arg1) {
        return this.withHostNetwork(new Boolean(arg1));
    }

    @Override
    public A withNewHostNetwork(String arg1) {
        return this.withHostNetwork(new Boolean(arg1));
    }

    @Override
    public Boolean isHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    @Override
    public A withNewHostPID(boolean arg1) {
        return this.withHostPID(new Boolean(arg1));
    }

    @Override
    public A withNewHostPID(String arg1) {
        return this.withHostPID(new Boolean(arg1));
    }

    @Override
    public A addToHostPorts(int index, PolicyV1beta1HostPortRange item) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<PolicyV1beta1HostPortRangeBuilder>();
        }
        PolicyV1beta1HostPortRangeBuilder builder = new PolicyV1beta1HostPortRangeBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.hostPorts.add(index >= 0 ? index : this.hostPorts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHostPorts(int index, PolicyV1beta1HostPortRange item) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<PolicyV1beta1HostPortRangeBuilder>();
        }
        PolicyV1beta1HostPortRangeBuilder builder = new PolicyV1beta1HostPortRangeBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.hostPorts.size()) {
            this.hostPorts.add(builder);
        } else {
            this.hostPorts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHostPorts(PolicyV1beta1HostPortRange ... items) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<PolicyV1beta1HostPortRangeBuilder>();
        }
        for (PolicyV1beta1HostPortRange item : items) {
            PolicyV1beta1HostPortRangeBuilder builder = new PolicyV1beta1HostPortRangeBuilder(item);
            this._visitables.add(builder);
            this.hostPorts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostPorts(Collection<PolicyV1beta1HostPortRange> items) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<PolicyV1beta1HostPortRangeBuilder>();
        }
        for (PolicyV1beta1HostPortRange item : items) {
            PolicyV1beta1HostPortRangeBuilder builder = new PolicyV1beta1HostPortRangeBuilder(item);
            this._visitables.add(builder);
            this.hostPorts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostPorts(PolicyV1beta1HostPortRange ... items) {
        for (PolicyV1beta1HostPortRange item : items) {
            PolicyV1beta1HostPortRangeBuilder builder = new PolicyV1beta1HostPortRangeBuilder(item);
            this._visitables.remove(builder);
            if (this.hostPorts == null) continue;
            this.hostPorts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostPorts(Collection<PolicyV1beta1HostPortRange> items) {
        for (PolicyV1beta1HostPortRange item : items) {
            PolicyV1beta1HostPortRangeBuilder builder = new PolicyV1beta1HostPortRangeBuilder(item);
            this._visitables.remove(builder);
            if (this.hostPorts == null) continue;
            this.hostPorts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PolicyV1beta1HostPortRange> getHostPorts() {
        return PolicyV1beta1PodSecurityPolicySpecFluentImpl.build(this.hostPorts);
    }

    @Override
    public List<PolicyV1beta1HostPortRange> buildHostPorts() {
        return PolicyV1beta1PodSecurityPolicySpecFluentImpl.build(this.hostPorts);
    }

    @Override
    public PolicyV1beta1HostPortRange buildHostPort(int index) {
        return this.hostPorts.get(index).build();
    }

    @Override
    public PolicyV1beta1HostPortRange buildFirstHostPort() {
        return this.hostPorts.get(0).build();
    }

    @Override
    public PolicyV1beta1HostPortRange buildLastHostPort() {
        return this.hostPorts.get(this.hostPorts.size() - 1).build();
    }

    @Override
    public PolicyV1beta1HostPortRange buildMatchingHostPort(Predicate<PolicyV1beta1HostPortRangeBuilder> predicate) {
        for (PolicyV1beta1HostPortRangeBuilder item : this.hostPorts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withHostPorts(List<PolicyV1beta1HostPortRange> hostPorts) {
        if (this.hostPorts != null) {
            this._visitables.removeAll(this.hostPorts);
        }
        if (hostPorts != null) {
            this.hostPorts = new ArrayList<PolicyV1beta1HostPortRangeBuilder>();
            for (PolicyV1beta1HostPortRange item : hostPorts) {
                this.addToHostPorts(item);
            }
        } else {
            this.hostPorts = null;
        }
        return (A)this;
    }

    @Override
    public A withHostPorts(PolicyV1beta1HostPortRange ... hostPorts) {
        this.hostPorts.clear();
        if (hostPorts != null) {
            for (PolicyV1beta1HostPortRange item : hostPorts) {
                this.addToHostPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostPorts() {
        return this.hostPorts != null && !this.hostPorts.isEmpty();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort() {
        return new HostPortsNestedImpl();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(PolicyV1beta1HostPortRange item) {
        return new HostPortsNestedImpl(-1, item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index, PolicyV1beta1HostPortRange item) {
        return new HostPortsNestedImpl(index, item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index) {
        if (this.hostPorts.size() <= index) {
            throw new RuntimeException("Can't edit hostPorts. Index exceeds size.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort() {
        if (this.hostPorts.size() == 0) {
            throw new RuntimeException("Can't edit first hostPorts. The list is empty.");
        }
        return this.setNewHostPortLike(0, this.buildHostPort(0));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort() {
        int index = this.hostPorts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostPorts. The list is empty.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(Predicate<PolicyV1beta1HostPortRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostPorts.size(); ++i) {
            if (!predicate.apply(this.hostPorts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostPorts. No match found.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public Boolean isPrivileged() {
        return this.privileged;
    }

    @Override
    public A withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (A)this;
    }

    @Override
    public Boolean hasPrivileged() {
        return this.privileged != null;
    }

    @Override
    public A withNewPrivileged(boolean arg1) {
        return this.withPrivileged(new Boolean(arg1));
    }

    @Override
    public A withNewPrivileged(String arg1) {
        return this.withPrivileged(new Boolean(arg1));
    }

    @Override
    public Boolean isReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    @Override
    public A withNewReadOnlyRootFilesystem(boolean arg1) {
        return this.withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnlyRootFilesystem(String arg1) {
        return this.withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    @Override
    public A addToRequiredDropCapabilities(int index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRequiredDropCapabilities(int index, String item) {
        this.requiredDropCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequiredDropCapabilities(Collection<String> items) {
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            if (this.requiredDropCapabilities == null) continue;
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.requiredDropCapabilities == null) continue;
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    @Override
    public String getRequiredDropCapability(int index) {
        return this.requiredDropCapabilities.get(index);
    }

    @Override
    public String getFirstRequiredDropCapability() {
        return this.requiredDropCapabilities.get(0);
    }

    @Override
    public String getLastRequiredDropCapability() {
        return this.requiredDropCapabilities.get(this.requiredDropCapabilities.size() - 1);
    }

    @Override
    public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        if (this.requiredDropCapabilities != null) {
            this._visitables.removeAll(this.requiredDropCapabilities);
        }
        if (requiredDropCapabilities != null) {
            this.requiredDropCapabilities = new ArrayList<String>();
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        } else {
            this.requiredDropCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequiredDropCapabilities() {
        return this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty();
    }

    @Override
    @Deprecated
    public PolicyV1beta1RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public PolicyV1beta1RunAsUserStrategyOptions buildRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public A withRunAsUser(PolicyV1beta1RunAsUserStrategyOptions runAsUser) {
        this._visitables.remove(this.runAsUser);
        if (runAsUser != null) {
            this.runAsUser = new PolicyV1beta1RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.add(this.runAsUser);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser() {
        return new RunAsUserNestedImpl();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(PolicyV1beta1RunAsUserStrategyOptions item) {
        return new RunAsUserNestedImpl(item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : new PolicyV1beta1RunAsUserStrategyOptionsBuilder().build());
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(PolicyV1beta1RunAsUserStrategyOptions item) {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : item);
    }

    @Override
    @Deprecated
    public PolicyV1beta1SELinuxStrategyOptions getSeLinux() {
        return this.seLinux != null ? this.seLinux.build() : null;
    }

    @Override
    public PolicyV1beta1SELinuxStrategyOptions buildSeLinux() {
        return this.seLinux != null ? this.seLinux.build() : null;
    }

    @Override
    public A withSeLinux(PolicyV1beta1SELinuxStrategyOptions seLinux) {
        this._visitables.remove(this.seLinux);
        if (seLinux != null) {
            this.seLinux = new PolicyV1beta1SELinuxStrategyOptionsBuilder(seLinux);
            this._visitables.add(this.seLinux);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinux() {
        return this.seLinux != null;
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux() {
        return new SeLinuxNestedImpl();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(PolicyV1beta1SELinuxStrategyOptions item) {
        return new SeLinuxNestedImpl(item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux() {
        return this.withNewSeLinuxLike(this.getSeLinux());
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux() {
        return this.withNewSeLinuxLike(this.getSeLinux() != null ? this.getSeLinux() : new PolicyV1beta1SELinuxStrategyOptionsBuilder().build());
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(PolicyV1beta1SELinuxStrategyOptions item) {
        return this.withNewSeLinuxLike(this.getSeLinux() != null ? this.getSeLinux() : item);
    }

    @Override
    @Deprecated
    public PolicyV1beta1SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public PolicyV1beta1SupplementalGroupsStrategyOptions buildSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public A withSupplementalGroups(PolicyV1beta1SupplementalGroupsStrategyOptions supplementalGroups) {
        this._visitables.remove(this.supplementalGroups);
        if (supplementalGroups != null) {
            this.supplementalGroups = new PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.add(this.supplementalGroups);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null;
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new SupplementalGroupsNestedImpl();
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(PolicyV1beta1SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNestedImpl(item);
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups());
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : new PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder().build());
    }

    @Override
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(PolicyV1beta1SupplementalGroupsStrategyOptions item) {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : item);
    }

    @Override
    public A addToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, String item) {
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(String ... items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<String> items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(String ... items) {
        for (String item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<String> items) {
        for (String item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Override
    public String getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withVolumes(List<String> volumes) {
        if (this.volumes != null) {
            this._visitables.removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<String>();
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(String ... volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyV1beta1PodSecurityPolicySpecFluentImpl that = (PolicyV1beta1PodSecurityPolicySpecFluentImpl)o;
        if (this.allowPrivilegeEscalation != null ? !this.allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) : that.allowPrivilegeEscalation != null) {
            return false;
        }
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.allowedFlexVolumes != null ? !this.allowedFlexVolumes.equals(that.allowedFlexVolumes) : that.allowedFlexVolumes != null) {
            return false;
        }
        if (this.allowedHostPaths != null ? !this.allowedHostPaths.equals(that.allowedHostPaths) : that.allowedHostPaths != null) {
            return false;
        }
        if (this.allowedUnsafeSysctls != null ? !this.allowedUnsafeSysctls.equals(that.allowedUnsafeSysctls) : that.allowedUnsafeSysctls != null) {
            return false;
        }
        if (this.defaultAddCapabilities != null ? !this.defaultAddCapabilities.equals(that.defaultAddCapabilities) : that.defaultAddCapabilities != null) {
            return false;
        }
        if (this.defaultAllowPrivilegeEscalation != null ? !this.defaultAllowPrivilegeEscalation.equals(that.defaultAllowPrivilegeEscalation) : that.defaultAllowPrivilegeEscalation != null) {
            return false;
        }
        if (this.forbiddenSysctls != null ? !this.forbiddenSysctls.equals(that.forbiddenSysctls) : that.forbiddenSysctls != null) {
            return false;
        }
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostPorts != null ? !this.hostPorts.equals(that.hostPorts) : that.hostPorts != null) {
            return false;
        }
        if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) {
            return false;
        }
        if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) {
            return false;
        }
        if (this.requiredDropCapabilities != null ? !this.requiredDropCapabilities.equals(that.requiredDropCapabilities) : that.requiredDropCapabilities != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinux != null ? !this.seLinux.equals(that.seLinux) : that.seLinux != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class SupplementalGroupsNestedImpl<N>
    extends PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl<PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>>
    implements PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>,
    Nested<N> {
        private final PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNestedImpl(PolicyV1beta1SupplementalGroupsStrategyOptions item) {
            this.builder = new PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        SupplementalGroupsNestedImpl() {
            this.builder = new PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyV1beta1PodSecurityPolicySpecFluentImpl.this.withSupplementalGroups(this.builder.build());
        }

        @Override
        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxNestedImpl<N>
    extends PolicyV1beta1SELinuxStrategyOptionsFluentImpl<PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<N>>
    implements PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<N>,
    Nested<N> {
        private final PolicyV1beta1SELinuxStrategyOptionsBuilder builder;

        SeLinuxNestedImpl(PolicyV1beta1SELinuxStrategyOptions item) {
            this.builder = new PolicyV1beta1SELinuxStrategyOptionsBuilder(this, item);
        }

        SeLinuxNestedImpl() {
            this.builder = new PolicyV1beta1SELinuxStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyV1beta1PodSecurityPolicySpecFluentImpl.this.withSeLinux(this.builder.build());
        }

        @Override
        public N endSeLinux() {
            return this.and();
        }
    }

    public class RunAsUserNestedImpl<N>
    extends PolicyV1beta1RunAsUserStrategyOptionsFluentImpl<PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<N>>
    implements PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<N>,
    Nested<N> {
        private final PolicyV1beta1RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNestedImpl(PolicyV1beta1RunAsUserStrategyOptions item) {
            this.builder = new PolicyV1beta1RunAsUserStrategyOptionsBuilder(this, item);
        }

        RunAsUserNestedImpl() {
            this.builder = new PolicyV1beta1RunAsUserStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyV1beta1PodSecurityPolicySpecFluentImpl.this.withRunAsUser(this.builder.build());
        }

        @Override
        public N endRunAsUser() {
            return this.and();
        }
    }

    public class HostPortsNestedImpl<N>
    extends PolicyV1beta1HostPortRangeFluentImpl<PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<N>>
    implements PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<N>,
    Nested<N> {
        private final PolicyV1beta1HostPortRangeBuilder builder;
        private final int index;

        HostPortsNestedImpl(int index, PolicyV1beta1HostPortRange item) {
            this.index = index;
            this.builder = new PolicyV1beta1HostPortRangeBuilder(this, item);
        }

        HostPortsNestedImpl() {
            this.index = -1;
            this.builder = new PolicyV1beta1HostPortRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyV1beta1PodSecurityPolicySpecFluentImpl.this.setToHostPorts(this.index, this.builder.build());
        }

        @Override
        public N endHostPort() {
            return this.and();
        }
    }

    public class FsGroupNestedImpl<N>
    extends PolicyV1beta1FSGroupStrategyOptionsFluentImpl<PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<N>>
    implements PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<N>,
    Nested<N> {
        private final PolicyV1beta1FSGroupStrategyOptionsBuilder builder;

        FsGroupNestedImpl(PolicyV1beta1FSGroupStrategyOptions item) {
            this.builder = new PolicyV1beta1FSGroupStrategyOptionsBuilder(this, item);
        }

        FsGroupNestedImpl() {
            this.builder = new PolicyV1beta1FSGroupStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyV1beta1PodSecurityPolicySpecFluentImpl.this.withFsGroup(this.builder.build());
        }

        @Override
        public N endFsGroup() {
            return this.and();
        }
    }

    public class AllowedHostPathsNestedImpl<N>
    extends PolicyV1beta1AllowedHostPathFluentImpl<PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>>
    implements PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>,
    Nested<N> {
        private final PolicyV1beta1AllowedHostPathBuilder builder;
        private final int index;

        AllowedHostPathsNestedImpl(int index, PolicyV1beta1AllowedHostPath item) {
            this.index = index;
            this.builder = new PolicyV1beta1AllowedHostPathBuilder(this, item);
        }

        AllowedHostPathsNestedImpl() {
            this.index = -1;
            this.builder = new PolicyV1beta1AllowedHostPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyV1beta1PodSecurityPolicySpecFluentImpl.this.setToAllowedHostPaths(this.index, this.builder.build());
        }

        @Override
        public N endAllowedHostPath() {
            return this.and();
        }
    }

    public class AllowedFlexVolumesNestedImpl<N>
    extends PolicyV1beta1AllowedFlexVolumeFluentImpl<PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>>
    implements PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>,
    Nested<N> {
        private final PolicyV1beta1AllowedFlexVolumeBuilder builder;
        private final int index;

        AllowedFlexVolumesNestedImpl(int index, PolicyV1beta1AllowedFlexVolume item) {
            this.index = index;
            this.builder = new PolicyV1beta1AllowedFlexVolumeBuilder(this, item);
        }

        AllowedFlexVolumesNestedImpl() {
            this.index = -1;
            this.builder = new PolicyV1beta1AllowedFlexVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyV1beta1PodSecurityPolicySpecFluentImpl.this.setToAllowedFlexVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAllowedFlexVolume() {
            return this.and();
        }
    }
}

