/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1Scale;
import io.kubernetes.client.models.V1ScaleFluent;
import io.kubernetes.client.models.V1ScaleSpec;
import io.kubernetes.client.models.V1ScaleSpecBuilder;
import io.kubernetes.client.models.V1ScaleSpecFluentImpl;
import io.kubernetes.client.models.V1ScaleStatus;
import io.kubernetes.client.models.V1ScaleStatusBuilder;
import io.kubernetes.client.models.V1ScaleStatusFluentImpl;

public class V1ScaleFluentImpl<A extends V1ScaleFluent<A>>
extends BaseFluent<A>
implements V1ScaleFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1ScaleSpecBuilder spec;
    private V1ScaleStatusBuilder status;

    public V1ScaleFluentImpl() {
    }

    public V1ScaleFluentImpl(V1Scale instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1ScaleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1ScaleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1ScaleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1ScaleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1ScaleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1ScaleSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1ScaleSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1ScaleSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new V1ScaleSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V1ScaleFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V1ScaleFluent.SpecNested<A> withNewSpecLike(V1ScaleSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V1ScaleFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V1ScaleFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1ScaleSpecBuilder().build());
    }

    @Override
    public V1ScaleFluent.SpecNested<A> editOrNewSpecLike(V1ScaleSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1ScaleStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1ScaleStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1ScaleStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new V1ScaleStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1ScaleFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1ScaleFluent.StatusNested<A> withNewStatusLike(V1ScaleStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1ScaleFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1ScaleFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1ScaleStatusBuilder().build());
    }

    @Override
    public V1ScaleFluent.StatusNested<A> editOrNewStatusLike(V1ScaleStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ScaleFluentImpl that = (V1ScaleFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends V1ScaleStatusFluentImpl<V1ScaleFluent.StatusNested<N>>
    implements V1ScaleFluent.StatusNested<N>,
    Nested<N> {
        private final V1ScaleStatusBuilder builder;

        StatusNestedImpl(V1ScaleStatus item) {
            this.builder = new V1ScaleStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1ScaleStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ScaleFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends V1ScaleSpecFluentImpl<V1ScaleFluent.SpecNested<N>>
    implements V1ScaleFluent.SpecNested<N>,
    Nested<N> {
        private final V1ScaleSpecBuilder builder;

        SpecNestedImpl(V1ScaleSpec item) {
            this.builder = new V1ScaleSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1ScaleSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ScaleFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1ScaleFluent.MetadataNested<N>>
    implements V1ScaleFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ScaleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

