/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.ExtensionsV1beta1IDRange;
import io.kubernetes.client.models.ExtensionsV1beta1IDRangeBuilder;
import io.kubernetes.client.models.ExtensionsV1beta1IDRangeFluentImpl;
import io.kubernetes.client.models.ExtensionsV1beta1RunAsUserStrategyOptions;
import io.kubernetes.client.models.ExtensionsV1beta1RunAsUserStrategyOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl<A extends ExtensionsV1beta1RunAsUserStrategyOptionsFluent<A>>
extends BaseFluent<A>
implements ExtensionsV1beta1RunAsUserStrategyOptionsFluent<A> {
    private List<ExtensionsV1beta1IDRangeBuilder> ranges;
    private String rule;

    public ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl() {
    }

    public ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl(ExtensionsV1beta1RunAsUserStrategyOptions instance) {
        this.withRanges(instance.getRanges());
        this.withRule(instance.getRule());
    }

    @Override
    public A addToRanges(int index, ExtensionsV1beta1IDRange item) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<ExtensionsV1beta1IDRangeBuilder>();
        }
        ExtensionsV1beta1IDRangeBuilder builder = new ExtensionsV1beta1IDRangeBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ranges.add(index >= 0 ? index : this.ranges.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRanges(int index, ExtensionsV1beta1IDRange item) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<ExtensionsV1beta1IDRangeBuilder>();
        }
        ExtensionsV1beta1IDRangeBuilder builder = new ExtensionsV1beta1IDRangeBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ranges.size()) {
            this.ranges.add(builder);
        } else {
            this.ranges.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRanges(ExtensionsV1beta1IDRange ... items) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<ExtensionsV1beta1IDRangeBuilder>();
        }
        for (ExtensionsV1beta1IDRange item : items) {
            ExtensionsV1beta1IDRangeBuilder builder = new ExtensionsV1beta1IDRangeBuilder(item);
            this._visitables.add(builder);
            this.ranges.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRanges(Collection<ExtensionsV1beta1IDRange> items) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<ExtensionsV1beta1IDRangeBuilder>();
        }
        for (ExtensionsV1beta1IDRange item : items) {
            ExtensionsV1beta1IDRangeBuilder builder = new ExtensionsV1beta1IDRangeBuilder(item);
            this._visitables.add(builder);
            this.ranges.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRanges(ExtensionsV1beta1IDRange ... items) {
        for (ExtensionsV1beta1IDRange item : items) {
            ExtensionsV1beta1IDRangeBuilder builder = new ExtensionsV1beta1IDRangeBuilder(item);
            this._visitables.remove(builder);
            if (this.ranges == null) continue;
            this.ranges.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRanges(Collection<ExtensionsV1beta1IDRange> items) {
        for (ExtensionsV1beta1IDRange item : items) {
            ExtensionsV1beta1IDRangeBuilder builder = new ExtensionsV1beta1IDRangeBuilder(item);
            this._visitables.remove(builder);
            if (this.ranges == null) continue;
            this.ranges.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ExtensionsV1beta1IDRange> getRanges() {
        return ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl.build(this.ranges);
    }

    @Override
    public List<ExtensionsV1beta1IDRange> buildRanges() {
        return ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl.build(this.ranges);
    }

    @Override
    public ExtensionsV1beta1IDRange buildRange(int index) {
        return this.ranges.get(index).build();
    }

    @Override
    public ExtensionsV1beta1IDRange buildFirstRange() {
        return this.ranges.get(0).build();
    }

    @Override
    public ExtensionsV1beta1IDRange buildLastRange() {
        return this.ranges.get(this.ranges.size() - 1).build();
    }

    @Override
    public ExtensionsV1beta1IDRange buildMatchingRange(Predicate<ExtensionsV1beta1IDRangeBuilder> predicate) {
        for (ExtensionsV1beta1IDRangeBuilder item : this.ranges) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRanges(List<ExtensionsV1beta1IDRange> ranges) {
        if (this.ranges != null) {
            this._visitables.removeAll(this.ranges);
        }
        if (ranges != null) {
            this.ranges = new ArrayList<ExtensionsV1beta1IDRangeBuilder>();
            for (ExtensionsV1beta1IDRange item : ranges) {
                this.addToRanges(item);
            }
        } else {
            this.ranges = null;
        }
        return (A)this;
    }

    @Override
    public A withRanges(ExtensionsV1beta1IDRange ... ranges) {
        this.ranges.clear();
        if (ranges != null) {
            for (ExtensionsV1beta1IDRange item : ranges) {
                this.addToRanges(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRanges() {
        return this.ranges != null && !this.ranges.isEmpty();
    }

    @Override
    public ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<A> addNewRange() {
        return new RangesNestedImpl();
    }

    @Override
    public ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<A> addNewRangeLike(ExtensionsV1beta1IDRange item) {
        return new RangesNestedImpl(-1, item);
    }

    @Override
    public ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<A> setNewRangeLike(int index, ExtensionsV1beta1IDRange item) {
        return new RangesNestedImpl(index, item);
    }

    @Override
    public ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<A> editRange(int index) {
        if (this.ranges.size() <= index) {
            throw new RuntimeException("Can't edit ranges. Index exceeds size.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<A> editFirstRange() {
        if (this.ranges.size() == 0) {
            throw new RuntimeException("Can't edit first ranges. The list is empty.");
        }
        return this.setNewRangeLike(0, this.buildRange(0));
    }

    @Override
    public ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<A> editLastRange() {
        int index = this.ranges.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ranges. The list is empty.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<A> editMatchingRange(Predicate<ExtensionsV1beta1IDRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (!predicate.apply(this.ranges.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ranges. No match found.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    @Override
    public A withRule(String rule) {
        this.rule = rule;
        return (A)this;
    }

    @Override
    public Boolean hasRule() {
        return this.rule != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl that = (ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl)o;
        if (this.ranges != null ? !this.ranges.equals(that.ranges) : that.ranges != null) {
            return false;
        }
        return !(this.rule != null ? !this.rule.equals(that.rule) : that.rule != null);
    }

    public class RangesNestedImpl<N>
    extends ExtensionsV1beta1IDRangeFluentImpl<ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<N>>
    implements ExtensionsV1beta1RunAsUserStrategyOptionsFluent.RangesNested<N>,
    Nested<N> {
        private final ExtensionsV1beta1IDRangeBuilder builder;
        private final int index;

        RangesNestedImpl(int index, ExtensionsV1beta1IDRange item) {
            this.index = index;
            this.builder = new ExtensionsV1beta1IDRangeBuilder(this, item);
        }

        RangesNestedImpl() {
            this.index = -1;
            this.builder = new ExtensionsV1beta1IDRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExtensionsV1beta1RunAsUserStrategyOptionsFluentImpl.this.setToRanges(this.index, this.builder.build());
        }

        @Override
        public N endRange() {
            return this.and();
        }
    }
}

