/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta1ApplyConfiguration;
import io.kubernetes.client.openapi.models.V1beta1JSONPatch;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Mutation specifies the CEL expression which is used to apply the Mutation.")
public class V1beta1Mutation {
    public static final String SERIALIZED_NAME_APPLY_CONFIGURATION = "applyConfiguration";
    @SerializedName(value="applyConfiguration")
    @Nullable
    private V1beta1ApplyConfiguration applyConfiguration;
    public static final String SERIALIZED_NAME_JSON_PATCH = "jsonPatch";
    @SerializedName(value="jsonPatch")
    @Nullable
    private V1beta1JSONPatch jsonPatch;
    public static final String SERIALIZED_NAME_PATCH_TYPE = "patchType";
    @SerializedName(value="patchType")
    @Nonnull
    private String patchType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1Mutation applyConfiguration(@Nullable V1beta1ApplyConfiguration applyConfiguration) {
        this.applyConfiguration = applyConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1ApplyConfiguration getApplyConfiguration() {
        return this.applyConfiguration;
    }

    public void setApplyConfiguration(@Nullable V1beta1ApplyConfiguration applyConfiguration) {
        this.applyConfiguration = applyConfiguration;
    }

    public V1beta1Mutation jsonPatch(@Nullable V1beta1JSONPatch jsonPatch) {
        this.jsonPatch = jsonPatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1JSONPatch getJsonPatch() {
        return this.jsonPatch;
    }

    public void setJsonPatch(@Nullable V1beta1JSONPatch jsonPatch) {
        this.jsonPatch = jsonPatch;
    }

    public V1beta1Mutation patchType(@Nonnull String patchType) {
        this.patchType = patchType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="patchType indicates the patch strategy used. Allowed values are \"ApplyConfiguration\" and \"JSONPatch\". Required.")
    public String getPatchType() {
        return this.patchType;
    }

    public void setPatchType(@Nonnull String patchType) {
        this.patchType = patchType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1Mutation v1beta1Mutation = (V1beta1Mutation)o;
        return Objects.equals(this.applyConfiguration, v1beta1Mutation.applyConfiguration) && Objects.equals(this.jsonPatch, v1beta1Mutation.jsonPatch) && Objects.equals(this.patchType, v1beta1Mutation.patchType);
    }

    public int hashCode() {
        return Objects.hash(this.applyConfiguration, this.jsonPatch, this.patchType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1Mutation {\n");
        sb.append("    applyConfiguration: ").append(this.toIndentedString(this.applyConfiguration)).append("\n");
        sb.append("    jsonPatch: ").append(this.toIndentedString(this.jsonPatch)).append("\n");
        sb.append("    patchType: ").append(this.toIndentedString(this.patchType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1Mutation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1Mutation` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_APPLY_CONFIGURATION) != null && !jsonObj.get(SERIALIZED_NAME_APPLY_CONFIGURATION).isJsonNull()) {
            V1beta1ApplyConfiguration.validateJsonElement(jsonObj.get(SERIALIZED_NAME_APPLY_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_JSON_PATCH) != null && !jsonObj.get(SERIALIZED_NAME_JSON_PATCH).isJsonNull()) {
            V1beta1JSONPatch.validateJsonElement(jsonObj.get(SERIALIZED_NAME_JSON_PATCH));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATCH_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `patchType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATCH_TYPE).toString()));
        }
    }

    public static V1beta1Mutation fromJson(String jsonString) throws IOException {
        return (V1beta1Mutation)JSON.getGson().fromJson(jsonString, V1beta1Mutation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_APPLY_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_JSON_PATCH);
        openapiFields.add(SERIALIZED_NAME_PATCH_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PATCH_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1Mutation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1Mutation.class));
            return new TypeAdapter<V1beta1Mutation>(){

                public void write(JsonWriter out, V1beta1Mutation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1Mutation read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1Mutation.validateJsonElement(jsonElement);
                    return (V1beta1Mutation)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

