/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ClusterTrustBundleProjection;
import io.kubernetes.client.openapi.models.V1ConfigMapProjection;
import io.kubernetes.client.openapi.models.V1DownwardAPIProjection;
import io.kubernetes.client.openapi.models.V1PodCertificateProjection;
import io.kubernetes.client.openapi.models.V1SecretProjection;
import io.kubernetes.client.openapi.models.V1ServiceAccountTokenProjection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Projection that may be projected along with other supported volume types. Exactly one of these fields must be set.")
public class V1VolumeProjection {
    public static final String SERIALIZED_NAME_CLUSTER_TRUST_BUNDLE = "clusterTrustBundle";
    @SerializedName(value="clusterTrustBundle")
    @Nullable
    private V1ClusterTrustBundleProjection clusterTrustBundle;
    public static final String SERIALIZED_NAME_CONFIG_MAP = "configMap";
    @SerializedName(value="configMap")
    @Nullable
    private V1ConfigMapProjection configMap;
    public static final String SERIALIZED_NAME_DOWNWARD_A_P_I = "downwardAPI";
    @SerializedName(value="downwardAPI")
    @Nullable
    private V1DownwardAPIProjection downwardAPI;
    public static final String SERIALIZED_NAME_POD_CERTIFICATE = "podCertificate";
    @SerializedName(value="podCertificate")
    @Nullable
    private V1PodCertificateProjection podCertificate;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    @Nullable
    private V1SecretProjection secret;
    public static final String SERIALIZED_NAME_SERVICE_ACCOUNT_TOKEN = "serviceAccountToken";
    @SerializedName(value="serviceAccountToken")
    @Nullable
    private V1ServiceAccountTokenProjection serviceAccountToken;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1VolumeProjection clusterTrustBundle(@Nullable V1ClusterTrustBundleProjection clusterTrustBundle) {
        this.clusterTrustBundle = clusterTrustBundle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ClusterTrustBundleProjection getClusterTrustBundle() {
        return this.clusterTrustBundle;
    }

    public void setClusterTrustBundle(@Nullable V1ClusterTrustBundleProjection clusterTrustBundle) {
        this.clusterTrustBundle = clusterTrustBundle;
    }

    public V1VolumeProjection configMap(@Nullable V1ConfigMapProjection configMap) {
        this.configMap = configMap;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ConfigMapProjection getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(@Nullable V1ConfigMapProjection configMap) {
        this.configMap = configMap;
    }

    public V1VolumeProjection downwardAPI(@Nullable V1DownwardAPIProjection downwardAPI) {
        this.downwardAPI = downwardAPI;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1DownwardAPIProjection getDownwardAPI() {
        return this.downwardAPI;
    }

    public void setDownwardAPI(@Nullable V1DownwardAPIProjection downwardAPI) {
        this.downwardAPI = downwardAPI;
    }

    public V1VolumeProjection podCertificate(@Nullable V1PodCertificateProjection podCertificate) {
        this.podCertificate = podCertificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodCertificateProjection getPodCertificate() {
        return this.podCertificate;
    }

    public void setPodCertificate(@Nullable V1PodCertificateProjection podCertificate) {
        this.podCertificate = podCertificate;
    }

    public V1VolumeProjection secret(@Nullable V1SecretProjection secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretProjection getSecret() {
        return this.secret;
    }

    public void setSecret(@Nullable V1SecretProjection secret) {
        this.secret = secret;
    }

    public V1VolumeProjection serviceAccountToken(@Nullable V1ServiceAccountTokenProjection serviceAccountToken) {
        this.serviceAccountToken = serviceAccountToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ServiceAccountTokenProjection getServiceAccountToken() {
        return this.serviceAccountToken;
    }

    public void setServiceAccountToken(@Nullable V1ServiceAccountTokenProjection serviceAccountToken) {
        this.serviceAccountToken = serviceAccountToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeProjection v1VolumeProjection = (V1VolumeProjection)o;
        return Objects.equals(this.clusterTrustBundle, v1VolumeProjection.clusterTrustBundle) && Objects.equals(this.configMap, v1VolumeProjection.configMap) && Objects.equals(this.downwardAPI, v1VolumeProjection.downwardAPI) && Objects.equals(this.podCertificate, v1VolumeProjection.podCertificate) && Objects.equals(this.secret, v1VolumeProjection.secret) && Objects.equals(this.serviceAccountToken, v1VolumeProjection.serviceAccountToken);
    }

    public int hashCode() {
        return Objects.hash(this.clusterTrustBundle, this.configMap, this.downwardAPI, this.podCertificate, this.secret, this.serviceAccountToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeProjection {\n");
        sb.append("    clusterTrustBundle: ").append(this.toIndentedString(this.clusterTrustBundle)).append("\n");
        sb.append("    configMap: ").append(this.toIndentedString(this.configMap)).append("\n");
        sb.append("    downwardAPI: ").append(this.toIndentedString(this.downwardAPI)).append("\n");
        sb.append("    podCertificate: ").append(this.toIndentedString(this.podCertificate)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    serviceAccountToken: ").append(this.toIndentedString(this.serviceAccountToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1VolumeProjection is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1VolumeProjection` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CLUSTER_TRUST_BUNDLE) != null && !jsonObj.get(SERIALIZED_NAME_CLUSTER_TRUST_BUNDLE).isJsonNull()) {
            V1ClusterTrustBundleProjection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CLUSTER_TRUST_BUNDLE));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG_MAP) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG_MAP).isJsonNull()) {
            V1ConfigMapProjection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG_MAP));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOWNWARD_A_P_I) != null && !jsonObj.get(SERIALIZED_NAME_DOWNWARD_A_P_I).isJsonNull()) {
            V1DownwardAPIProjection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DOWNWARD_A_P_I));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_CERTIFICATE) != null && !jsonObj.get(SERIALIZED_NAME_POD_CERTIFICATE).isJsonNull()) {
            V1PodCertificateProjection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_POD_CERTIFICATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_SECRET).isJsonNull()) {
            V1SecretProjection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECRET));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_TOKEN).isJsonNull()) {
            V1ServiceAccountTokenProjection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_TOKEN));
        }
    }

    public static V1VolumeProjection fromJson(String jsonString) throws IOException {
        return (V1VolumeProjection)JSON.getGson().fromJson(jsonString, V1VolumeProjection.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLUSTER_TRUST_BUNDLE);
        openapiFields.add(SERIALIZED_NAME_CONFIG_MAP);
        openapiFields.add(SERIALIZED_NAME_DOWNWARD_A_P_I);
        openapiFields.add(SERIALIZED_NAME_POD_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_SECRET);
        openapiFields.add(SERIALIZED_NAME_SERVICE_ACCOUNT_TOKEN);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1VolumeProjection.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1VolumeProjection.class));
            return new TypeAdapter<V1VolumeProjection>(){

                public void write(JsonWriter out, V1VolumeProjection value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1VolumeProjection read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1VolumeProjection.validateJsonElement(jsonElement);
                    return (V1VolumeProjection)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

