/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1alpha3DeviceTaintRule;
import io.kubernetes.client.openapi.models.V1alpha3DeviceTaintRuleList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ResourceV1alpha3Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ResourceV1alpha3Api() {
        this(Configuration.getDefaultApiClient());
    }

    public ResourceV1alpha3Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createDeviceTaintRuleCall(@Nonnull V1alpha3DeviceTaintRule body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha3DeviceTaintRule localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/devicetaintrules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDeviceTaintRuleValidateBeforeCall(@Nonnull V1alpha3DeviceTaintRule body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDeviceTaintRule(Async)");
        }
        return this.createDeviceTaintRuleCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha3DeviceTaintRule> createDeviceTaintRuleWithHttpInfo(@Nonnull V1alpha3DeviceTaintRule body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createDeviceTaintRuleValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createDeviceTaintRuleAsync(@Nonnull V1alpha3DeviceTaintRule body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
        Call localVarCall = this.createDeviceTaintRuleValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateDeviceTaintRuleRequest createDeviceTaintRule(@Nonnull V1alpha3DeviceTaintRule body) {
        return new APIcreateDeviceTaintRuleRequest(body);
    }

    private Call deleteCollectionDeviceTaintRuleCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/devicetaintrules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionDeviceTaintRuleValidateBeforeCall(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        return this.deleteCollectionDeviceTaintRuleCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionDeviceTaintRuleWithHttpInfo(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionDeviceTaintRuleValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionDeviceTaintRuleAsync(@Nullable String pretty, @Nullable String _continue, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable String labelSelector, @Nullable Integer limit, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionDeviceTaintRuleValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionDeviceTaintRuleRequest deleteCollectionDeviceTaintRule() {
        return new APIdeleteCollectionDeviceTaintRuleRequest();
    }

    private Call deleteDeviceTaintRuleCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/devicetaintrules/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDeviceTaintRuleValidateBeforeCall(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDeviceTaintRule(Async)");
        }
        return this.deleteDeviceTaintRuleCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1alpha3DeviceTaintRule> deleteDeviceTaintRuleWithHttpInfo(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteDeviceTaintRuleValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteDeviceTaintRuleAsync(@Nonnull String name, @Nullable String pretty, @Nullable String dryRun, @Nullable Integer gracePeriodSeconds, @Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable V1DeleteOptions body, ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
        Call localVarCall = this.deleteDeviceTaintRuleValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteDeviceTaintRuleRequest deleteDeviceTaintRule(@Nonnull String name) {
        return new APIdeleteDeviceTaintRuleRequest(name);
    }

    private Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAPIResourcesCall(_callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources() {
        return new APIgetAPIResourcesRequest();
    }

    private Call listDeviceTaintRuleCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/devicetaintrules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeviceTaintRuleValidateBeforeCall(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listDeviceTaintRuleCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha3DeviceTaintRuleList> listDeviceTaintRuleWithHttpInfo(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listDeviceTaintRuleValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRuleList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeviceTaintRuleAsync(@Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Boolean sendInitialEvents, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<V1alpha3DeviceTaintRuleList> _callback) throws ApiException {
        Call localVarCall = this.listDeviceTaintRuleValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRuleList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeviceTaintRuleRequest listDeviceTaintRule() {
        return new APIlistDeviceTaintRuleRequest();
    }

    private Call patchDeviceTaintRuleCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/devicetaintrules/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchDeviceTaintRuleValidateBeforeCall(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchDeviceTaintRule(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchDeviceTaintRule(Async)");
        }
        return this.patchDeviceTaintRuleCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha3DeviceTaintRule> patchDeviceTaintRuleWithHttpInfo(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchDeviceTaintRuleValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchDeviceTaintRuleAsync(@Nonnull String name, @Nonnull V1Patch body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
        Call localVarCall = this.patchDeviceTaintRuleValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchDeviceTaintRuleRequest patchDeviceTaintRule(@Nonnull String name, @Nonnull V1Patch body) {
        return new APIpatchDeviceTaintRuleRequest(name, body);
    }

    private Call readDeviceTaintRuleCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/devicetaintrules/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readDeviceTaintRuleValidateBeforeCall(@Nonnull String name, @Nullable String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readDeviceTaintRule(Async)");
        }
        return this.readDeviceTaintRuleCall(name, pretty, _callback);
    }

    private ApiResponse<V1alpha3DeviceTaintRule> readDeviceTaintRuleWithHttpInfo(@Nonnull String name, @Nullable String pretty) throws ApiException {
        Call localVarCall = this.readDeviceTaintRuleValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readDeviceTaintRuleAsync(@Nonnull String name, @Nullable String pretty, ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
        Call localVarCall = this.readDeviceTaintRuleValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadDeviceTaintRuleRequest readDeviceTaintRule(@Nonnull String name) {
        return new APIreadDeviceTaintRuleRequest(name);
    }

    private Call replaceDeviceTaintRuleCall(@Nonnull String name, @Nonnull V1alpha3DeviceTaintRule body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha3DeviceTaintRule localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha3/devicetaintrules/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceDeviceTaintRuleValidateBeforeCall(@Nonnull String name, @Nonnull V1alpha3DeviceTaintRule body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceDeviceTaintRule(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceDeviceTaintRule(Async)");
        }
        return this.replaceDeviceTaintRuleCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha3DeviceTaintRule> replaceDeviceTaintRuleWithHttpInfo(@Nonnull String name, @Nonnull V1alpha3DeviceTaintRule body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceDeviceTaintRuleValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceDeviceTaintRuleAsync(@Nonnull String name, @Nonnull V1alpha3DeviceTaintRule body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
        Call localVarCall = this.replaceDeviceTaintRuleValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha3DeviceTaintRule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceDeviceTaintRuleRequest replaceDeviceTaintRule(@Nonnull String name, @Nonnull V1alpha3DeviceTaintRule body) {
        return new APIreplaceDeviceTaintRuleRequest(name, body);
    }

    public class APIcreateDeviceTaintRuleRequest {
        @Nonnull
        private final V1alpha3DeviceTaintRule body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateDeviceTaintRuleRequest(V1alpha3DeviceTaintRule body) {
            this.body = body;
        }

        public APIcreateDeviceTaintRuleRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateDeviceTaintRuleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateDeviceTaintRuleRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateDeviceTaintRuleRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha3Api.this.createDeviceTaintRuleCall(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha3DeviceTaintRule execute() throws ApiException {
            ApiResponse<V1alpha3DeviceTaintRule> localVarResp = ResourceV1alpha3Api.this.createDeviceTaintRuleWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha3DeviceTaintRule> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha3Api.this.createDeviceTaintRuleWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
            return ResourceV1alpha3Api.this.createDeviceTaintRuleAsync(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIdeleteCollectionDeviceTaintRuleRequest {
        @Nullable
        private String pretty;
        @Nullable
        private String _continue;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionDeviceTaintRuleRequest() {
        }

        public APIdeleteCollectionDeviceTaintRuleRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionDeviceTaintRuleRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha3Api.this.deleteCollectionDeviceTaintRuleCall(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = ResourceV1alpha3Api.this.deleteCollectionDeviceTaintRuleWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha3Api.this.deleteCollectionDeviceTaintRuleWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1alpha3Api.this.deleteCollectionDeviceTaintRuleAsync(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteDeviceTaintRuleRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteDeviceTaintRuleRequest(String name) {
            this.name = name;
        }

        public APIdeleteDeviceTaintRuleRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteDeviceTaintRuleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteDeviceTaintRuleRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteDeviceTaintRuleRequest ignoreStoreReadErrorWithClusterBreakingPotential(@Nullable Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteDeviceTaintRuleRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteDeviceTaintRuleRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteDeviceTaintRuleRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha3Api.this.deleteDeviceTaintRuleCall(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1alpha3DeviceTaintRule execute() throws ApiException {
            ApiResponse<V1alpha3DeviceTaintRule> localVarResp = ResourceV1alpha3Api.this.deleteDeviceTaintRuleWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha3DeviceTaintRule> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha3Api.this.deleteDeviceTaintRuleWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
            return ResourceV1alpha3Api.this.deleteDeviceTaintRuleAsync(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        private APIgetAPIResourcesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha3Api.this.getAPIResourcesCall(_callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse<V1APIResourceList> localVarResp = ResourceV1alpha3Api.this.getAPIResourcesWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha3Api.this.getAPIResourcesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return ResourceV1alpha3Api.this.getAPIResourcesAsync(_callback);
        }
    }

    public class APIlistDeviceTaintRuleRequest {
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Boolean sendInitialEvents;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistDeviceTaintRuleRequest() {
        }

        public APIlistDeviceTaintRuleRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistDeviceTaintRuleRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistDeviceTaintRuleRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistDeviceTaintRuleRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistDeviceTaintRuleRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistDeviceTaintRuleRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeviceTaintRuleRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistDeviceTaintRuleRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistDeviceTaintRuleRequest sendInitialEvents(@Nullable Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistDeviceTaintRuleRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistDeviceTaintRuleRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha3Api.this.listDeviceTaintRuleCall(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha3DeviceTaintRuleList execute() throws ApiException {
            ApiResponse<V1alpha3DeviceTaintRuleList> localVarResp = ResourceV1alpha3Api.this.listDeviceTaintRuleWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha3DeviceTaintRuleList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha3Api.this.listDeviceTaintRuleWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha3DeviceTaintRuleList> _callback) throws ApiException {
            return ResourceV1alpha3Api.this.listDeviceTaintRuleAsync(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIpatchDeviceTaintRuleRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1Patch body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchDeviceTaintRuleRequest(@Nonnull String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchDeviceTaintRuleRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchDeviceTaintRuleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchDeviceTaintRuleRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchDeviceTaintRuleRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchDeviceTaintRuleRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha3Api.this.patchDeviceTaintRuleCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha3DeviceTaintRule execute() throws ApiException {
            ApiResponse<V1alpha3DeviceTaintRule> localVarResp = ResourceV1alpha3Api.this.patchDeviceTaintRuleWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha3DeviceTaintRule> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha3Api.this.patchDeviceTaintRuleWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
            return ResourceV1alpha3Api.this.patchDeviceTaintRuleAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIreadDeviceTaintRuleRequest {
        @Nonnull
        private final String name;
        @Nullable
        private String pretty;

        private APIreadDeviceTaintRuleRequest(String name) {
            this.name = name;
        }

        public APIreadDeviceTaintRuleRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha3Api.this.readDeviceTaintRuleCall(this.name, this.pretty, _callback);
        }

        public V1alpha3DeviceTaintRule execute() throws ApiException {
            ApiResponse<V1alpha3DeviceTaintRule> localVarResp = ResourceV1alpha3Api.this.readDeviceTaintRuleWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha3DeviceTaintRule> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha3Api.this.readDeviceTaintRuleWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
            return ResourceV1alpha3Api.this.readDeviceTaintRuleAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreplaceDeviceTaintRuleRequest {
        @Nonnull
        private final String name;
        @Nonnull
        private final V1alpha3DeviceTaintRule body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceDeviceTaintRuleRequest(@Nonnull String name, V1alpha3DeviceTaintRule body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceDeviceTaintRuleRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceDeviceTaintRuleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceDeviceTaintRuleRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceDeviceTaintRuleRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha3Api.this.replaceDeviceTaintRuleCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha3DeviceTaintRule execute() throws ApiException {
            ApiResponse<V1alpha3DeviceTaintRule> localVarResp = ResourceV1alpha3Api.this.replaceDeviceTaintRuleWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha3DeviceTaintRule> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha3Api.this.replaceDeviceTaintRuleWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha3DeviceTaintRule> _callback) throws ApiException {
            return ResourceV1alpha3Api.this.replaceDeviceTaintRuleAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }
}

