/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CustomObjectsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomObjectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createClusterCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull Object body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createClusterCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull Object body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling createClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling createClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling createClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createClusterCustomObject(Async)");
        }
        return this.createClusterCustomObjectCall(group, version, plural, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<Object> createClusterCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull Object body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createClusterCustomObjectValidateBeforeCall(group, version, plural, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createClusterCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull Object body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.createClusterCustomObjectValidateBeforeCall(group, version, plural, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateClusterCustomObjectRequest createClusterCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull Object body) {
        return new APIcreateClusterCustomObjectRequest(group, version, plural, body);
    }

    private Call createNamespacedCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull Object body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull Object body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling createNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling createNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling createNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedCustomObject(Async)");
        }
        return this.createNamespacedCustomObjectCall(group, version, namespace, plural, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<Object> createNamespacedCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull Object body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull Object body, @Nullable String pretty, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedCustomObjectRequest createNamespacedCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull Object body) {
        return new APIcreateNamespacedCustomObjectRequest(group, version, namespace, plural, body);
    }

    private Call deleteClusterCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteClusterCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteClusterCustomObject(Async)");
        }
        return this.deleteClusterCustomObjectCall(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
    }

    private ApiResponse<Object> deleteClusterCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteClusterCustomObjectValidateBeforeCall(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteClusterCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteClusterCustomObjectValidateBeforeCall(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteClusterCustomObjectRequest deleteClusterCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name) {
        return new APIdeleteClusterCustomObjectRequest(group, version, plural, name);
    }

    private Call deleteCollectionClusterCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nullable String pretty, @Nullable String labelSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionClusterCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nullable String pretty, @Nullable String labelSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteCollectionClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteCollectionClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteCollectionClusterCustomObject(Async)");
        }
        return this.deleteCollectionClusterCustomObjectCall(group, version, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
    }

    private ApiResponse<Object> deleteCollectionClusterCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nullable String pretty, @Nullable String labelSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionClusterCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nullable String pretty, @Nullable String labelSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionClusterCustomObjectRequest deleteCollectionClusterCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String plural) {
        return new APIdeleteCollectionClusterCustomObjectRequest(group, version, plural);
    }

    private Call deleteCollectionNamespacedCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nullable String pretty, @Nullable String labelSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nullable String pretty, @Nullable String labelSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteCollectionNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteCollectionNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteCollectionNamespacedCustomObject(Async)");
        }
        return this.deleteCollectionNamespacedCustomObjectCall(group, version, namespace, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, fieldSelector, body, _callback);
    }

    private ApiResponse<Object> deleteCollectionNamespacedCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nullable String pretty, @Nullable String labelSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, fieldSelector, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nullable String pretty, @Nullable String labelSelector, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable String fieldSelector, @Nullable V1DeleteOptions body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, labelSelector, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, fieldSelector, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedCustomObjectRequest deleteCollectionNamespacedCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural) {
        return new APIdeleteCollectionNamespacedCustomObjectRequest(group, version, namespace, plural);
    }

    private Call deleteNamespacedCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedCustomObject(Async)");
        }
        return this.deleteNamespacedCustomObjectCall(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
    }

    private ApiResponse<Object> deleteNamespacedCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nullable Integer gracePeriodSeconds, @Nullable Boolean orphanDependents, @Nullable String propagationPolicy, @Nullable String dryRun, @Nullable V1DeleteOptions body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedCustomObjectRequest deleteNamespacedCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name) {
        return new APIdeleteNamespacedCustomObjectRequest(group, version, namespace, plural, name);
    }

    private Call getAPIResourcesCall(@Nonnull String group, @Nonnull String version, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(@Nonnull String group, @Nonnull String version, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getAPIResources(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getAPIResources(Async)");
        }
        return this.getAPIResourcesCall(group, version, _callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo(@Nonnull String group, @Nonnull String version) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(group, version, null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(@Nonnull String group, @Nonnull String version, ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(group, version, _callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources(@Nonnull String group, @Nonnull String version) {
        return new APIgetAPIResourcesRequest(group, version);
    }

    private Call getClusterCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getClusterCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObject(Async)");
        }
        return this.getClusterCustomObjectCall(group, version, plural, name, _callback);
    }

    private ApiResponse<Object> getClusterCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectValidateBeforeCall(group, version, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getClusterCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectValidateBeforeCall(group, version, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetClusterCustomObjectRequest getClusterCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name) {
        return new APIgetClusterCustomObjectRequest(group, version, plural, name);
    }

    private Call getClusterCustomObjectScaleCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getClusterCustomObjectScaleValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObjectScale(Async)");
        }
        return this.getClusterCustomObjectScaleCall(group, version, plural, name, _callback);
    }

    private ApiResponse<Object> getClusterCustomObjectScaleWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getClusterCustomObjectScaleAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetClusterCustomObjectScaleRequest getClusterCustomObjectScale(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name) {
        return new APIgetClusterCustomObjectScaleRequest(group, version, plural, name);
    }

    private Call getClusterCustomObjectStatusCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getClusterCustomObjectStatusValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObjectStatus(Async)");
        }
        return this.getClusterCustomObjectStatusCall(group, version, plural, name, _callback);
    }

    private ApiResponse<Object> getClusterCustomObjectStatusWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getClusterCustomObjectStatusAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetClusterCustomObjectStatusRequest getClusterCustomObjectStatus(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name) {
        return new APIgetClusterCustomObjectStatusRequest(group, version, plural, name);
    }

    private Call getNamespacedCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacedCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObject(Async)");
        }
        return this.getNamespacedCustomObjectCall(group, version, namespace, plural, name, _callback);
    }

    private ApiResponse<Object> getNamespacedCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getNamespacedCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetNamespacedCustomObjectRequest getNamespacedCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name) {
        return new APIgetNamespacedCustomObjectRequest(group, version, namespace, plural, name);
    }

    private Call getNamespacedCustomObjectScaleCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacedCustomObjectScaleValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObjectScale(Async)");
        }
        return this.getNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, _callback);
    }

    private ApiResponse<Object> getNamespacedCustomObjectScaleWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getNamespacedCustomObjectScaleAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetNamespacedCustomObjectScaleRequest getNamespacedCustomObjectScale(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name) {
        return new APIgetNamespacedCustomObjectScaleRequest(group, version, namespace, plural, name);
    }

    private Call getNamespacedCustomObjectStatusCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacedCustomObjectStatusValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObjectStatus(Async)");
        }
        return this.getNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, _callback);
    }

    private ApiResponse<Object> getNamespacedCustomObjectStatusWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getNamespacedCustomObjectStatusAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetNamespacedCustomObjectStatusRequest getNamespacedCustomObjectStatus(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name) {
        return new APIgetNamespacedCustomObjectStatusRequest(group, version, namespace, plural, name);
    }

    private Call listClusterCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/json;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClusterCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling listClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling listClusterCustomObject(Async)");
        }
        return this.listClusterCustomObjectCall(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<Object> listClusterCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listClusterCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.listClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistClusterCustomObjectRequest listClusterCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String plural) {
        return new APIlistClusterCustomObjectRequest(group, version, plural);
    }

    private Call listCustomObjectForAllNamespacesCall(@Nonnull String group, @Nonnull String version, @Nonnull String resourcePlural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{resource_plural}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{resource_plural}", this.localVarApiClient.escapeString(resourcePlural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/json;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCustomObjectForAllNamespacesValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String resourcePlural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling listCustomObjectForAllNamespaces(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listCustomObjectForAllNamespaces(Async)");
        }
        if (resourcePlural == null) {
            throw new ApiException("Missing the required parameter 'resourcePlural' when calling listCustomObjectForAllNamespaces(Async)");
        }
        return this.listCustomObjectForAllNamespacesCall(group, version, resourcePlural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<Object> listCustomObjectForAllNamespacesWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String resourcePlural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listCustomObjectForAllNamespacesValidateBeforeCall(group, version, resourcePlural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCustomObjectForAllNamespacesAsync(@Nonnull String group, @Nonnull String version, @Nonnull String resourcePlural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.listCustomObjectForAllNamespacesValidateBeforeCall(group, version, resourcePlural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCustomObjectForAllNamespacesRequest listCustomObjectForAllNamespaces(@Nonnull String group, @Nonnull String version, @Nonnull String resourcePlural) {
        return new APIlistCustomObjectForAllNamespacesRequest(group, version, resourcePlural);
    }

    private Call listNamespacedCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/json;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling listNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling listNamespacedCustomObject(Async)");
        }
        return this.listNamespacedCustomObjectCall(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<Object> listNamespacedCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nullable String pretty, @Nullable Boolean allowWatchBookmarks, @Nullable String _continue, @Nullable String fieldSelector, @Nullable String labelSelector, @Nullable Integer limit, @Nullable String resourceVersion, @Nullable String resourceVersionMatch, @Nullable Integer timeoutSeconds, @Nullable Boolean watch, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedCustomObjectRequest listNamespacedCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural) {
        return new APIlistNamespacedCustomObjectRequest(group, version, namespace, plural);
    }

    private Call patchClusterCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchClusterCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObject(Async)");
        }
        return this.patchClusterCustomObjectCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<Object> patchClusterCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchClusterCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchClusterCustomObjectRequest patchClusterCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIpatchClusterCustomObjectRequest(group, version, plural, name, body);
    }

    private Call patchClusterCustomObjectScaleCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchClusterCustomObjectScaleValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObjectScale(Async)");
        }
        return this.patchClusterCustomObjectScaleCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<Object> patchClusterCustomObjectScaleWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchClusterCustomObjectScaleAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchClusterCustomObjectScaleRequest patchClusterCustomObjectScale(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIpatchClusterCustomObjectScaleRequest(group, version, plural, name, body);
    }

    private Call patchClusterCustomObjectStatusCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchClusterCustomObjectStatusValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObjectStatus(Async)");
        }
        return this.patchClusterCustomObjectStatusCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<Object> patchClusterCustomObjectStatusWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchClusterCustomObjectStatusAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchClusterCustomObjectStatusRequest patchClusterCustomObjectStatus(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIpatchClusterCustomObjectStatusRequest(group, version, plural, name, body);
    }

    private Call patchNamespacedCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObject(Async)");
        }
        return this.patchNamespacedCustomObjectCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<Object> patchNamespacedCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedCustomObjectRequest patchNamespacedCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIpatchNamespacedCustomObjectRequest(group, version, namespace, plural, name, body);
    }

    private Call patchNamespacedCustomObjectScaleCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedCustomObjectScaleValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObjectScale(Async)");
        }
        return this.patchNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<Object> patchNamespacedCustomObjectScaleWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedCustomObjectScaleAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedCustomObjectScaleRequest patchNamespacedCustomObjectScale(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIpatchNamespacedCustomObjectScaleRequest(group, version, namespace, plural, name, body);
    }

    private Call patchNamespacedCustomObjectStatusCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedCustomObjectStatusValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        return this.patchNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<Object> patchNamespacedCustomObjectStatusWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedCustomObjectStatusAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, @Nullable Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedCustomObjectStatusRequest patchNamespacedCustomObjectStatus(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIpatchNamespacedCustomObjectStatusRequest(group, version, namespace, plural, name, body);
    }

    private Call replaceClusterCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceClusterCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObject(Async)");
        }
        return this.replaceClusterCustomObjectCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<Object> replaceClusterCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceClusterCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceClusterCustomObjectRequest replaceClusterCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIreplaceClusterCustomObjectRequest(group, version, plural, name, body);
    }

    private Call replaceClusterCustomObjectScaleCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceClusterCustomObjectScaleValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObjectScale(Async)");
        }
        return this.replaceClusterCustomObjectScaleCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<Object> replaceClusterCustomObjectScaleWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceClusterCustomObjectScaleAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceClusterCustomObjectScaleRequest replaceClusterCustomObjectScale(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIreplaceClusterCustomObjectScaleRequest(group, version, plural, name, body);
    }

    private Call replaceClusterCustomObjectStatusCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceClusterCustomObjectStatusValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObjectStatus(Async)");
        }
        return this.replaceClusterCustomObjectStatusCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<Object> replaceClusterCustomObjectStatusWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceClusterCustomObjectStatusAsync(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceClusterCustomObjectStatusRequest replaceClusterCustomObjectStatus(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIreplaceClusterCustomObjectStatusRequest(group, version, plural, name, body);
    }

    private Call replaceNamespacedCustomObjectCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedCustomObjectValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObject(Async)");
        }
        return this.replaceNamespacedCustomObjectCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<Object> replaceNamespacedCustomObjectWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedCustomObjectAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedCustomObjectRequest replaceNamespacedCustomObject(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIreplaceNamespacedCustomObjectRequest(group, version, namespace, plural, name, body);
    }

    private Call replaceNamespacedCustomObjectScaleCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedCustomObjectScaleValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        return this.replaceNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<Object> replaceNamespacedCustomObjectScaleWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedCustomObjectScaleAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedCustomObjectScaleRequest replaceNamespacedCustomObjectScale(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIreplaceNamespacedCustomObjectScaleRequest(group, version, namespace, plural, name, body);
    }

    private Call replaceNamespacedCustomObjectStatusCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replace("{group}", this.localVarApiClient.escapeString(group.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString())).replace("{plural}", this.localVarApiClient.escapeString(plural.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedCustomObjectStatusValidateBeforeCall(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback _callback) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        return this.replaceNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<Object> replaceNamespacedCustomObjectStatusWithHttpInfo(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedCustomObjectStatusAsync(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body, @Nullable String dryRun, @Nullable String fieldManager, @Nullable String fieldValidation, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedCustomObjectStatusRequest replaceNamespacedCustomObjectStatus(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, @Nonnull Object body) {
        return new APIreplaceNamespacedCustomObjectStatusRequest(group, version, namespace, plural, name, body);
    }

    public class APIcreateClusterCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final Object body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateClusterCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, Object body) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.body = body;
        }

        public APIcreateClusterCustomObjectRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateClusterCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateClusterCustomObjectRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateClusterCustomObjectRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.createClusterCustomObjectCall(this.group, this.version, this.plural, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.createClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.createClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.createClusterCustomObjectAsync(this.group, this.version, this.plural, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateNamespacedCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final Object body;
        @Nullable
        private String pretty;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIcreateNamespacedCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, Object body) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.body = body;
        }

        public APIcreateNamespacedCustomObjectRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedCustomObjectRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedCustomObjectRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.createNamespacedCustomObjectCall(this.group, this.version, this.namespace, this.plural, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.createNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.createNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.createNamespacedCustomObjectAsync(this.group, this.version, this.namespace, this.plural, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIdeleteClusterCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String dryRun;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteClusterCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, String name) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
        }

        public APIdeleteClusterCustomObjectRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteClusterCustomObjectRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteClusterCustomObjectRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteClusterCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteClusterCustomObjectRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.deleteClusterCustomObjectCall(this.group, this.version, this.plural, this.name, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.deleteClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.name, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.deleteClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.name, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.deleteClusterCustomObjectAsync(this.group, this.version, this.plural, this.name, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body, _callback);
        }
    }

    public class APIdeleteCollectionClusterCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nullable
        private String pretty;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String dryRun;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionClusterCustomObjectRequest(@Nonnull String group, @Nonnull String version, String plural) {
            this.group = group;
            this.version = version;
            this.plural = plural;
        }

        public APIdeleteCollectionClusterCustomObjectRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionClusterCustomObjectRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionClusterCustomObjectRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionClusterCustomObjectRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionClusterCustomObjectRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionClusterCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionClusterCustomObjectRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.deleteCollectionClusterCustomObjectCall(this.group, this.version, this.plural, this.pretty, this.labelSelector, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.deleteCollectionClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.pretty, this.labelSelector, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.deleteCollectionClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.pretty, this.labelSelector, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.deleteCollectionClusterCustomObjectAsync(this.group, this.version, this.plural, this.pretty, this.labelSelector, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nullable
        private String pretty;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldSelector;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, String plural) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
        }

        public APIdeleteCollectionNamespacedCustomObjectRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedCustomObjectRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedCustomObjectRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedCustomObjectRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedCustomObjectRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedCustomObjectRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedCustomObjectRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.deleteCollectionNamespacedCustomObjectCall(this.group, this.version, this.namespace, this.plural, this.pretty, this.labelSelector, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.fieldSelector, this.body, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.deleteCollectionNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.pretty, this.labelSelector, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.fieldSelector, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.deleteCollectionNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.pretty, this.labelSelector, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.fieldSelector, this.body);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.deleteCollectionNamespacedCustomObjectAsync(this.group, this.version, this.namespace, this.plural, this.pretty, this.labelSelector, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.fieldSelector, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nullable
        private Integer gracePeriodSeconds;
        @Nullable
        private Boolean orphanDependents;
        @Nullable
        private String propagationPolicy;
        @Nullable
        private String dryRun;
        @Nullable
        private V1DeleteOptions body;

        private APIdeleteNamespacedCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, String name) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
        }

        public APIdeleteNamespacedCustomObjectRequest gracePeriodSeconds(@Nullable Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedCustomObjectRequest orphanDependents(@Nullable Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedCustomObjectRequest propagationPolicy(@Nullable String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedCustomObjectRequest body(@Nullable V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.deleteNamespacedCustomObjectCall(this.group, this.version, this.namespace, this.plural, this.name, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.deleteNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.deleteNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.deleteNamespacedCustomObjectAsync(this.group, this.version, this.namespace, this.plural, this.name, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.dryRun, this.body, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;

        private APIgetAPIResourcesRequest(@Nonnull String group, String version) {
            this.group = group;
            this.version = version;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.getAPIResourcesCall(this.group, this.version, _callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse<V1APIResourceList> localVarResp = CustomObjectsApi.this.getAPIResourcesWithHttpInfo(this.group, this.version);
            return localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.getAPIResourcesWithHttpInfo(this.group, this.version);
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return CustomObjectsApi.this.getAPIResourcesAsync(this.group, this.version, _callback);
        }
    }

    public class APIgetClusterCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;

        private APIgetClusterCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, String name) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectCall(this.group, this.version, this.plural, this.name, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.getClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.name);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.name);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectAsync(this.group, this.version, this.plural, this.name, _callback);
        }
    }

    public class APIgetClusterCustomObjectScaleRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;

        private APIgetClusterCustomObjectScaleRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, String name) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectScaleCall(this.group, this.version, this.plural, this.name, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.getClusterCustomObjectScaleWithHttpInfo(this.group, this.version, this.plural, this.name);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectScaleWithHttpInfo(this.group, this.version, this.plural, this.name);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectScaleAsync(this.group, this.version, this.plural, this.name, _callback);
        }
    }

    public class APIgetClusterCustomObjectStatusRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;

        private APIgetClusterCustomObjectStatusRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, String name) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectStatusCall(this.group, this.version, this.plural, this.name, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.getClusterCustomObjectStatusWithHttpInfo(this.group, this.version, this.plural, this.name);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectStatusWithHttpInfo(this.group, this.version, this.plural, this.name);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.getClusterCustomObjectStatusAsync(this.group, this.version, this.plural, this.name, _callback);
        }
    }

    public class APIgetNamespacedCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;

        private APIgetNamespacedCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, String name) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectCall(this.group, this.version, this.namespace, this.plural, this.name, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.getNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectAsync(this.group, this.version, this.namespace, this.plural, this.name, _callback);
        }
    }

    public class APIgetNamespacedCustomObjectScaleRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;

        private APIgetNamespacedCustomObjectScaleRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, String name) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectScaleCall(this.group, this.version, this.namespace, this.plural, this.name, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.getNamespacedCustomObjectScaleWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectScaleWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectScaleAsync(this.group, this.version, this.namespace, this.plural, this.name, _callback);
        }
    }

    public class APIgetNamespacedCustomObjectStatusRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;

        private APIgetNamespacedCustomObjectStatusRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, String name) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectStatusCall(this.group, this.version, this.namespace, this.plural, this.name, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.getNamespacedCustomObjectStatusWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectStatusWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.getNamespacedCustomObjectStatusAsync(this.group, this.version, this.namespace, this.plural, this.name, _callback);
        }
    }

    public class APIlistClusterCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistClusterCustomObjectRequest(@Nonnull String group, @Nonnull String version, String plural) {
            this.group = group;
            this.version = version;
            this.plural = plural;
        }

        public APIlistClusterCustomObjectRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistClusterCustomObjectRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistClusterCustomObjectRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistClusterCustomObjectRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistClusterCustomObjectRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistClusterCustomObjectRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistClusterCustomObjectRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistClusterCustomObjectRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistClusterCustomObjectRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistClusterCustomObjectRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.listClusterCustomObjectCall(this.group, this.version, this.plural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.listClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.listClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.listClusterCustomObjectAsync(this.group, this.version, this.plural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistCustomObjectForAllNamespacesRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String resourcePlural;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistCustomObjectForAllNamespacesRequest(@Nonnull String group, @Nonnull String version, String resourcePlural) {
            this.group = group;
            this.version = version;
            this.resourcePlural = resourcePlural;
        }

        public APIlistCustomObjectForAllNamespacesRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistCustomObjectForAllNamespacesRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.listCustomObjectForAllNamespacesCall(this.group, this.version, this.resourcePlural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.listCustomObjectForAllNamespacesWithHttpInfo(this.group, this.version, this.resourcePlural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.listCustomObjectForAllNamespacesWithHttpInfo(this.group, this.version, this.resourcePlural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.listCustomObjectForAllNamespacesAsync(this.group, this.version, this.resourcePlural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNamespacedCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nullable
        private String pretty;
        @Nullable
        private Boolean allowWatchBookmarks;
        @Nullable
        private String _continue;
        @Nullable
        private String fieldSelector;
        @Nullable
        private String labelSelector;
        @Nullable
        private Integer limit;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String resourceVersionMatch;
        @Nullable
        private Integer timeoutSeconds;
        @Nullable
        private Boolean watch;

        private APIlistNamespacedCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, String plural) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
        }

        public APIlistNamespacedCustomObjectRequest pretty(@Nullable String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest allowWatchBookmarks(@Nullable Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest _continue(@Nullable String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest fieldSelector(@Nullable String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest resourceVersionMatch(@Nullable String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedCustomObjectRequest watch(@Nullable Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.listNamespacedCustomObjectCall(this.group, this.version, this.namespace, this.plural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.listNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.listNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.listNamespacedCustomObjectAsync(this.group, this.version, this.namespace, this.plural, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIpatchClusterCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchClusterCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIpatchClusterCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchClusterCustomObjectRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchClusterCustomObjectRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchClusterCustomObjectRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectCall(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.patchClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectAsync(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchClusterCustomObjectScaleRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchClusterCustomObjectScaleRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIpatchClusterCustomObjectScaleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchClusterCustomObjectScaleRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchClusterCustomObjectScaleRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchClusterCustomObjectScaleRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectScaleCall(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.patchClusterCustomObjectScaleWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectScaleWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectScaleAsync(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchClusterCustomObjectStatusRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchClusterCustomObjectStatusRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIpatchClusterCustomObjectStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchClusterCustomObjectStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchClusterCustomObjectStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchClusterCustomObjectStatusRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectStatusCall(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.patchClusterCustomObjectStatusWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectStatusWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.patchClusterCustomObjectStatusAsync(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIpatchNamespacedCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedCustomObjectRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedCustomObjectRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedCustomObjectRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectCall(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.patchNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectAsync(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedCustomObjectScaleRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedCustomObjectScaleRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIpatchNamespacedCustomObjectScaleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedCustomObjectScaleRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedCustomObjectScaleRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedCustomObjectScaleRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectScaleCall(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.patchNamespacedCustomObjectScaleWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectScaleWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectScaleAsync(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedCustomObjectStatusRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;
        @Nullable
        private Boolean force;

        private APIpatchNamespacedCustomObjectStatusRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIpatchNamespacedCustomObjectStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedCustomObjectStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedCustomObjectStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedCustomObjectStatusRequest force(@Nullable Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectStatusCall(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.patchNamespacedCustomObjectStatusWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectStatusWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.patchNamespacedCustomObjectStatusAsync(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIreplaceClusterCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceClusterCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIreplaceClusterCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceClusterCustomObjectRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceClusterCustomObjectRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectCall(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.replaceClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectAsync(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceClusterCustomObjectScaleRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceClusterCustomObjectScaleRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIreplaceClusterCustomObjectScaleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceClusterCustomObjectScaleRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceClusterCustomObjectScaleRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectScaleCall(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.replaceClusterCustomObjectScaleWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectScaleWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectScaleAsync(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceClusterCustomObjectStatusRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceClusterCustomObjectStatusRequest(@Nonnull String group, @Nonnull String version, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIreplaceClusterCustomObjectStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceClusterCustomObjectStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceClusterCustomObjectStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectStatusCall(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.replaceClusterCustomObjectStatusWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectStatusWithHttpInfo(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.replaceClusterCustomObjectStatusAsync(this.group, this.version, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedCustomObjectRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedCustomObjectRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIreplaceNamespacedCustomObjectRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedCustomObjectRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedCustomObjectRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectCall(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.replaceNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectAsync(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedCustomObjectScaleRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedCustomObjectScaleRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIreplaceNamespacedCustomObjectScaleRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedCustomObjectScaleRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedCustomObjectScaleRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectScaleCall(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.replaceNamespacedCustomObjectScaleWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectScaleWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectScaleAsync(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedCustomObjectStatusRequest {
        @Nonnull
        private final String group;
        @Nonnull
        private final String version;
        @Nonnull
        private final String namespace;
        @Nonnull
        private final String plural;
        @Nonnull
        private final String name;
        @Nonnull
        private final Object body;
        @Nullable
        private String dryRun;
        @Nullable
        private String fieldManager;
        @Nullable
        private String fieldValidation;

        private APIreplaceNamespacedCustomObjectStatusRequest(@Nonnull String group, @Nonnull String version, @Nonnull String namespace, @Nonnull String plural, @Nonnull String name, Object body) {
            this.group = group;
            this.version = version;
            this.namespace = namespace;
            this.plural = plural;
            this.name = name;
            this.body = body;
        }

        public APIreplaceNamespacedCustomObjectStatusRequest dryRun(@Nullable String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedCustomObjectStatusRequest fieldManager(@Nullable String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedCustomObjectStatusRequest fieldValidation(@Nullable String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectStatusCall(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = CustomObjectsApi.this.replaceNamespacedCustomObjectStatusWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectStatusWithHttpInfo(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return CustomObjectsApi.this.replaceNamespacedCustomObjectStatusAsync(this.group, this.version, this.namespace, this.plural, this.name, this.body, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }
}

