/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta2CapacityRequirements;
import io.kubernetes.client.openapi.models.V1beta2DeviceSelector;
import io.kubernetes.client.openapi.models.V1beta2DeviceToleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.  DeviceSubRequest is similar to ExactDeviceRequest, but doesn't expose the AdminAccess field as that one is only supported when requesting a specific device.")
public class V1beta2DeviceSubRequest {
    public static final String SERIALIZED_NAME_ALLOCATION_MODE = "allocationMode";
    @SerializedName(value="allocationMode")
    private String allocationMode;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private V1beta2CapacityRequirements capacity;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Long count;
    public static final String SERIALIZED_NAME_DEVICE_CLASS_NAME = "deviceClassName";
    @SerializedName(value="deviceClassName")
    private String deviceClassName;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SELECTORS = "selectors";
    @SerializedName(value="selectors")
    private List<V1beta2DeviceSelector> selectors = null;
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    private List<V1beta2DeviceToleration> tolerations = null;

    public V1beta2DeviceSubRequest allocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllocationMode and its related fields define how devices are allocated to satisfy this subrequest. Supported values are:  - ExactCount: This request is for a specific number of devices.   This is the default. The exact number is provided in the   count field.  - All: This subrequest is for all of the matching devices in a pool.   Allocation will fail if some devices are already allocated,   unless adminAccess is requested.  If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other subrequests must specify this field.  More modes may get added in the future. Clients must refuse to handle requests with unknown modes.")
    public String getAllocationMode() {
        return this.allocationMode;
    }

    public void setAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
    }

    public V1beta2DeviceSubRequest capacity(V1beta2CapacityRequirements capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta2CapacityRequirements getCapacity() {
        return this.capacity;
    }

    public void setCapacity(V1beta2CapacityRequirements capacity) {
        this.capacity = capacity;
    }

    public V1beta2DeviceSubRequest count(Long count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count is used only when the count mode is \"ExactCount\". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.")
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public V1beta2DeviceSubRequest deviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return this;
    }

    @ApiModelProperty(required=true, value="DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.  A class is required. Which classes are available depends on the cluster.  Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.")
    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public void setDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
    }

    public V1beta2DeviceSubRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.  Must be a DNS label.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta2DeviceSubRequest selectors(List<V1beta2DeviceSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public V1beta2DeviceSubRequest addSelectorsItem(V1beta2DeviceSelector selectorsItem) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<V1beta2DeviceSelector>();
        }
        this.selectors.add(selectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this subrequest. All selectors must be satisfied for a device to be considered.")
    public List<V1beta2DeviceSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<V1beta2DeviceSelector> selectors) {
        this.selectors = selectors;
    }

    public V1beta2DeviceSubRequest tolerations(List<V1beta2DeviceToleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1beta2DeviceSubRequest addTolerationsItem(V1beta2DeviceToleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1beta2DeviceToleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the request's tolerations.  Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.  In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.  The maximum number of tolerations is 16.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta2DeviceToleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<V1beta2DeviceToleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceSubRequest v1beta2DeviceSubRequest = (V1beta2DeviceSubRequest)o;
        return Objects.equals(this.allocationMode, v1beta2DeviceSubRequest.allocationMode) && Objects.equals(this.capacity, v1beta2DeviceSubRequest.capacity) && Objects.equals(this.count, v1beta2DeviceSubRequest.count) && Objects.equals(this.deviceClassName, v1beta2DeviceSubRequest.deviceClassName) && Objects.equals(this.name, v1beta2DeviceSubRequest.name) && Objects.equals(this.selectors, v1beta2DeviceSubRequest.selectors) && Objects.equals(this.tolerations, v1beta2DeviceSubRequest.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.allocationMode, this.capacity, this.count, this.deviceClassName, this.name, this.selectors, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceSubRequest {\n");
        sb.append("    allocationMode: ").append(this.toIndentedString(this.allocationMode)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    deviceClassName: ").append(this.toIndentedString(this.deviceClassName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selectors: ").append(this.toIndentedString(this.selectors)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

