/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1beta2DeviceToleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceRequestAllocationResult contains the allocation result for one request.")
public class V1beta2DeviceRequestAllocationResult {
    public static final String SERIALIZED_NAME_ADMIN_ACCESS = "adminAccess";
    @SerializedName(value="adminAccess")
    private Boolean adminAccess;
    public static final String SERIALIZED_NAME_BINDING_CONDITIONS = "bindingConditions";
    @SerializedName(value="bindingConditions")
    private List<String> bindingConditions = null;
    public static final String SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS = "bindingFailureConditions";
    @SerializedName(value="bindingFailureConditions")
    private List<String> bindingFailureConditions = null;
    public static final String SERIALIZED_NAME_CONSUMED_CAPACITY = "consumedCapacity";
    @SerializedName(value="consumedCapacity")
    private Map<String, Quantity> consumedCapacity = null;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    private String device;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    private String pool;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private String request;
    public static final String SERIALIZED_NAME_SHARE_I_D = "shareID";
    @SerializedName(value="shareID")
    private String shareID;
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    private List<V1beta2DeviceToleration> tolerations = null;

    public V1beta2DeviceRequestAllocationResult adminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.  This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.")
    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public V1beta2DeviceRequestAllocationResult bindingConditions(List<String> bindingConditions) {
        this.bindingConditions = bindingConditions;
        return this;
    }

    public V1beta2DeviceRequestAllocationResult addBindingConditionsItem(String bindingConditionsItem) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        this.bindingConditions.add(bindingConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindingConditions contains a copy of the BindingConditions from the corresponding ResourceSlice at the time of allocation.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public List<String> getBindingConditions() {
        return this.bindingConditions;
    }

    public void setBindingConditions(List<String> bindingConditions) {
        this.bindingConditions = bindingConditions;
    }

    public V1beta2DeviceRequestAllocationResult bindingFailureConditions(List<String> bindingFailureConditions) {
        this.bindingFailureConditions = bindingFailureConditions;
        return this;
    }

    public V1beta2DeviceRequestAllocationResult addBindingFailureConditionsItem(String bindingFailureConditionsItem) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        this.bindingFailureConditions.add(bindingFailureConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindingFailureConditions contains a copy of the BindingFailureConditions from the corresponding ResourceSlice at the time of allocation.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public List<String> getBindingFailureConditions() {
        return this.bindingFailureConditions;
    }

    public void setBindingFailureConditions(List<String> bindingFailureConditions) {
        this.bindingFailureConditions = bindingFailureConditions;
    }

    public V1beta2DeviceRequestAllocationResult consumedCapacity(Map<String, Quantity> consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
        return this;
    }

    public V1beta2DeviceRequestAllocationResult putConsumedCapacityItem(String key, Quantity consumedCapacityItem) {
        if (this.consumedCapacity == null) {
            this.consumedCapacity = new HashMap<String, Quantity>();
        }
        this.consumedCapacity.put(key, consumedCapacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConsumedCapacity tracks the amount of capacity consumed per device as part of the claim request. The consumed amount may differ from the requested amount: it is rounded up to the nearest valid value based on the device\u2019s requestPolicy if applicable (i.e., may not be less than the requested amount).  The total consumed capacity for each device must not exceed the DeviceCapacity's Value.  This field is populated only for devices that allow multiple allocations. All capacity entries are included, even if the consumed amount is zero.")
    public Map<String, Quantity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(Map<String, Quantity> consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public V1beta2DeviceRequestAllocationResult device(String device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(required=true, value="Device references one device instance via its name in the driver's resource pool. It must be a DNS label.")
    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public V1beta2DeviceRequestAllocationResult driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1beta2DeviceRequestAllocationResult pool(String pool) {
        this.pool = pool;
        return this;
    }

    @ApiModelProperty(required=true, value="This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).  Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.")
    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public V1beta2DeviceRequestAllocationResult request(String request) {
        this.request = request;
        return this;
    }

    @ApiModelProperty(required=true, value="Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.  Multiple devices may have been allocated per request.")
    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public V1beta2DeviceRequestAllocationResult shareID(String shareID) {
        this.shareID = shareID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ShareID uniquely identifies an individual allocation share of the device, used when the device supports multiple simultaneous allocations. It serves as an additional map key to differentiate concurrent shares of the same device.")
    public String getShareID() {
        return this.shareID;
    }

    public void setShareID(String shareID) {
        this.shareID = shareID;
    }

    public V1beta2DeviceRequestAllocationResult tolerations(List<V1beta2DeviceToleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1beta2DeviceRequestAllocationResult addTolerationsItem(V1beta2DeviceToleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1beta2DeviceToleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A copy of all tolerations specified in the request at the time when the device got allocated.  The maximum number of tolerations is 16.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta2DeviceToleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<V1beta2DeviceToleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceRequestAllocationResult v1beta2DeviceRequestAllocationResult = (V1beta2DeviceRequestAllocationResult)o;
        return Objects.equals(this.adminAccess, v1beta2DeviceRequestAllocationResult.adminAccess) && Objects.equals(this.bindingConditions, v1beta2DeviceRequestAllocationResult.bindingConditions) && Objects.equals(this.bindingFailureConditions, v1beta2DeviceRequestAllocationResult.bindingFailureConditions) && Objects.equals(this.consumedCapacity, v1beta2DeviceRequestAllocationResult.consumedCapacity) && Objects.equals(this.device, v1beta2DeviceRequestAllocationResult.device) && Objects.equals(this.driver, v1beta2DeviceRequestAllocationResult.driver) && Objects.equals(this.pool, v1beta2DeviceRequestAllocationResult.pool) && Objects.equals(this.request, v1beta2DeviceRequestAllocationResult.request) && Objects.equals(this.shareID, v1beta2DeviceRequestAllocationResult.shareID) && Objects.equals(this.tolerations, v1beta2DeviceRequestAllocationResult.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.adminAccess, this.bindingConditions, this.bindingFailureConditions, this.consumedCapacity, this.device, this.driver, this.pool, this.request, this.shareID, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceRequestAllocationResult {\n");
        sb.append("    adminAccess: ").append(this.toIndentedString(this.adminAccess)).append("\n");
        sb.append("    bindingConditions: ").append(this.toIndentedString(this.bindingConditions)).append("\n");
        sb.append("    bindingFailureConditions: ").append(this.toIndentedString(this.bindingFailureConditions)).append("\n");
        sb.append("    consumedCapacity: ").append(this.toIndentedString(this.consumedCapacity)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    shareID: ").append(this.toIndentedString(this.shareID)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

